;===============================================================
;
;	Prom Based CP/M and ISIS 4 Init and BOOT routines
;
;                        Version 2.0 (2/8/2014)
;			 Version 2.1 (2/20/2014)
;
;  (original Ver.1.0 implemented by Kelly Smith, August 9, 1981)
;
;===============================================================
;
; This module contains the user input/output vectors used by ISIS II
; and a CP/M - ISIS cold boot loader/initialize.
;
true	equ	-1		; define value of true
false	equ	not true	; define value of false
debug	equ	false		; set true if setup assembly for 
				; ram based debug at 32 memory size
;monitor linkage

monitor	equ	0xf800

conin	equ	monitor+3	; console input
reader	equ	monitor+6	; reader input
conout	equ	monitor+9	; console output
punch	equ	monitor+12	; punch output
list	equ	monitor+15	; list output
const	equ	monitor+18	; console input status
iochk	equ	monitor+21	; I/O system status
ioset	equ	monitor+24	; set I/O configuration
memchk	equ	monitor+27	; compute size of memory
IODEF	equ	monitor+0x1e
IOCDR1	equ	monitor+0x21
;date 	equ	monitor+0x24
UI	equ	monitor+0x26
UO	equ	monitor+0x29
UPPS	equ	monitor+0x2c
;copyr	equ	monitor+0x2f
IOCCOM	equ	monitor+0x41
IOCDR2	equ	monitor+0x44
; the following two were added (not in original)
RESTART	equ	monitor+0x47	; breakpoinits
LSTS	equ	monitor+0x4a	; List Status for CPM 2.2
;
; define disk controller base addresses for operations
;
FDC78	equ	0x78
FDC88	equ	0x88
FDCstat	equ	0
FDCtype	equ	1
FDCbyte	equ	3
FDCilow	equ	1
FDCihi	equ	2
FDCres	equ	7

; IO definitions

cstat	equ	0xF7
cdata	equ	0xF6
crdyi	equ	0x02
crdyo	equ	0x01

tstat	equ	0xF5
tdata	equ	0xF4
trdyi	equ	0x02
trdyo	equ	0x01

; define stack top location
;
stack	equ	100h	; top of stack
;
; define ASCII character codes that are referenced
;
cr	equ	0dh		; ASCII cariage return
lf	equ	0ah		; ASCII linefeed
;
; define ISIS and CP/M storage locations and constants
;
iobyte	equ	0003h		; INTEL iobyte
initio	equ	0006h		; initial I/O config
memtop	equ	0004h		; location ISIS stores the top of ram
;
	if	debug
BBase	equ	07800h		; monitor start
memsiz	equ	32		; ram memory size in decimal kilo bytes
	endif			; debug
;
	if	not debug
BBase	equ	0E800h		; boot PROM start
memsiz	equ	62		; ram memory size in decimal kilo bytes
	endif			; not debug
;
memmax	equ	((memsiz*1024)/256)-1	; memory map area
date	equ	0715h		; date
verh	equ	10h		; version 1.0
;
	org	BBase+0x7ff
;
	db	0		; set version number of monitor
;
; start of CP/M and ISIS boot load point routine
;
	org	BBase		; origin of this program
;
	jmp	BS0		; reset entry point
INIT	db	10010100b	;initial IObyte
	dw	date		; date stamp 


; here to setup start of command inquiry loop to boot either
; a CP/M system disk of up to 62k size or to load an un-patched 
; ISIS 4.x system disk 
;
BS0:	
;	lxi	sp,stack	; set temp stack pointer
; put jump to monitor at zero
;
	mvi	a,0c3h		; put jump to monitor at 0
	sta	0000h
	lxi	h,monitor
	shld	0001h


; calculate top of memory and store at "memtop" for the ISIS 
; system operation
;
	lxi	h,03f00h	; start point for test
pag:	inr	h		; set to next page
	jz	fnd		; stop if at end
	mov	a,m		; get memory byte
	cma			; complement it
	mov	m,a		; put comp in memory
	cmp	m		; did it go in ok
	cma			; invert back
	mov	m,a		; restore original
	jz	pag		; loop to next 256 bytes if it changed
fnd:	dcx	h		; back up a page
	mov	a,h
	cpi	memmax		; less than f700h
	jc	x11		; if yes then use this value
;
fnd1:	mvi	h,memmax	; otherwise set memtop to 0f7ffh
;
x11:	shld	memtop		; set ISIS memory top address

; init monitor stack
	lxi	b,TOS		; template
	mov	l,c		;
	sphl			; set SP to TOS

; init monitor RAM
BS3	ldax	b
	mov	m,a
	inr	c
	inr	l
	jnz	BS3
;set up user SP
	mvi	l,0xd1
	mov	m,h
	dcr	m

; init restart at address 0 as JMP to RESTART
	mvi	a,0xc3
	sta	0
	lxi	h,RESTART
	shld	1

; test for console
	lxi	h,msgSP
	call	qmsg
;  list=lpt,punch=pun,reader=rdr,con=tty/crt

ttty	in 	tstat		;try TTY
	ani	trdyi		; if not ready
	jz	tcrt		; test CRT
	in	tdata		; read a character
	cpi	32		; is it a space
	jnz	tcrt
	mvi	a,10010100b	; console is tty
	jmp 	doIOb

tcrt	in 	cstat		;try CRT
	ani	crdyi		; if not ready
	jz	ttty		; tst TTY
	in	cdata		; read a character
	cpi	32		;is it a space
	jnz	ttty
	mvi	a,10010101b	; console is crt

doIOb	sta	iobyte
	sta	initio
;
	call	Type7888
;
;
; command check loop for monitor operation select
;
iboot:	lxi	h,stmsg		; point to start msg
	call	pmsg		; print message
iboot1:	call	conin		; wait for response
	push	psw		; echo operator response
	mov	c,a
	call	conout
	pop	psw
	ani	05fh		; convert input to upper case
	cpi	'M'		; check if Monitor
	jz	monitor
	cpi	'C'		; check if CP/M boot
	jz	cpmboot
	cpi	'I'		; or if ISIS boot
	jnz	iboot		; if neither then prompt again
;
; print ISIS prompt message and then load disk on input of a "cr"
;
isisboot:
;
	lxi	h,isisms	; print ISIS load message
	call	pmsg
	call	conin		; get ready status
	cpi	cr		; see if a cr
	jnz	iboot		; start all over if not ISIS boot
	call	pCRLF		; print carriage return linefeed
;

	lxi	h,bootpb
	push 	h

	call	DiskRd

	ora 	a
	jz	3000h		; if no errors goto ISIS
	
	call	outb		; write error code in binary
	lxi	h,bmsg
	call 	pmsg		; print boot error message
	jmp	iboot		; if error then go try for another command
;
; iopb for booting ISISt0 in to 3000h
;
bootpb:	db	80h		; iocw, no update bit set
	db	04h		; I/O instruction, read disk 0
	db	26		; read 26 sectors
	db	0		; track 0
	db	1		; sector 1
	dw	3000h		; load address
;
; print CP/M prompt message and then load disk on input of a "cr"
;
cpmboot:lxi	h,cpmms		; print CP/M load message
	call	pmsg
	call	conin		; get ready status
	cpi	cr		; see if a cr
	jnz	iboot		; start all over if not CP/M boot
	call	pCRLF		; print carriage return linefeed

;
; boot normal CP/M track zero sector 1 into ram at 3000 and
; jump to it to get in rest of CP/M
;
	lxi	h,cpmpb		; point to boot parameter block
	push 	h

	call	DiskRd		; read in disk

	ora	a
	jz	3000h		; if no errors goto CP/M loader

	call	outb		; write error code in binary
	lxi	h,bmsg
	call 	pmsg		; print boot error message
	jmp	iboot		; if error then go try for another command
;
; iopb for booting CP/M track 0 sector 1 into 0000h
;
cpmpb:	db	80h		; iocw, no update bit set
	db	04h		; I/O instruction, read disk 0
	db	01		; read one sector
	db	0		; track 0
	db	1		; sector 1
	dw	3000h		; load address

; Read FDC78
;
DiskRd	
	pop	h		;ret add in hl 
	xthl			;hl back on stack,PB in hl

Reset	xra	a		;zero dont care
	out	FDC78+FDCres	;reset FDC78

	in 	FDC78+FDCtype	; clear initial disk NRDY to RDY
	in 	FDC78+FDCbyte

	in	FDC78+FDCstat	;
	ani	1		; Drive 0
	jz	NRDY0		; drive 0 not ready

	mov	a,l		; point to boot parameter block
	out	FDC78+FDCilow	; 
	mov	a,h		; point to boot parameter block
	out	FDC78+FDCihi	; initiate read disk

PollFDC	in	FDC78+FDCstat	;
	ani	4
	jz	PollFDC

CHKtype	in 	FDC78+FDCtype
	ani	3
	cpi	2
	jnz	NOCHG	

;disk changed

CHGED	in 	FDC78+FDCbyte	;read Chg Vector

	in	FDC78+FDCstat
	ani	1		; Drive 0
	jz	NRDY0		; drive 0 not ready

	jmp 	CHKtype

NOCHG	ora	a		;look for 0
	jnz	Error		;must be zero

	in 	FDC78+FDCbyte
	ora	a
	jm	NRDY1		;NOt Ready
	ani	11011110b	;(nr we wp do ae se crc dr)
	jnz	Error		;some error
	xra	a		; make zero
	ret

NRDY0	mvi	a,0x80
NRDY1	ori	0x80
Error	ret	

Type7888
	in	FDC78+FDCstat	;
	ani	0x8
	jz	type88
	in	FDC78+FDCstat	;
	ani	0x10
	jz	sd78
	lxi	h,msgDD78
	call 	pmsg		; print DD at 78 message
	jmp	type88
sd78	lxi	h,msgSD78
	call 	pmsg		; print SD at 78 message
	
type88	in	FDC88+FDCstat	;
	ani	0x8
	rz	
	in	FDC88+FDCstat	;
	ani	0x10
	jz	sd88
	lxi	h,msgDD88
	call 	pmsg		; print DD at 88 message
	ret
sd88	lxi	h,msgSD88
	call 	pmsg		; print SD at 88 message
	ret



	ORG	BBase+0x2c8
TOS
USER	equ	TOS-8
ELOC	DB	0XEE
DLOC	DB	0XDD
CLOC	DB	0XCC
BLOC	DB	0XBB
	DB	1
ILOC	DB	0XFE
FLOC	DB	0XFF
ALOC	DB	0XAA
	DB	0XC0
SLOC	DB	0

EXIT	DI
	POP	D
	POP	B
	POP	PSW
	OUT	0XFC
	POP	PSW
	POP	H
	SPHL
	LXI	H,0X1234
LLOC	EQU	$-2
HLOC	EQU	$-1
	EI
	JMP	0X6789
PLOC	EQU	$-1
TLOC	DW	0
	DB	0
	DW	0
	DB	0
XTBL
CILOC	JMP	0
COLOC	JMP	0
R1LOC	JMP	0
R2LOC	JMP	0
P1LOC	JMP	0
P2LOC	JMP	0
L1LOC	JMP	0
CSLOC	JMP	0
ENDX

DIAGMN	EQU	0XEB00
DIAGBT	EQU	0XEB03
	ORG	DIAGMN
	RET
	NOP
	NOP
	RET
; print CRLF
pCRLF
	lxi	h,crlf
; print data pointed to by h and l until a zero is found
;
pmsg:	mov	a,m		; get character
	ora	a		; set flags
	rz			; ret if char is a zero
	mov	c,a		; put char in "c"
	call	conout		; print character
	inx	h		; bump message pointer
	jmp	pmsg		; do another character
;
qmsg:	mov	a,m		; get character
	ora	a		; set flags
	rz			; ret if char is a zero
	out	cdata		; output to CRT
	out	tdata		; output to TTY
	inx	h		; bump message pointer
	jmp	qmsg		; do another character

outb
	mvi	l,8
outb0	
	ral
	push	a
	jc	outb1
	mvi	c,'0'
	call	conout
	jmp	outb2
outb1	mvi	c,'1'
	call	conout
outb2	pop	a
	dcr	l
	jnz	outb0
	ret
	
; bios messages
;
stmsg:	db	cr,lf,cr,lf
	db	'ISIS Boot Ver 2.0'
	db	cr,lf,cr,lf
	db	' "I" to boot ISIS',cr,lf
	db	' "C" to boot CP/M ',cr,lf
	db	' "M" for Monitor - '
	db	0
isisms:	db	cr,lf,cr,lf,'Put ISIS disk in drive A:, type return ',0
cpmms:	db	cr,lf,cr,lf,'Put CP/M disk in drive A:, type return ',0
msgDD78 db	cr,lf,'Double Density Controller at 0x78 :F0:F1:F2:F3:',0
msgSD78 db	cr,lf,'Single Density Controller at 0x78 :F0:F1:',0
msgDD88 db	cr,lf,'Double Density Controller at 0x88 :F4:F5:F6:F7:',0
msgSD88 db	cr,lf,'Single Density Controller at 0x88 :F2:F3: or :F4:F5:',0
msgSp	db	cr,lf,'Press Spacebar to activate',0
;
crlf:	db	cr,lf,cr,lf,0
;
bmsg:	db	' - Error (nr we wp do ae se crc dr)',0
;
	end	BBase
