	.z80
; ASSEMBLE with AS8080
;
FALSE	EQU  0		;DEFINE VALUE OF FALSE.
TRUE	EQU  NOT FALSE	;DEFINE VALUE OF TRUE.
;
;********* THIS IS THE AREA TO MAKE CHANGES IN ***********
;********* FOR DIFFERENT SYSTEM CONFIGURATIONS ***********

MSIZE	EQU	64	;MEMORY SIZE IN DECIMAL KB.
SPT	EQU	72	;NUMBER OF SECTORS PER TRACK.
LDBASE	EQU  	0100h
NSECTS	EQU  	136	;SECTORS OF TurboDOS loader
LDADDR	equ	0100h	;load address 
EXADDR  equ	8100h	;Execute address

;*********************************************************
;*********************************************************

err$sts	equ	8

dsk$cmd 	equ 	0D0h 
dsk$sts 	equ 	0D0h 
dsk$drv		equ	0D1h ;drv
dsk$trkL	equ	0D2h ;trkLow
dsk$trkH	equ	0D3h ;trkHigh
dsk$secL	equ	0D4h ;secLow
dsk$secH	equ	0D5h ;secHigh
dsk$dmaL	equ	0D6h ;dmaLow
dsk$dmaH	equ	0D7h ;dmaHigh
dsk$sptL	equ	0D8h ;sptLow
dsk$sptH	equ	0D9h ;sptHigh

cmd$read	equ	1
cmd$write	equ	2
cmd$log		equ	4
cmd$fmt		equ	8

sec$sz	equ	128


	ORG  100h	;START OF LOADER.

BOOT:	
	LXI  SP,100H	;SET STACK POINTER.
	xra	a
	sta	080h	;make CMDline 0

; MOVE
	mvi	a,high(LDADDR)	; s =0100h
	out	0e5h		; source high
	mvi	a,high(EXADDR)	; s =8100h
	out	0e7h		; dest high
	mvi	a,00h
	out	0e4h		; source low
	out	0e6h		; dest low
	mvi	a,080h		;move 128 bytes
	out	0e8h		; count low
	mvi	a,00h		; move 128 bytes
	out	0e9h		; count high
; cmd=move s to d, but only to/from common, above boundary
	mvi	a,04h	
	out	0e0h	; single thread, no need to wait
; /move

	jmp	BOOTER+EXADDR-0100h	;jmp to new copy

BOOTER:
	xra	a
	out	dsk$trkL
	out	dsk$trkH
	out	dsk$secH
	out 	dsk$drv
	LXI  	H,LDBASE	;TurboDOS loader STARTS HERE.
	MVI  	B,NSECTS	;NUMBER OF SECTORS TO READ.
	MVI  	C,9		;SECTOR NUMBER.
RNTRK:	
	MOV  	A,C		;SECTOR IN A.

RNSEC:

; READ
;a=sector hl=dma bc=dont touch
	out	dsk$secL	;store next sector
	mov	a,l
	out	dsk$dmaL
	mov	a,h
	out	dsk$dmaH
	mvi	a,cmd$read	;read
	out	dsk$cmd
	in	dsk$sts
	ana	a		;set flags(ccr)
	jrnz	r$eror		;exit if error
	lxi	d,sec$sz	;sector size
	in	dsk$dmaL
	mov	l,a
	in	dsk$dmaH
	mov	h,a
	dad	d		;new buffer address 
; /read:
	DCR  	B		;IF DONE,
	JZ   	LDBASE		;GO TO TDOS Loader at 100h
	INR  	C		;INCREMENT SECTOR COUNT.
	MOV  	A,C		;DONE WITH
	CPI  	SPT+1		;THIS TRACK?
	JRC   	RNSEC		;IF NOT, READ NEXT SECTOR.
	in	dsk$trkL
	inr	a
	out	dsk$trkL
	MVI  	C,1		;SECTOR NUMBER.
	JMPR  	RNTRK		;READ NEXT TRACK.

r$eror:	 sta	err$sts		;store error 
	 hlt			;halt
	

EC:	END		;END OF BOOT.
