;This bit I wrote. It's a very short Intel hex loader. It assumes the record
;starts with ':' , that hex chars are 0-9 and A-F (not a-f) and does NO
;error checking whatsoever. It was shoehorned into the uProfessor ROM in the
;86 free bytes between 06E1 and 0737 and is 86 bytes long !

;	*********************************
;	*				*
;	*	8251 I/O Routines	*
;	*				*
;	*********************************

;	IO/M Addresses

;Assumes the uPF IO/M card is fitted. The UART is an 8251AF and the CTC is the
;standard Z80 type.

URTDA	EQU	60h	;8251 UART Data Port
URTCNT	EQU	61h	;8251 UART Control Port

CTC2	EQU	66h	;CTC Channel 2, Baud rate generator for UART

;	*********************************
;	*				*
;	*   Read Intel hex to memory	*
;	*				*
;	*********************************

;		Setup 8251 9600 baud 8N1

SETBD:	LD	A,#47h		;Counter mode, TC follows, Reset channel
	OUT	(CTC2),A	;CTC2 is baud rate gen for 8251
	LD	A,#03h		;Time const for 9600 baud
	OUT	(CTC2),A	;
	LD	HL,RESTAB	;Reset sequence for 8251
	LD	B,#TABEND-RESTAB;Table length
	LD	C,#URTCNT	;Point to control port
	OTIR			;OUT and loop until done

;	*********************************
;	*				*
;	*     Get Intel hex record	*
;	*				*
;	*********************************

;Short version - no checksum calculation.

INTLIN:	CALL	CHRRD		;Get chr
	CP	#':'		;Is it ':'?
	JR	NZ,INTLIN	;If not then next
	CALL	BYTERD		;Get record length
	LD	B,A		;Put in B
	CALL	BYTERD		;Get record address hi byte
	LD	H,A		;Put in H
	CALL	BYTERD		;Get record address lo byte
	LD	L,A		;Put in L
	CALL	BYTERD		;Ignore record type
DATAIN:	CALL	BYTERD		;Get record data byte
	LD	(HL),A		;Save byte to memory
	INC	HL		;Next address
	DJNZ	DATAIN		;Decrement count and jump if not finished
	JR	INTLIN		;Ignore checksum byte and [CR][LF]

;	*********************************
;	*				*
;	*	8251 Character in	*
;	*				*
;	*********************************

CHRRD:	IN	A,(URTCNT)	;Get status byte
	BIT	1,A		;Check buffer full bti
	JR	Z,CHRRD		;Not full so wait
	IN	A,(URTDA)	;Get byte from buffer
	RET			;

;	*********************************
;	*				*
;	* Get 2 ASCII chrs as hex byte	*
;	*				*
;	*********************************

BYTERD:	LD	D,#00h		;Set up
	CALL	HEXCON		;Get byte and convert to hex
	ADD	A,A		;First nibble so
	ADD	A,A		;multiply by 16
	ADD	A,A		;
	ADD	A,A		;
	LD	D,A		;Save hi nibble in D
HEXCON:	CALL	CHRRD		;Get next chr
	SUB	#30h		;Makes '0'-'9' equal 0-9
	CP	#0Ah		;Is it 0-9 ?
	JR	C,NALPHA	;If so miss next bit
	SUB	#07h		;Else convert alpha
NALPHA:	OR	D		;Add hi nibble back
	RET			;

;Byte sequence to set up 8251

RESTAB:	DB	00h,00h,00h,40h,4Eh,37h
TABEND:


