;************************************************************************
;*  Z80 Assembler program til NICD-Kondi-Computer m. LCD-display.       *
;*  3. Semester afgangsprojekt af Thomas Scherrer og Kenny Andersen     *
;*  Ved Frederiksberg Tekniske Skole.                                   *
;*  History:                                                            *
;*  30/11 93 v1.00 afleveret til skole                                  *
;*  16/11 94 v1.01 DEMO og INFO i ANDET menu                            *
;*  21/11 94 v1.02 Bedre: RAM_TEST, DEFAULT, +NMI, KODE-BESKYTTELSE     *
;*  22/11 94 v1.03 Scroll demo addet  *# = bladre frem og tilbage       *
;*  24/11 94 v1.04 Ny skriv der kan tage , Engelsk, Tysk             *
;*  12/12 94 v1.04 Mange fejl rettet, bla i kondi.                      *
;*  16/12 94 v1.04 Fransk sprog indsat (tak jacob) ingen kendte fejl    *
;*  17/12 94 v1.05 Input kan variere i txt lngde, SKAL slute med >     *
;*  13/4  95 v2.00 Nyt print, UART, PIO, nyt display helt ny hardware   *
;*  21/7  95 v2.01 Test routiner, TYSK og FRANSK fjernet                *
;*  20/12 95 v2.02 Tasm bliver nu brugt, engelsk fjernet                *
;*  25/12 95 v2.03 Includes bliver brugt til sample og teksten          *
;*  28/12 95 v2.04 Ny keyboardScan, nye lyde, ny skriv, bedre tekst mm. *
;*  30/12 95 v2.05 Aflader skriver ogs batt. volt mange fejl rettet.   *
;*  1/1   96 v2.06 Seriel kommando fra pc  (test)                       *
;*  6/1   96 v2.07 Subs ret s de ogs klare ser output, uart init fix  *
;*  15/2  96 v2.08 Skriv rettet s den virker med  og $0,$1,$2       *
;*  25/2  96 v2.09 Overtemp virker i op. af. kondi. PolTest gir kun lyd *
;************************************************************************

             .ORG    $8000
RAMSTART     .DS     256            ; RAM start adresse (256 test adr)
KODERUN      .DS     1              ; Til at se om der skal indtastes koden.
KODE_DAG1    .DS     1              ; Antal dage til kode enere
KODE_DAG10:  .DS     1              ; Antal dage til kode tiere
KOD_RETRY:   .DS     1              ; Hvis 0 s ok at taste kode ind...
KEYNR:       .DS     1              ; Keyboardtasten der sidst var trykket
OUTREG:      .DS     1              ; UART4 OUT kontrolord
INTTAL:      .DS     1              ; Interrupt-tller
VOLTBIN:     .DS     1              ; Spnding fra A/D-konverter
VOLTMIN:     .DS     1              ; Voltmeter minimum vrdi
VOLTMAX:     .DS     1              ; Voltmeter maximum vrdi
KEYBPREF:    .DS     1              ; Antal perioder p keyklik
LAD_STAT:    .DS     1              ; Til fortsttelse efter Netfejl
LADNING_OP:  .DS     1              ; 0=opladning frdig, 1=opfladning igang
STOP_TID:    .DS     1              ; 0=lade tllere krer. 1=pause.
SLUTPREF:    .DS     1              ; Hvilken slut lyd
SLUTLYD:     .DS     1              ; 0=Ingen slut lyd, 0FFH=Slut lyd ON
CURSORTYPE:  .DS     1              ; 0=NONE 1=BLINK 2=STREG
MODTAGEDATA: .DS     41             ; Til seriel modtagelse til display

BAT_KONDI:   .DS     1              ; Antal opladninger i et Kondi-forlb
BAT_KONDINR: .DS     1              ; Det Antal Kondi der er igang
BATT_NAVN:   .DS     17             ; Batteri navn ASCII-streng
BAT_KAP:     .DS     4              ; Batteri Kapacitet decimalt
BAT_KAPHEX:  .DS     2              ; Batteri kapacitet hexadecimalt
BAT_AF_mA:   .DS     4              ; Afladestrml kondi  
BAT_AF_HEX:  .DS     2              ; Afladestrm Hexadecimalt
BAT_AF_DAC:  .DS     1              ; Afladestrm til DA-Converter
BAT_OP_DAC:  .DS     1              ; Opladestrm til DA-Converter
BAT_OP_TIM:  .DS     2              ; Antal Oplade timer
BAT_CELLER:  .DS     2              ; Antal Celler i Batteriet
BAT_BATNR:   .DS     2              ; Batteri nr. i Data-Bank
MAALT_KAP:   .DS     6              ; Mlt kapacitet p batteri (ASCII)
MIN_VOLT:    .DS     1              ; Laveste spnding ved afladning
DIV_TAL:     .DS     2              ; Tallet der div. med nr % kap. skal udregnes
BANK_ADR:    .DS     2              ; Aktiv Bank Adresse 9000H-F300H 25Kb.
BANK_AKTIV:  .DS     1              ; Marker at der arbejdes med en Data-Bank
KONDI1PRCNT: .DS     4              ; SIDST MLTE KAP. DER VISES UNDER KONDI (---'STOP')
KONDI2PRCNT: .DS     4              ; NSTSIDST MLTE KAP. DER VISES UNDER KONDI (---'STOP')
KONDI3PRCNT: .DS     4              ; 3. SIDST MLTE KAP. DER VISES UNDER KONDI (---'STOP')

FORTRYDTAST: .DS     1              ; Test om der skal hoppes en menu tilbage
TASTEPEGER:  .DS     2              ; Her gemmes pegepinden i TASTEINPUT
TEMPGEM:     .DS     7              ; Til indtastninger. og Editor
TEMPDISP1:   .DS     41             ; Under pol fejl kopieres alt i displayet-
TEMPDISP2:   .DS     42             ; til ram, for at blive kopieret tilbage nr ok.
KARAKTER:    .DS     1              ; Til navne editor Karakter vrdi
KARAKPOS:    .DS     1              ; Til navne editor Position af tekst
VOLT_DISPA:  .DS     41             ; Startadr. p Voltmeter ASCII-streng linie 1
VOLT_DISPB:  .DS     42             ; Startadr. p Voltmeter ASCII-streng linie 2

SEK_EN:      .DS     1              ; Nedtller tid tndt, Sekund enere
SEK_TI:      .DS     1              ; Nedtller tid tndt, Sekund tiere
MIN_EN:      .DS     1              ; Nedtller tid tndt, Minut enere
MIN_TI:      .DS     1              ; Nedtller tid tndt, Minut tiere
TIM_EN:      .DS     1              ; Nedtller tid tndt, Time enere
TIM_TI:      .DS     1              ; Nedtller tid tndt, Time tiere
DAGE_TI:     .DS     1              ; Nedtller tid tndt, Dage tiere
DAGE_EN:     .DS     1              ; Nedtller tid tndt, Dage enere

AFLAD_1SEK:  .DS     1              ; Preset optller (aflad) 1 Sekund
AFLAD_2SEK:  .DS     2              ; Preset optller (aflad) 2 Sekund

OP_SEK_EN:   .DS     1              ; Preset nedtller (oplad) Sekund enere
OP_SEK_TI:   .DS     1              ; Preset nedtller (oplad) Sekund tiere
OP_MIN_EN:   .DS     1              ; Preset nedtller (oplad) Minut enere
OP_MIN_TI:   .DS     1              ; Preset nedtller (oplad) Minut tiere
OP_TIM_EN:   .DS     1              ; Preset nedtller (oplad) Time enere
OP_TIM_TI:   .DS     1              ; Preset nedtller (oplad) Time tiere

FEJLTEMP:    .DS     1              ; 0=OK  1=FOR-VARM.
FEJLPOL:     .DS     1              ; 0=OK  1=VNDER FORKERT.

SER_STRING:  .DS     20             ; MODTAGET TEKST FRA SER. PORT
SER_POINT:   .DS     1              ; POINTER TIL SER_STRING.
SER_ON:      .DS     1              ; OUTPUT TIL SER 1=ON 0=OFF
SER_BAUD:    .DS     1              ; 1=1200
UARTFEJL:    .DS     1              ; 1=FEJL 0=OK
DEBUG:       .DS     1              ; 1=ON   0=OFF
HELP:        .DS     1              ; 1=ON   0=OFF
DUMP_A_ASC:  .DS     5              ; DUMP START ADR. I ASCII
DUMP_A_BIN:  .DS     2              ; HI, LO BYTE ADR
DUMP_KARAK:  .DS     4              ; KARAKTER DER ER LST FRA RAM
DEBUG_EDIT:  .DS     1              ; I DEBUGGER, DATA EDIT ER ON/OFF.
EDIT_BIN:    .DS     1              ; DATA MAN INDTASTER, I BIN FORMAT.
TEMP_DEL1:   .DS     1              ; ENERE SEKUNDER TIL OVERTEMP PAUSE
TEMP_DEL10:  .DS     1              ; TIERE SEKUNDER TIL OVERTEMP PAUSE
TEMP_1GANG:  .DS     1              ; $FF VED START OP-AF-KONDI, LADE 10SEK.

             .ORG    $9000          ; Data bank startadresse. (1Bank=256Bytes)
BANK_TEST:   .DS     1              ; Batteri Data-Bank Test adr.
BANK_NAVN:   .DS     17             ; Batteri navn ASCII-streng i data bank
BANK_KAP:    .DS     4              ; Batteri Kapacitet
BANK_STROM:  .DS     4              ; Indtastet Afladestrm
BANK_TIMER:  .DS     2              ; Antal Oplade timer
BANK_CELLER: .DS     2              ; Antal Celler i Batteriet
BANK_OPDAC:  .DS     1              ; Oplade strm til DAC
BANK_AFDAC:  .DS     1              ; Aflade strm til DAC
BANK_DATA:   .DS     5              ; Frste kapasitets mling.


;********************* IO ADRESSER ***************************************
PIOA:        .EQU    0              ; (INPUT) 0-3=KEYS 4=POL 5=TEMP 6=ADCBUSY
PIOB:        .EQU    1              ; (IN/OUT) LCD-DISPLAY DATA
PIOC:        .EQU    2              ; (OUTPUT) 0-3=DISPLAY-CONTROL, 4-7=KEYS
PIOCONT:     .EQU    3              ; CONTROL AF PIO

UART0:       .EQU    8              ; DATA IN/OUT
UART1:       .EQU    9              ; CHECK RX
UART2:       .EQU    10             ; INTERRUPTS
UART3:       .EQU    11             ; LINE CONTROL
UART4:       .EQU    12             ; MODEM CONTROL 0=soff 1=rel 2=convert
UART5:       .EQU    13             ; LINE STATUS
UART6:       .EQU    14             ; MODEM STATUS
UART7:       .EQU    15             ; SCRATCH REG.

DACSTR0M:    .EQU    16             ; StrmGenerator
DACLYD:      .EQU    17             ; Hjttaler
ADC:         .EQU    24             ; MleSpnding


;********************* KONSTANTER ****************************************
MINCELLEVOLT .EQU    7              ; minimumsvolt pr. celle i 100 mVolt
RAMTOP:      .EQU    $FFFF          ; 32Kb RAM   8000H-FFFFH
STOP:        .EQU    $FF            ; Markerer at en tekstlinie er slut
DAC_FEJL:    .EQU    2              ; Antal bit, strmmen er for stor
NET_FREK:    .EQU    32             ; (32) INTERRUPTETS frekvens I Hz
CHK_POINT_B  .EQU    $1132          ; CHECK SUM POINTER  HI 8 BIT
CHK_POINT_C  .EQU    $0EE9          ; CHECK SUM POINTER  LO 8 BIT
KODE1:       .EQU    2              ; Access kode 1.cifer
KODE2:       .EQU    5              ; Access kode 2.cifer
KODE3:       .EQU    8              ; Access kode 3.cifer
KODE4:       .EQU    0              ; Access kode 4.cifer
FINAL:       .EQU    0              ; 1=FINAL 0=DEVELOP  ( i final er -  )
LAVFINAL:    .EQU    0              ; 1=LAV   0=DEVELOP  ( LAV ogs =1   )


;*******************************************************************
;*        OPSTART EFTER RESET, kan ogs kaldes fra softwaren       *
;*        Funktion....: Klargr system og restart                  *
;*******************************************************************
             .ORG    0
             DI                    ; Disable interrupt
             LD     SP,RAMTOP      ; Set stack pointer i top af ram
             IM     1              ; Set interrupt mode 1
             JP     $100           ; Hop til Start af program

             .byte "       -NICD COMPUTER-"  ; tekst streng i rom
             .byte " V 2.09"
             .byte " FEB 1996 "

;************************************************************************
;*        INTERRUPT-PROGRAM                                             *
;*        Funktion....: Opdaterer keyboard, uret, Lser ADC, Tester pol.*
;*        Input.......: Intet                                           *
;*        Output......: Antal interrupt p adr.  INTTAL OG KOMPLET UR   *
;*        delgger...: Kun alternative registre.                       *
;*        Kalder......: POL_OG_TEMP, UR_REAL, KEYB_SCAN, SERIAL         *
;*        Initialer...: TST.  dato: 27/10-95                            *
;************************************************************************
             .ORG   $38            ; Int mode 1
             DI
             EXX
             EX     AF,AF'
             LD     A,(OUTREG)     ; Hent bitmaske til output port
             SET    2,A            ; RESET bit 2 (lav)
             OUT    (UART4),A      ; AD-Converter WR lav
             RES    2,A            ; SET bit 2   (hj)
             OUT    (UART4),A      ; AD-Converter WR hj (Convertering startes)
             CALL   POL_OG_TEMP    ; Temperatur test, og batteri vnder forkert
             CALL   KEYB_SCAN      ; Tester keyboard
             CALL   UR_REAL        ; Opdaterer uret i ram register
             LD     A,(UARTFEJL)
             CP     1
             JP     Z,NOUART
             CALL   SERIAL         ; Styrer serial kontrol
CONV_BUSY:   IN     A,(PIOA)       ; Ls inputs fra PIO (med busy flag)
             BIT    6,A            ; Busy nr Bit 6=0
             JP     Z,CONV_BUSY    ; Tester om ADC er busy
             IN     A,(ADC)        ; Hent data fra converter.
             LD     (VOLTBIN),A    ; Gem volt-data i ram.
NOUART:      EX     AF,AF'
             EXX
             EI
             RETI






;*******************************************************************
;*        HOVED PROGRAM                                            *
;*        Funktion....: Styring af sub-rutiner                     *
;*        Input.......: Intet                                      *
;*        Output......: Intet                                      *
;*        delgger...: Intet                                      *
;*        Initialer...: TST.  dato: 24/1-96                        *
;*******************************************************************
             .ORG   $100
             LD     A,0
             OUT    (DACSTR0M),A   ; Strm = 0
             SET    1,A            ; Bit 1 = 1
             OUT    (UART4),A      ; rel slippes
             JP     ER_DER_RAM     ; HVIS DER IKKE ER RAM, KAN MAN IKKE CALLE
DER_ER_RAM:
             CALL   INIT_PIO
             CALL   INIT_LCD       ; Initialiser LCD-display
             CALL   INIT_UART      ; INIT OG TEST OM DER ER UART

.IF LAVFINAL=1
             CALL   LYDALARM1      ; 1 beep
             CALL   CHECKSUM       ; EPROM CHECKSUM
.ENDIF

             CALL   RAM_TEST       ; Test om RAM INDHOLD er ok.
             CALL   STARTUP        ; KLARGR HARDWARE

             CALL   STROM_OFF      ; Disable strmgenerator
             CALL   AFLAD_ON       ; Slipper rel VARIABLER SETTES

             EI                    ; Start tllere, og fejltestere
             LD     BC,1000
             CALL   PAUSE          ; Pause, s fejlpol. kan detekteres

             LD     A,(LAD_STAT)   ; Hent lade status  1=Oplade
             CP     1              ; 0=INGENTING       2=Aflade
             JP     Z,OP_NET_FEJL  ;                   3=Kondi Oplade
             CP     2              ;                   4=Kondi Aflade
             JP     Z,AF_NET_FEJL  ;
             CP     3              ; Der skal ikke indtastes kode-
             JP     Z,KO_NET_OP    ; hvis der skal fortsttes..
             CP     4
             JP     Z,KO_NET_FEJL

             CALL   KODETEST       ; Tester om der skal indtastes en kode.



HOVEDPRG:    CALL   CLS
             LD     HL,TXT_HOVED   ; 1:OPLADNING   3:KONDI
             CALL   SKRIV          ; 2:AFLADNING
HOVEDLOOP:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,OPLADPRG     ; Oplade program
             CP     2              ; 2 tasten
             JP     Z,AFLADPRG     ; Aflade program
             CP     3              ; 3 tasten
             JP     Z,KONDIPRG     ; Kondi automatisk op. og afladning.
             CP     12             ; # tasten
             JP     Z,ANDETPRG     ; "Andet" menuer og settings...
             JP     HOVEDLOOP



ANDETPRG:    CALL   CLS
             LD     HL,TXT_ANDET1  ; 1:VOLTMETER
             CALL   SKRIV          ; 2:BATTERI DATA-BANK
ANDETLOOP:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,VOLTMETER    ; Voltmeter
             CP     2              ; 2 tasten
             JP     Z,AN_BATT      ; Batteri data bank menu
             CP     12             ; # tasten
             JP     Z,AN_MERE1     ; Mere menu1
             CP     10             ; Fortryd-tasten
             JP     Z,HOVEDPRG     ; Hvis ;, hop til forige menu.
             JP     ANDETLOOP



AN_MERE1:    CALL   CLS
             LD     HL,TXT_ANDET2  ; 1:LYD-SETUP   3:INFO
             CALL   SKRIV          ; 2:KODE-SETUP  4:COM-SETUP
MERELOOP1:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AN_LYD       ; Lyd setup
             CP     2              ; 2 tasten
             JP     Z,AN_KODE      ; KODE Setup
             CP     3              ; 3 tasten
             JP     Z,AN_INFO      ; VIS INFO TEKST
             CP     4              ; 4 tasten
             JP     Z,AN_SERI      ; SERIAL SETUP
             CP     10             ; Fortryd-tasten
             JP     Z,ANDETPRG     ; Hvis ;, hop til forige menu
             JP     MERELOOP1




;*******************************************************************
;*        OPLADNING HOVED PROGRAM                                  *
;*        Funktion....: Styring af Opladeforlb                    *
;*        Initialer...: TST.  dato: 27/10-93                       *
;*******************************************************************
OPLADPRG:    CALL   CLS
             LD     HL,TXT_BAT4A   ; "1:INPUT BAT.DATA"
             CALL   SKRIV

OP_MENU1:    CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,OP_INDKAP
             CP     2              ; 2 tasten
             JP     Z,OP_HENT_BAT  ; Batteri data findes i BANK
             CP     10
             JP     Z,HOVEDPRG     ; Hvis ;, hop til hovedprg.
             JP     OP_MENU1

OP_INDKAP:   CALL   INPUT_KAP
             LD     A,(FORTRYDTAST)
             CP     $FF
             JP     Z,OPLADPRG     ; Hop til forrige, hvis fortryd

OP_TIMER:    CALL   INPUT_OPTID
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,OP_INDKAP    ; Hop til forige, hvis fortryd
             CALL   OPTIMETEST     ; Test af input og beregning af-
             CP     0              ; opladestrm til DAC.
             JP     Z,OP_TIMER     ; Hvis fejl, Indtast oplade tid igen.
             LD     A,0
             LD     (BANK_AKTIV),A ; Marker at der ikke bruges Data-Bank
             JP     OP_TILSLUT     ; OK, start opladning.

OP_HENT_BAT: CALL   IND_BANK
             CP     0              ; Hvis a=0
             JP     Z,OPLADPRG     ; s er der fejl, eller valgt tilbage

OP_TILSLUT:  LD     A,$FF
             LD     (TEMP_1GANG),A
             CALL   CLS            ; Slet skrm
             LD     HL,TXT_BAT8A   ; Peg p: "TILSLUT         "
             CALL   SKRIV

OP_TILSLUT1: CALL   HENTTAST
             CP     10             ; FORTRYD-tasten
             JP     Z,OPLADPRG
             CP     12             ; ENTER-tast
             JP     Z,OPL_START    ; Hvis #, S kan opladning altid startes
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     10             ; Test om der er over 1 Volt
             JP     C,OP_TILSLUT1  ; Hvis ikke s test igen

OP_TRYK:     CALL   CLS            ; Slet skrm
             LD     HL,TXT_BATAA   ; Peg p: "TRYK # FOR AT   "
             CALL   SKRIV          ; starte opladning

OP_TRYKLOOP: CALL   HENTTAST
             CP     12             ; ENTER-tast
             JP     Z,OPL_START
             CP     10             ; FORTRYD-tast
             JP     Z,OPLADPRG     ; Hvis ;, hop
             LD     A,(VOLTBIN)    ; Hent spnding over strm generator
             CP     10             ; Test om der er over 1 Volt
             JP     C,OP_TILSLUT   ; Hvis ikke s skriv "TILSLUT BATTERI"
             JP     OP_TRYKLOOP

OPL_START:   CALL   OPLADSTART
             LD     A,1            ; Marker at laderen er igang med at oplade-
             LD     (LAD_STAT),A   ; s der kan forsttes efter strm fejl
             LD     (LADNING_OP),A ; marker opladning ikke er frdig

OP_NET_FEJL: CALL   OPLAD_NET
             CALL   CLS
             LD     HL,TXT_OP2A    ;"OPLADNING IGANG!"
             CALL   SKRIV          ;"RESTTID 00:00:00"

OP_LADE_LP:  CALL   OPLADE_UR      ; Skriver oplade tid
             LD     BC,1000
             CALL   PAUSE
             CALL   HENTTAST
.IF LAVFINAL=0                     ; HVIS DER IKKE ER LAVFINAL, S INDST...
             CP     3              ; hvis der trykkes 3
             JP     Z,OP_FIX       ; er opladning frdig...
.ENDIF
             CP     10
             JP     Z,OP_PAUSE     ; Fortryd?? Eller fortset
             CP     20
             JP     Z,OP_NET_FEJL  ; HVIS DER VAR TEMP-FEJL, SKAL DER SKRIVES-
                                   ; IGEN.
             LD     A,(VOLTBIN)    ; Hent spnding OVER GENERATOR
             CP     10             ; Test om der er over 1 Volt
             JP     C,OP_PAUSE     ; Hvis ikke, hop
             LD     A,(LADNING_OP) ; Hent oplade status 1=Oplade
             CP     0              ;                    0=SLUT
             JP     NZ,OP_LADE_LP
             JP     OP_LADSLUT

OP_FIX:      LD     A,0
             LD     (LADNING_OP),A
             JP     OP_LADE_LP

OP_PAUSE:    CALL   OPLADPAUSE
             CALL   CLS
             LD     HL,TXT_OP4A
             CALL   SKRIV          ; Skriv "OPLADING PAUSET"

OP_BRYDLOOP: CALL   HENTTAST
             CP     10             ; ;=
             JP     Z,OP_LADAFBRUDT   ; Afbryd opladning
             CP     12             ; #=
             JP     Z,OP_PAUSLUT   ; Fortst opladning
             JP     OP_BRYDLOOP

OP_PAUSLUT:  CALL   CLS
             LD     HL,TXT_OP2A    ;"OPLADNING IGANG!
             CALL   SKRIV
             LD     A,1
             LD     (LAD_STAT),A   ; Marker oplader igang
             CALL   OPLFORSET      ; Hent tid tller osv.
             JP     OP_LADE_LP     ; Fortst opladningsloop

OP_LADSLUT:  CALL   OPLADSLUT
             CALL   CLS
             LD     HL,TXT_OP3A    ;"OPLADNING FRDIG"
             CALL   SKRIV
             CALL   SLUTLYDTEST    ; Test om der skal vre en lyd..
OP_LADPRUT:  CALL   HENTTAST
             CP     $FF
             JP     Z,OP_LADPRUT
             JP     HOVEDPRG

OP_LADAFBRUDT: CALL   OPLADSLUT
             CALL   CLS
             LD     HL,TXT_OP3B    ;"OPLADNING AFBRUDT"
             CALL   SKRIV
OP_LADAFBRUDT2: CALL   HENTTAST
             CP     $FF
             JP     Z,OP_LADAFBRUDT2
             JP     HOVEDPRG


;*******************************************************************
;*        SUB-RUTINE..: OPLAD_NET                                  *
;*        Funktion....: Skal kres for at forberede opladning      *
;*        Input.......: Intet                                      *
;*        Output......: Intet                                      *
;*        delgger...: A, BC                                      *
;*        Kalder......: OPLAD_ON, PAUSE                            *
;*        Initialer...: TST. dato: 3/11-93                         *
;*******************************************************************
OPLAD_NET:   LD     A,(BAT_OP_DAC) ; Hent strm
             OUT    (DACSTR0M),A   ; Set strm til generator
             CALL   OPLAD_ON       ; Trk rel til opladning
             LD     BC,1000
             CALL   PAUSE          ; 100mS Tid til rel skifter fr-
             LD     A,0FFH
             LD     (SLUTLYD),A    ; marker at nu kan der afspilles slutlyd
             LD     BC,400
             CALL   PAUSE          ; Tid til Batteri test mling
             CALL   STROM_ON
             LD     A,0
             LD     (STOP_TID),A   ; forst oplade tid
             RET



;*******************************************************************
;*        SUB-RUTINE..: OPLADSTART                                 *
;*        Funktion....: Nulstiller oplade tids tller              *
;*        Input.......: Intet                                      *
;*        Output......: RAM variabler                              *
;*        delgger...: A                                          *
;*        Kalder......: Intet                                      *
;*        Initialer...: TST. dato: 3/11-93                         *
;*******************************************************************
OPLADSTART:  LD     A,1
             LD     (STOP_TID),A   ; Pause tller
             LD     A,0
             LD     (OP_SEK_EN),A  ; Nulstil tller
             LD     (OP_SEK_TI),A  ; Nulstil tller
             LD     (OP_MIN_EN),A  ; Nulstil tller
             LD     (OP_MIN_TI),A  ; Nulstil tller
             LD     A,(BAT_OP_TIM)   ; Hent oplade Timer Tiere
             LD     (OP_TIM_TI),A    ; Set nedtller timer
             LD     A,(BAT_OP_TIM+1) ; Hent oplade Timer enere
             LD     (OP_TIM_EN),A    ; Set nedtller timer
             LD     A,0
             LD     (STOP_TID),A   ; Start tller
             RET



;*******************************************************************
;*        SUB-RUTINE..: OPLFORSET                                  *
;*        Funktion....: Gendanner oplade tids tller til forst    *
;*        Input.......: RAM variabler                              *
;*        Output......: RAM variabler                              *
;*        delgger...: A, BC                                      *
;*        Kalder......: OPLAD_ON, PAUSE                            *
;*        Initialer...: TST.  dato: 3/11-93                        *
;*******************************************************************
OPLFORSET:   CALL   OPLAD_ON       ; Rel skift
             LD     BC,1000
             CALL   PAUSE          ; Tid til rel skifter fr-
             LD     A,0FFH
             LD     (SLUTLYD),A    ; marker at nu kan der afspilles lyd
             CALL   STROM_ON
             LD     A,0
             LD     (STOP_TID),A   ; Start tller
             RET



;*********************************************************************
;*       SUB-RUTINE..: OPLADSLUT                                     *
;*       Funktion....: Afslutter oplade forlbet, slukker for strm  *
;*       Input.......: Intet                                         *
;*       Output......: RAM variabler                                 *
;*       delgger...: A                                             *
;*       Kalder......: AFLAD_ON, STRM_OFF                           *
;*       Initialer...: TST.  dato: 3/11-93                           *
;*********************************************************************
OPLADSLUT:   LD     A,0
             LD     (LAD_STAT),A   ; Marker frdig
             OUT    (DACSTR0M),A        ; Set strm til 0 mA
             CALL   STROM_OFF      ; Disable strm generator
             CALL   AFLAD_ON       ; Slip rel
             RET



;*********************************************************************
;*       SUB-RUTINE..: OPLADPAUSE                                    *
;*       Funktion....: Stopper oplade tiden, slukker for strm       *
;*       Input.......: RAM variabler                                 *
;*       Output......: RAM variabler                                 *
;*       delgger...: A                                             *
;*       Kalder......: AFLAD_ON, STRM_OFF                           *
;*       Initialer...: TST.  dato: 3/11-93                           *
;*********************************************************************
OPLADPAUSE:  LD     A,1
             LD     (STOP_TID),A   ; Stop tller
             CALL   STROM_OFF
             CALL   AFLAD_ON
             LD     A,0
             LD     (SLUTLYD),A    ; marker at nu kan der ikke afspilles lyd
             LD     (LAD_STAT),A   ; Marker ingen opladning
             RET                   ; Hvis reset nu, s g til hoved menu



;******************************************************************
;*       AFLADNING HOVED PROGRAM                                  *
;*       Funktion....: Styring af afladeforlb                    *
;*       Initialer...: KEA.TST.  dato: 24/10-93                   *
;******************************************************************
AFLADPRG:    CALL   CLS
             LD     HL,TXT_BAT4A   ; Peg p: "1:INPUT BAT.DATA"
             CALL   SKRIV
AFLOOP1:     CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AF_NYTBAT    ; Indtastning af data p nyt batteri
             CP     2              ; 2 tasten
             JP     Z,AF_HENT      ; Batterinummer kendes
             CP     10             ; Fortryd-tasten
             JP     Z,HOVEDPRG     ; Hvis ;, hop til hovedprg.
             JP     AFLOOP1

AF_NYTBAT:   LD     A,0
             LD     (BANK_AKTIV),A ; Marker at kap. ikke skal gemmes i d.bank
             CALL   INPUT_KAP
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AFLADPRG

AF_INDSTROM: CALL   AF_STROM
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AF_NYTBAT

             CALL   AF_CELLER
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AF_INDSTROM
             JP     AF_VENT_BAT

AF_HENT:     CALL   IND_BANK
             CP     0              ; Hvis a=0
             JP     Z,AFLADPRG     ; s er der fejl...

AF_VENT_BAT: CALL   AF_TILSLUT
             LD     A,(FORTRYDTAST)
             CP     $FF
             JP     Z,AFLADPRG

             LD     A,$FF
             LD     (TEMP_1GANG),A

             LD     A,0
             LD     (AFLAD_1SEK),A ; Reset tidtager
             LD     HL,0
             LD     (AFLAD_2SEK),HL
             LD     (STOP_TID),A   ; Start tidtager

;*************************************************************************
; Herfra vil afladningsforlbet blive krt, hvis der har vret netudfald *
;*************************************************************************
AF_NET_FEJL: CALL   AF_UDREGN      ; Udregn afladestrm
AF_PRG_STRT: CALL   CLS
             LD     HL,TXT_AF2A    ; Peg p: "AFLADNING IGANG"
             CALL   SKRIV
             LD     A,$17
             LD     B,'2'
             CALL   GOTOPOS
             CALL   SKRIVSTROM     ; Skriv afladestrm i display
             LD     A,2            ; Marker at laderen er igang med at aflade
             LD     (LAD_STAT),A   ; s der kan fortsttes efter netudfald
             CALL   AFLAD_START    ; Start afladning
             CP     20
             JP     Z,AF_NET_FEJL  ; REFESH DISP. EFTER TEMPFEJL..
             CP     $FF            ; Test om afladningen er slut
             JP     NZ,AF_GEM_DATA ; Hvis ja: Gem mlt kap. i databank
AF_PAUSE:    CALL   CLS
             LD     HL,TXT_AF4A
             CALL   SKRIV          ; Skriv "AFLADNING PAUSET"
             CALL   AFLAD_PAUSE    ; Ellers pause i afladning
             CP     0FFH           ; Skal der aflades videre?
             JP     Z,AF_PRG_STRT  ; Hvis ja: S start afladning igen
             LD     A,0            ; Ellers marker at nu kan der
             LD     (SLUTLYD),A    ; ikke afspilles lyd og
             JP     AF_PRG_AFBRUDT ; afslut afladning
AF_GEM_DATA: LD     A,(BANK_AKTIV)
             CP     0FFH           ; Er afladt bat. fra databank?
             CALL   Z,GEM_BAT_KAP  ; S gem kapacitet i databank
             LD     A,0FFH         ; Marker at nu kan der
             LD     (SLUTLYD),A    ; afspilles lyd
             CALL   CLS
             LD     HL,TXT_AF3     ; Peg p: "AFLADNING SLUT "
             CALL   SKRIV
             JP     AF_PRG_SLUT

AF_PRG_AFBRUDT:
             CALL   CLS
             LD     HL,TXT_AF3A    ; Peg p: "AFLADNING AFBRUDT "
             CALL   SKRIV
AF_PRG_SLUT: CALL   AFLAD_SLUT     ; Ellers afslut afladning
             CALL   SLUTLYDTEST
AF_PRG_SLUT2: CALL   HENTTAST       ; Vent til der trykkes p en tast
             CP     $FF
             JP     Z,AF_PRG_SLUT2
             JP     HOVEDPRG       ; Hop til hovedprg. nr afladn. er slut



;******************************************************************
;*       SUB-RUTINE..: AF_STROM                                   *
;*       Funktion....: Henter og tester aflade strmmen           *
;*       Input.......: Brugerens indtastning fra tastatur         *
;*       Output......: Afladestrmmen i mA.                       *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AF_STROM:    CALL   CLS
             LD     HL,TXT_AF0A    ; Peg p: "INPUT AFLADE    "
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Cursorposition
             LD     D,4            ; Max. antal input cifre
             LD     HL,BAT_AF_mA   ; Startadr. hvor afladestrm-vrdi gemmes
             CALL   TASTEINPUT     ; Hent afladestrm
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AF_STROM_SL

             LD     IX,BAT_KAP
             CALL   KONV_4DECI
             LD     (BAT_KAPHEX),HL
             LD     IX,BAT_AF_mA
             CALL   KONV_4DECI
             LD     (BAT_AF_HEX),HL
             LD     HL,(BAT_KAPHEX)
             LD     DE,(BAT_AF_HEX)
             CALL   DIV_HL_DE
             INC    H
             DEC    H
             JP     NZ,AF_MIN_mA
             LD     A,L
             CP     24
             JP     NC,AF_MIN_mA
             CP     0
             JP     Z,AF_MAX_mA
             JP     AF_KAP_TEST

AF_MIN_mA:   CALL   LINE1
             LD     HL,TXT_AF5A
             CALL   SKRIV
AF_MIN_mA2:  CALL   HENTTAST
             CP     $FF
             JP     Z,AF_MIN_mA2
             JP     AF_STROM

AF_MAX_mA:   LD     HL,(BAT_KAPHEX)
             CALL   HEX_DIV10
             LD     D,H
             LD     E,L
             LD     HL,(BAT_AF_HEX)
             CALL   DIV_HL_DE
             INC    H
             DEC    H
             JP     NZ,AF_MX_mAFJL
             LD     A,L
             CP     21
             JP     C,AF_KAP_TEST
AF_MX_mAFJL: CALL   LINE1
             LD     HL,TXT_AF6A
             CALL   SKRIV
AF_MX_mAFJL2: CALL   HENTTAST
             CP     $FF
             JP     Z,AF_MX_mAFJL2
             JP     AF_STROM

AF_KAP_TEST: LD     IX,MAX_AF_mA   ; Maximum kapacitet
             LD     IY,MIN_AF_mA   ; minimum kapacitet
             LD     HL,BAT_AF_mA   ; Indtastet kap
             LD     B,4            ; Max. antal input
             LD     C,3            ; Fejlnr.
             CALL   INPUT_TEST     ; Er input tilladeligt?
             INC    C
             DEC    C              ; Er fejl <> 0?
             JP     NZ,AF_STROM    ; Hvis fejl, s input afladestrm. igen
AF_STROM_SL  RET




;******************************************************************
;*       SUB-RUTINE..: SKRIVSTROM                                 *
;*       Funktion....: Skriver afladestrmmen i diplayet ved aflad*
;*       Input.......: BAT_KAP_mA                                 *
;*       Output......: Afladestrmmen i mA i displayet            *
;*       delgger...:                                            *
;*       Kalder......:                                            *
;*       Initialer...: KEA.   dato: 7-1-96                        *
;******************************************************************


SKRIVSTROM:  LD     HL,BAT_AF_mA-1 ; Hent batt. kapacitet -1
             LD     B,4            ;antal karak. der skal udskrives
SKRSTRLOOP:  INC    HL             ; Nu peger HL p det frste tal i battkap
             LD     A,(HL)         ; Hent tallet
             CP     0              ; Hvis det er 0 skal der skrives et mellemrum
             JP     NZ,SKRSTRLOOP2 ; Hvis ikke 0 skal de resterende tal udskrives
             DEC    B              ; Et tal mindre skal udskrives
             LD     A,' '
             CALL   SKRIVA         ; Skriv et mellemrum
             JP     SKRSTRLOOP     ; Hop tilbage og test videre
SKRSTRLOOP2: LD     A,(HL)         ; Hent tal
             ADD    A,$30          ; Konverter til ascii-tal
             CALL   SKRIVA         ; Skriv tal i display
             INC    HL             ; Peg p nste hex-tal
             DJNZ   SKRSTRLOOP2    ; Skriv indtil alle tal er udskrevet
             RET





;******************************************************************
;*       SUB-RUTINE..: AF_CELLER                                  *
;*       Funktion....: Henter og tester antallet af celler i      *
;*                     batteriet                                  *
;*       Input.......: Brugerens indtastning fra tastatur         *
;*       Output......: Antal celler i batteriet bliver gemt i     *
;*                     rammen                                     *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AF_CELLER:   CALL   CLS
             LD     HL,TXT_AF1A    ; Peg p:"INPUT ANTAL     "
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Cursorposition
             LD     D,2            ; Max. antal input cifre
             LD     HL,BAT_CELLER  ; Startadr. hvor antal celler gemmes
             CALL   TASTEINPUT     ; Hent antal celler
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AF_CELLE_SL

             LD     IX,MAX_CELLER  ; Maximum antal celler
             LD     IY,MIN_CELLER  ; minimum antal celler
             LD     HL,BAT_CELLER  ; Indtastet antal celler
             LD     B,2            ; Max. antal input
             LD     C,4            ; Fejlnr.
             CALL   INPUT_TEST     ; Er input tilladeligt?
             INC    C
             DEC    C              ; Er fejl <> 0?
             JP     NZ,AF_CELLER   ; Hvis fejl, s input antal celler igen
AF_CELLE_SL: RET



;******************************************************************
;*       SUB-RUTINE..: AF_TILSLUT                                 *
;*       Funktion....: Venter p at batteriet bliver tilsluttet   *
;*       Input.......: Spnding p klemmerne                      *
;*       Output......: Tekst i display                            *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AF_TILSLUT:  LD     HL,BAT_CELLER  ; Hent antal celler
             CALL   KONV_2DECI     ; Konvertr til decimaltal i A-reg.
             LD     C,A            ; Celleantal i C
             LD     B,MINCELLEVOLT ; gang antal celler med min. volt
             DEC    B              ; kun for at regnestykket passer
AF_X_10LP:   ADD    A,C            ; Addr C med A
             DJNZ   AF_X_10LP      ; Gang Celleantal med B
             LD     (MIN_VOLT),A   ; Gem minimumsspnding i variabel

             CALL   CLS            ; Slet skrm
             LD     HL,TXT_BAT8A   ; Peg p: "TILSLUT         "
             CALL   SKRIV          ;          BATTERIET!

AF_TIL_LOOP: CALL   HENTTAST       ; Hent sidst trykkede tast
             CP     10             ; FORTRYD-tasten
             JP     Z,AF_TRK_FTRD
             LD     A,(MIN_VOLT)
             LD     C,A
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     C              ; Test om den er over det minimale
             JP     C,AF_TIL_LOOP  ; Hvis ikke s test igen

AF_TRYK:     CALL   CLS            ; Slet skrm
             LD     HL,TXT_BAT9A   ; Peg p: "TRYK # FOR AT   "
             CALL   SKRIV          ;          STARTE AFLADNING

AF_TRYKLOOP: CALL   HENTTAST       ; Hent sidst trykkede tast
             CP     12             ; ENTER-tast (START)
             JP     Z,AF_TRK_SLUT
             CP     10             ; FORTRYD-tast
             JP     Z,AF_TRK_FTRD
             LD     A,(MIN_VOLT)
             LD     C,A
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     C              ; Test om den er over det minimale
             JP     C,AF_TILSLUT   ; Hvis ikke s skriv "TILSLUT BATTERI"
             JP     AF_TRYKLOOP
AF_TRK_SLUT: RET
AF_TRK_FTRD: LD     A,0FFH
             LD     (FORTRYDTAST),A
             JP     AF_TRK_SLUT



;******************************************************************
;*       SUB-RUTINE..: AF_UDREGN                                  *
;*       Funktion....: Omregner afladestrmmen og komp. for strm-*
;*                     fejl i DAC'en. udregner DIV_TAL            *
;*       Input.......: Afladestrm, kapacitet                     *
;*       Output......: DIV_TAL, komp. afladstrm                  *
;*       delgger...: A, DE, HL, IX                              *
;*       Kalder......: KONV_4DECI, HEX_DIV5, HEX_MUL6, HEX_DIV3   *
;*                     HEX_MUL18, DIV_HL_DE                       *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AF_UDREGN:   LD     IX,BAT_AF_mA
             CALL   KONV_4DECI     ; Konverterer decimal mA til hex i HL.
             CALL   HEX_DIV5       ; Dividerer HL-reg. med 5 over i A-reg.
             SUB    DAC_FEJL       ; Trk konstant fra, for at komp. strm
             LD     (BAT_AF_DAC),A ; Gem udregnet afladestrm

             LD     IX,BAT_KAP     ; Hent decimal batterikapacitet
             CALL   KONV_4DECI     ; Konverter kapacitet til hextal
             LD     A,H            ; Hent hi-byte
             CP     14             ; Test om kapacitet > 3583 mA
             JP     C,AF_LAV_mA    ; Hvis ikke hop til AF_LAV_mA

AF_H0J_mA:   CALL   HEX_MUL6       ; Kapacitet X 6
             LD     (TEMPGEM),HL   ; Gem kapacitet
             LD     HL,(BAT_AF_HEX) ; Hent afladestrm [mA]
             CALL   HEX_DIV3       ; Afladestrm / 3
             LD     D,H
             LD     E,L
             LD     HL,(TEMPGEM)   ; Hent kapacitet X 6
             CALL   DIV_HL_DE      ; (Kapacitet X 6) / (Afladestrm / 3)
             LD     (DIV_TAL),HL   ; Gem resultat ( bruges til udregning
                                   ; af batteriets kapacitet i procent)
             RET

AF_LAV_mA:   CALL   HEX_MUL18      ; Kapacitet X 18
             LD     DE,(BAT_AF_HEX) ; Hent afladestrm [mA]
             CALL   DIV_HL_DE      ; (kapacitet X 18) / afladestrm
             LD     (DIV_TAL),HL   ; Gem resultat ( bruges til udregning
                                   ; af batteriets kapacitet i procent)
             RET



;******************************************************************
;*       SUB-RUTINE..: AFLAD_START                                *
;*       Funktion....: Starter afladningen af batteriet og tester *
;*                     om det er afladt.                          *
;*       Input.......: HL indeholder procenttallet                *
;*       Output......: Skriver procent i displayet                *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AFLAD_START: LD     A,(BAT_AF_DAC)
             OUT    (DACSTR0M),A   ; Indstil strmgenerator
             CALL   STROM_ON       ; Enable strmgenerator
AFLADELOOP:  LD     HL,(AFLAD_2SEK)
             LD     DE,(DIV_TAL)
             CALL   DIV_HL_DE      ; Div. antal 2 sek. med divisionstal
             LD     A,$0A          ; Peg p plads 10 i linie 2 i display
             LD     B,'2'
             CALL   GOTOPOS        ; Flyt cursor til udpeget plads
             CALL   BAT_PROCENT    ; Udskriver batteriets godhed i procent
             LD     A,$07
             LD     B,'1'
             CALL   GOTOPOS

             CALL   VOLTSKRIV      ; Skriver spnding p batt. i display
             LD     A,(MIN_VOLT)   ; minimumsvolt pr. celle (100 mV oplsn.)
             LD     C,A            ; Gem min volt i C
             LD     A,(VOLTBIN)    ; Hent klemspnding
             CP     C              ; Trk minimumsspnding fra
             JP     C,AF_TESTFORB  ; Hvis min.spnding > klemspnding:
                                   ; Stop afladning
             CALL   HENTTAST
             CP     10             ; Tester om afbryd-tasten (;) er trykket
             JP     Z,AF_STOP
.IF LAVFINAL=0
             CP     3              ; FORCE AFLAD FRDIG
             JP     Z,AF_SLUT
.ENDIF
             CP     20
             JP     Z,AF_REFESH    ; DER HAR VRET TEMPFEJL, S SKRIV AF. DISP.
             JP     AFLADELOOP


AF_TESTFORB:
             LD     BC,1000
             CALL   PAUSE          ; 100msek. pause
             LD     A,(MIN_VOLT)   ; Hent minimumsspnding
             LD     C,A
             LD     A,(VOLTBIN)    ; Hent klemspnding
             CP     C              ; Trk minimumsspnding fra
             JP     NC,AFLADELOOP  ; Hvis klemsp > min.spnding: ls forb.
             CALL   STROM_OFF      ; Stop afladning
             LD     BC,400
             CALL   PAUSE          ; 40msek. pause
             LD     A,(VOLTBIN)    ; Hent klemspnding
             LD     C,A
             LD     A,(MIN_VOLT)   ; Hent minimumsspnding
             CP     C              ; Trk klemspnding fra
             JP     C,AF_SLUT
             JP     Z,AF_SLUT      ; Batteri var afladt til min. spnding

AF_STOP:     LD     A,$FF          ; Marker at batteri er taget af klemmerne
AF_SLUT:     LD     HL,STOP_TID
             LD     (HL),1         ; Stop tidtager
AF_REFESH:   RET



;******************************************************************
;        SUB-RUTINE..: VOLTSKRIV                                  ;
;        Funktion....: Konverterer binr-spndingen i A-reg. til  ;
;                      ASCII, som gemmes i en tekststreng.        ;
;        Input.......: A=Volt binr, HL=Adr. i tekststreng        ;
;        Output......: Indstter Volt-ASCII i tekststreng         ;
;        delgger...: HL,A                                       ;
;        Kalder......: SKRIVA                                     ;
;        Initialer...: KEA.          dato: 7-1-96                 ;
;******************************************************************

VOLTSKRIV:   LD     A,$17
             LD     B,'1'
             CALL   GOTOPOS
             LD     A,(VOLTBIN)    ; Hent binr klemspnding
             PUSH   BC
             LD     B,'0'          ; 100-tller = 0
V_LOOP_100:  CP     100            ; Test om der kan trkkes 100 fra tallet
             JP     C,V_GEM_100    ; Hvis ikke s gem 100-tller
             SUB    100            ; Trk 100 fra volt binr
             INC    B              ; forg 100-tller med 1
             JP     V_LOOP_100
V_GEM_100:   LD     C,A            ; Gem binr volt
             LD     A,B            ; 100-tller kopieres til A.reg.
             CP     '0'            ; Test om 100-tller = '0'
             JP     Z,V_NUL_100    ; Hvis ja: hop til V_NUL_100
             CALL   SKRIVA
             JP     V_10_TAEL      ; Tl tiere
V_NUL_100:   LD     A,' '
             CALL   SKRIVA
V_10_TAEL:   LD     A,C            ; Hent binr volt
             LD     B,'0'          ; 10-tller = '0'
V_LOOP_10:   CP     10             ; Test om der kan trkkes 10 fra tallet
             JP     C,V_GEM_10   ; Hvis ikke s gem 10-tller
             SUB    10             ; Trk 10 fra volt binr
             INC    B              ; Forg 10-tller med 1
             JP     V_LOOP_10
V_GEM_10:    PUSH   AF
             LD     A,B
             CALL   SKRIVA
             LD     A,'.'
             CALL   SKRIVA
             POP    AF
             ADD    A,'0'          ; De enere der er i volt binr adderes
                                   ; med '0'
             CALL   SKRIVA
             POP    BC
             RET









;******************************************************************
;*       SUB-RUTINE..: AFLAD_PAUSE                                *
;*       Funktion....: Pauser afladningen nr brugeren nsker det *
;*       Input.......: Tasteinput                                 *
;*       Output......: Slukker strmgeneratoren                   *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 2/11-93                       *
;******************************************************************
AFLAD_PAUSE: CALL   STROM_OFF      ; Sluk strmgeneratoren
             LD     A,0            ; Marker at laderen ikke lngere aflader
             LD     (LAD_STAT),A   ; hvis der kommer net udfald
             LD     A,1
             LD     (STOP_TID),A   ; Paus afladetiden
AF_PAUSELP:  CALL   HENTTAST
             CP     10             ; Tester om stop-tasten (;) er trykket
             JP     Z,AF_PAU_STOP
             CP     12             ; Tester om start-tasten (#) er trykket
             JP     Z,AF_PAU_SLUT
             JP     AF_PAUSELP
AF_PAU_SLUT: LD     A,(MIN_VOLT)   ; Hent minimumsspnding
             LD     C,A
             LD     A,(VOLTBIN)    ; Hent klemspnding
             CP     C              ; Trk minimumsspnding fra
             JP     C,AF_PAUSELP   ; Batteri er ikke p
                                   ; klemmerne= ikke start
             CALL   STROM_ON       ; Enable strmgenerator
             LD     HL,STOP_TID    ; ..
             LD     (HL),0         ; Start afladetiden
             LD     A,2            ; Marker at laderen aflader
             LD     (LAD_STAT),A   ; hvis der kommer net udfald
             LD     A,0FFH          ; Marker at der skal aflades videre
AF_PAU_RET:  RET
AF_PAU_STOP: LD     A,0            ; Marker at afladning skal afsluttes
             JP     AF_PAU_RET


;******************************************************************
;*       SUB-RUTINE..: AFLAD_SLUT                                 *
;*       Funktion....: Disabler strmgeneratoren, stter strmmen *
;*                     til 0 mA og udskriver batteriprocent.      *
;*       Input.......: HL indeholder procenttallet                *
;*       Output......: Skriver procent i displayet                *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
AFLAD_SLUT:  CALL   STROM_OFF      ; Disable strmgenerator
             LD     A,0            ; Marker at laderen er frdig med at aflade
             LD     (LAD_STAT),A
             OUT    (DACSTR0M),A   ; St strmgenerator til 0 milliAmpere
             LD     HL,(AFLAD_2SEK)
             LD     DE,(DIV_TAL)
             CALL   DIV_HL_DE
             LD     A,$0A          ; Peg p plads 10 i linie 2 i display
             LD     B,'2'
             CALL   GOTOPOS        ; Flyt cursor til udpeget plads
             CALL   BAT_PROCENT    ; Udskriver batteriets godhed i procent
             RET


;******************************************************************
;*       SUB-RUTINE..: BAT_PROCENT                                *
;*       Funktion....: Udskriver procentantallet i displayet      *
;*                     (Hvor godt batteriet er)                   *
;*       Input.......: HL indeholder procenttallet                *
;*       Output......: Skriver procent i displayet                *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 26/10-93                      *
;******************************************************************
BAT_PROCENT: PUSH   BC
             PUSH   DE

             INC    H
             DEC    H              ; Test om procent er over 255
             JP     Z,PRC_START
             LD     L,255          ; Hvis procent > 255: procent=255
PRC_START:   LD     A,L            ; Hent procent
             LD     B,'0'          ; 100-tller = 0
PROCENT_100: CP     100            ; Test om der kan trkkes 100 fra tallet
             JP     C,PRC_GEM_100  ; Hvis ikke s gem 100-tller
             SUB    100            ; Trk 100 fra procent
             INC    B              ; forg 100-tller med 1
             JP     PROCENT_100
PRC_GEM_100: LD     C,A            ; Gem procent
             LD     A,B            ; 100-tller kopieres til A.reg.
             CP     '0'            ; Test om 100-tller = '0'
             JP     Z,PRC_NUL_100  ; Hvis ja: hop til PRC_NUL_100
             CALL   SKRIVA
             LD     (MAALT_KAP),A
             JP     PRC_10_TAEL    ; Tl tiere
PRC_NUL_100: LD     A,' '
             CALL   SKRIVA
             LD     (MAALT_KAP),A
PRC_10_TAEL: LD     A,C            ; Hent procent
             LD     B,'0'          ; 10-tller = '0'
PRCLOOP_10:  CP     10             ; Test om der kan trkkes 10 fra tallet
             JP     C,PRC_GEM_10   ; Hvis ikke s gem 10-tller
             SUB    10             ; Trk 10 fra procent
             INC    B              ; Forg 10-tller med 1
             JP     PRCLOOP_10
PRC_GEM_10:  LD     C,A            ; Gem procent
             LD     A,L            ; Hent oprindelig antal procent
             CP     100            ; Var det minimum 100
             JP     NC,PRC_SKRV_10 ; S udskriv antal ti procent
             LD     A,B            ; Ellers hent antal 10 procent
             CP     '0'            ; Hvis det er nul
             JP     Z,PRC_NUL_10   ; S udskriv mellemrum ved 10 procent
             CALL   SKRIVA         ; Ellers
             LD     (MAALT_KAP+1),A
             JP     PRC_1_SKRIV
PRC_SKRV_10: LD     A,B            ; Hent antal 10 procent
             LD     (MAALT_KAP+1),A
             CALL   SKRIVA
             JP     PRC_1_SKRIV
PRC_NUL_10:  LD     A,' '
             LD     (MAALT_KAP+1),A
             CALL   SKRIVA
PRC_1_SKRIV: LD     A,C            ; Hent antal 1 procent
             ADD    A,30H          ; Konverter til ASCII
             LD     (MAALT_KAP+2),A
             CALL   SKRIVA
             LD     A,$0a
             LD     (MAALT_KAP+3),A
             LD     A,$0d
             LD     (MAALT_KAP+4),A
             POP    DE
             POP    BC
             RET



;******************************************************************
;*       SUB-RUTINE..: GEM_BAT_KAP                                *
;*       Funktion....: Gemmer kapaciteten fra det afladede batteri*
;*                     i databanken                               *
;*       Input.......: batterinr. og kapacitet                    *
;*       Output......: Gemt kapacitet i databank                  *
;*       delgger...: Ingen                                      *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 10/11-93                      *
;******************************************************************
GEM_BAT_KAP: PUSH   AF
             PUSH   BC
             PUSH   DE
             PUSH   HL
             LD     HL,(BANK_ADR)
             LD     L,4CH          ; Sidste plads (FFH) p kap. mling 8
             LD     D,H
             LD     E,51H          ; Sidste plads (FFH) p kap. mling 9
             LD     BC,45          ; Antal bytes der skal kopieres
             LDDR                  ; Flyt datablok
             LD     DE,(BANK_ADR)
             LD     E,20H          ; 1. plads p kapacitetsmling 0
             LD     HL,MAALT_KAP   ; Mlt kapacitet (ASCII)
             LD     BC,3           ; Antal bytes der skal kopieres
             LDIR                  ; Flyt datablok
             LD     HL,(BANK_ADR)
             LD     L,23H          ; Peg p 4. plads p kapacitetsmling 0
             LD     (HL),'%'       ; Indst procenttegn
             INC    HL             ; Peg p 5. plads p kapacitetsmling 0
             LD     (HL),$FF       ; Indst stopbyte
             POP    HL
             POP    DE
             POP    BC
             POP    AF
             RET


;******************************************************************
;*       KONDI HOVED PROGRAM                                      *
;*       Funktion....: Styring af kondiforlb                     *
;*       Initialer...: TST.  dato: 27/10-93                       *
;******************************************************************
KONDIPRG:    CALL   CLS
             LD     HL,TXT_BAT4A   ; '1:INPUT BAT.DATA'
             CALL   SKRIV

KONDI_LP1:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,KO_INDKAP    ; Input alle data for batteriet
             CP     2              ; 2 tasten
             JP     Z,KO_HENT_BAT  ; Hent Batteri data fra BANK
             CP     10
             JP     Z,HOVEDPRG     ; Hvis ;, hop til hovedprg.
             JP     KONDI_LP1

KO_HENT_BAT: CALL   IND_BANK
             CP     0              ; Hvis a=0
             JP     Z,KONDIPRG     ; s er der fejl...
             JP     KONDIANTAL     ; HER SKAL DER INDTASTES ANTAL KONDI

KO_INDKAP:   CALL   INPUT_KAP
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,KONDIPRG

KO_INDSTROM: CALL   AF_STROM
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,KO_INDKAP

KO_CELLER:   CALL   AF_CELLER
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,KO_INDSTROM

KO_OPTID:    CALL   INPUT_OPTID
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,KO_CELLER

 ; TEST OM OPLADNING KAN FORETAGES

             CALL   OPTIMETEST     ; Test af input og beregning af-
             CP     0              ; opladestrm til DAC.
             JP     Z,KO_OPTID
             LD     A,0
             LD     (BANK_AKTIV),A ; Der bruges ikke data bank

KONDIANTAL:  CALL   CLS
             LD     HL,TXT_KONDI1A ; 'INPUT ANTAL     '
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Cursorposition
             LD     D,1            ; Max. antal input cifre
             LD     HL,BAT_KONDI   ; Startadr. hvor antal celler gemmes
             CALL   TASTEINPUT     ; Hent antal celler
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,KO_OPTID

 ; TEST OM INPUT ER 1-9 KONDI

             LD     IX,MAX_KONDI   ; Maximum antal KONDI
             LD     IY,MIN_KONDI   ; minimum antal KONDI
             LD     HL,BAT_KONDI   ; Indtastet antal KONDI
             LD     B,1            ; Max. antal input
             LD     C,6            ; Fejlnr.
             CALL   INPUT_TEST     ; Er input tilladeligt?
             INC    C
             DEC    C              ; Er fejl <> 0?
             JP     NZ,KONDIANTAL  ; Hvis fejl, s input antal celler igen

             LD     A,' '          ; Her forberedes afladning
             LD     (MAALT_KAP),A
             LD     (MAALT_KAP+1),A
             LD     A,'0'
             LD     (MAALT_KAP+2),A
             LD     A,$FF
             LD     (MAALT_KAP+3),A
             LD     HL,BAT_CELLER
             CALL   KONV_2DECI
             LD     B,MINCELLEVOLT ; gang antal celler med min. volt
             DEC    B              ; kun for at regnestykket passer
             LD     C,A
KO_X_10LP:   ADD    A,C
             DJNZ   KO_X_10LP
             LD     (MIN_VOLT),A
             LD     A,1
             LD     (BAT_KONDINR),A ; Set kondi tller til 1


KO_TILSLUT:  LD     A,$FF
             LD     (TEMP_1GANG),A

             CALL   CLS            ; Slet skrm
             LD     HL,TXT_BAT8A   ; Peg p: 'TILSLUT '
             CALL   SKRIV

             LD     HL,KONDI1PRCNT ; PEG P STED HVOR TEGNET SKAL SKRIVES
             LD     B,3            ; ANTAL TEGN DER SKAL SKRIVES
KO_IGANGLP:  LD     A,'-'          ; TEGNET SOM SKAL SKRIVES
             LD     (HL),A         ; SKRIV '-' IND SOM TEKST
             INC    HL             ; PEG P NSTE PLADS
             DJNZ   KO_IGANGLP     ; HOP INDTIL ALLE TEGN ER SKREVET
             LD     A,$FF          ; STOPBYTE
             LD     (HL),A         ; AFSLUT TEGNENE MED EN STOPBYTE

             LD     HL,KONDI2PRCNT ; PEG P STED HVOR TEGNET SKAL SKRIVES
             LD     B,3            ; ANTAL TEGN DER SKAL SKRIVES
KO_IGANG2LP: LD     A,'-'          ; TEGNET SOM SKAL SKRIVES
             LD     (HL),A         ; SKRIV '-' IND SOM TEKST
             INC    HL             ; PEG P NSTE PLADS
             DJNZ   KO_IGANG2LP    ; HOP INDTIL ALLE TEGN ER SKREVET
             LD     A,$FF          ; STOPBYTE
             LD     (HL),A         ; AFSLUT TEGNENE MED EN STOPBYTE

             LD     HL,KONDI3PRCNT ; PEG P STED HVOR TEGNET SKAL SKRIVES
             LD     B,3            ; ANTAL TEGN DER SKAL SKRIVES
KO_IGANG3LP: LD     A,'-'          ; TEGNET SOM SKAL SKRIVES
             LD     (HL),A         ; SKRIV '-' IND SOM TEKST
             INC    HL             ; PEG P NSTE PLADS
             DJNZ   KO_IGANG3LP    ; HOP INDTIL ALLE TEGN ER SKREVET
             LD     A,$FF          ; STOPBYTE
             LD     (HL),A         ; AFSLUT TEGNENE MED EN STOPBYTE

KO_TILSLUT1: CALL   HENTTAST
             CP     10             ; FORTRYD-tasten
             JP     Z,HOVEDPRG
             CP     12             ; ENTER-tast
             JP     Z,KO_OP_START  ; Hvis #, Sa kan KONDI startes altid
             LD     A,(MIN_VOLT)   ; HENT MINIMUMSSPNDING
             LD     C,A            ; GEM I C
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     C              ; Test om den er over det minimale
             JP     C,KO_TILSLUT1  ; Hvis ikke s test igen

KO_TRYK:     CALL   CLS            ; Slet skrm
             LD     HL,TXT_BATBA   ; Peg p: 'TRYK # FOR AT   '
             CALL   SKRIV

KO_TRYKLOOP: CALL   HENTTAST
             CP     12             ; ENTER-tast
             JP     Z,KO_IGANG
             CP     10             ; FORTRYD-tast
             JP     Z,KONDIPRG     ; Hvis ;, hop
             LD     A,(MIN_VOLT)   ; HENT MINIMUMSSPNDING
             LD     C,A            ; GEM I C
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     C              ; Test om den er over det minimale
             JP     C,KO_TILSLUT   ; Hvis ikke s skriv 'TILSLUT BATTERI'
             JP     KO_TRYKLOOP

KO_IGANG:    LD     A,0
             LD     (BAT_KONDINR),A ; Set kondi tller til 0

 ; HER ER ET AFLADE FORLB..

KONDI_LOOP:  LD     HL,BAT_KONDINR
             INC    (HL)           ; Tl antal kondi 1 op
             LD     HL,0
             LD     (AFLAD_2SEK),HL ; Reset sekundtller til afladeren
             LD     A,0
             LD     (STOP_TID),A   ; Start tidtager

KO_NET_FEJL: CALL   AF_UDREGN      ; Udregn afladestrm
KO_PRG_STRT: CALL   CLS
             LD     HL,TXT_KONDIAF
             CALL   SKRIV          ; Skriv 'KONDI IGANG NR: '
             LD     A,0FH
             LD     B,'1'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,(BAT_KONDINR) ; Hent antal kondi
             ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; SKRIV KONDI NR. MAN ER KOMMET TIL
             LD     A,$13          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI1PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD
             LD     A,$1B          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI2PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD
             LD     A,4
             LD     (LAD_STAT),A   ; marker kondi afladning..
             CALL   AFLAD_START    ; Start afladning
             CP     20             ; REFESH DISPLAY, DER VAR TEMP FEJL.
             JP     Z,KO_NET_FEJL
             CP     $FF            ; Test om afladningen er slut
             JP     NZ,KO_GEM_DATA ; Hvis ja: Gem mlt kap. i databank
KO_AF_PAUSE: CALL   CLS
             LD     HL,TXT_KONDI4A
             CALL   SKRIV          ; Skriv 'KONDI PAUSET...'
             CALL   AFLAD_PAUSE    ; Ellers pause i afladning
             CP     0FFH           ; Skal der aflades videre?
             JP     Z,KO_PRG_STRT  ; Hvis ja: S start afladning igen
             JP     KONDI_AFBRYD

KO_AF_PAUSE2: CALL   HENTTAST      ; VENT P AT EN TAST BLIVER TRYKKET
             CP     $FF
             JP     Z,KO_AF_PAUSE2 ; HVIS INGEN TAST ER TRYKKET: HOP TILBAGE
             JP     HOVEDPRG

KO_GEM_DATA: LD     A,(BANK_AKTIV)
             CP     $FF            ; Er afladt bat. fra databank?
             CALL   Z,GEM_BAT_KAP  ; S gem kapacitet i databank
KO_PRG_SLUT: LD     HL,KONDI2PRCNT ; DENNE TEKST SKAL FLYTTES TIL PLADS 3
             LD     DE,KONDI3PRCNT ; DETTE ER PLADS 3
             LD     BC,3           ; ANTAL TEGN DER SKAL FLYTTES
             LDIR                  ; HER BLIVER TEKSTEN FLYTTET
             LD     HL,KONDI1PRCNT ; DENNE TEKST SKAL FLYTTES TIL PLADS 2
             LD     DE,KONDI2PRCNT ; DETTE ER PLADS 2
             LD     BC,3           ; ANTAL TEGN DER SKAL FLYTTES
             LDIR                  ; HER BLIVER TEKSTEN FLYTTET
             LD     HL,MAALT_KAP   ; Mlt kapacitet (ASCII)
             LD     DE,KONDI1PRCNT ; DER HVOR DEN MLTE KAP. GEMMES
             LD     BC,3           ; Antal bytes der skal kopieres
             LDIR                  ; Flyt datablok
             CALL   AFLAD_SLUT

 ; HER ER ET OPLADE FORLB..

KO_OP_START: CALL   OPLADSTART
             LD     A,3            ; Marker at laderen er igang med at oplade
             LD     (LAD_STAT),A   ; s der kan fortsttes efter strm fejl
             LD     A,1
             LD     (LADNING_OP),A ; marker opladning ikke er frdig


KO_NET_OP:   CALL   OPLAD_NET
             CALL   CLS            ; Slet skrm
             LD     HL,TXT_KONDIOP ;'KONDI IGANG NR: '
             CALL   SKRIV
             LD     A,0FH
             LD     B,'1'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,(BAT_KONDINR) ; Hent antal kondi
             ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv antal kondi
             LD     A,$13          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI1PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD
             LD     A,$1B          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI2PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD

KO_LADE_LP:  CALL   OPLADE_UR      ; Skriver oplade tid
             CALL   HENTTAST
             CP     20
             JP     Z,KO_NET_OP    ; REFESH DISP. DER HVAR VRET OVER-TEMP.
             CP     10
             JP     Z,KO_OP_PAU    ; Fortryd?? Eller fortset
.IF LAVFINAL=0
             CP     3
             JP     Z,KO_OP_FIX
.ENDIF
             LD     A,(VOLTBIN)    ; Hent spnding p klemmerne
             CP     10             ; Test om der er over 1 Volt
             JP     C,KO_OP_PAU    ; Hvis ikke, hop
             LD     A,(LADNING_OP) ; Hent oplade status 1=Oplade
             CP     0              ;                    0=SLUT
             JP     NZ,KO_LADE_LP
             JP     KO_LADSLUT

KO_OP_FIX:   LD     A,0
             LD     (LADNING_OP),A
             JP     KO_LADE_LP

KO_OP_PAU:   CALL   OPLADPAUSE
             CALL   CLS
             LD     HL,TXT_KONDI4A
             CALL   SKRIV          ; Skriv 'KONDI PAUSET...'

KO_BRYDLOOP: CALL   HENTTAST
             CP     10             ; *=
             JP     Z,KONDI_AFBRYD ; Afbryd opladning
             CP     12             ; #=
             JP     Z,KO_PAUSLUT   ; Fortst opladning
             JP     KO_BRYDLOOP

KO_PAUSLUT:  ;CALL   CLS            ; Slet skrm
             ;LD     HL,TXT_KONDIOP ;'KONDI IGANG NR: '
             ;CALL   SKRIV
             ;LD     A,0FH
             ;LD     B,'1'
             ;CALL   GOTOPOS        ; Cursor til den rigtige position
             ;LD     A,(BAT_KONDINR) ; Hent antal kondi
             ;ADD    A,30H          ; konverter til ASCII
             ;CALL   SKRIVA         ; Skriv antal kondi
             LD     A,3
             LD     (LAD_STAT),A   ; Marker kondi-oplader igang
             CALL   OPLFORSET      ; Hent tid tller osv.
             JP     KO_NET_OP     ; Fortst opladningsloop

KO_LADSLUT:  CALL   OPLADSLUT

             LD     A,(BAT_KONDI)  ; Hent antal kondi
             LD     HL,BAT_KONDINR
             CP     (HL)           ; Forst hvis
             JP     NZ,KONDI_LOOP  ; kondinr forskellig fra antal-kondi
             JP     KONDI_SLUT
KONDI_AFBRYD: CALL   OPLADSLUT
             CALL   CLS
             LD     HL,TXT_KONDI3B ; 'KONDI ER AFBRUDT'
             CALL   SKRIV
             LD     A,$0A
             LD     B,'2'
             CALL   GOTOPOS
             LD     HL,MAALT_KAP
             CALL   SKRIV
KONDI_AFBRYD2: CALL   HENTTAST
             CP     $FF
             JP     Z,KONDI_AFBRYD2
             JP     HOVEDPRG

KONDI_SLUT:  CALL   OPLADSLUT
             CALL   CLS
             LD     HL,TXT_KONDI3A ; 'KONDI ER FRDIG'
             CALL   SKRIV
             LD     A,$0A
             LD     B,'2'
             CALL   GOTOPOS
             LD     HL,MAALT_KAP
             CALL   SKRIV
             LD     A,$13          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI2PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD
             LD     A,$1B          ; PEG P PLADS HVOR TEKST SKAL SKRIVES
             LD     B,'2'          ; LINIE I DISPLAY HVOR TEKST SKAL SKRIVES
             CALL   GOTOPOS        ; FLYT CURSOR TIL DEFINERET POSITION
             LD     HL,KONDI3PRCNT ; PEG P TEKST DER SKAL SKRIVES I LCD
             CALL   SKRIV          ; SKRIV TEKST I LCD

             CALL   SLUTLYDTEST    ; Test om der skal vre en lyd..
KONDI_SLUT2: CALL   HENTTAST
             CP     $FF
             JP     Z,KONDI_SLUT2
             JP     HOVEDPRG







;****************************
;*  VOLTMETER               *
;****************************
VOLTMETER:   CALL   CLS            ; KEA.  dato: 1/11-93
             LD     HL,TXT_VOLT_A  ; rom tekst
METER_COPY:  LD     DE,VOLT_DISPA  ; ram variabel r/w
             LD     BC,41          ; antal karaktere incl. stop
             LDIR

             LD     HL,TXT_VOLT_B ; her er linje 2
             LD     DE,VOLT_DISPB
             LD     BC,42          ; der er 2 stop karaktere i sidste linje.
             LDIR

RESETMINMAX: LD     A,(VOLTBIN)    ; Hent binr klemspnding
             LD     (VOLTMAX),A    ; gem klemspnding som max volt
             LD     (VOLTMIN),A    ; Gem klemspnding som min volt
VOLT_LOOP:   LD     A,(VOLTBIN)    ; Hent binr klemspnding
             CALL   VOLT_MAXMIN    ; Opdater min.- og maxspnding
             LD     HL,VOLT_DISPA+10  ; Peg hvor klemspnding skal skrives
             CALL   METER_ASCII    ; Konverter til ascii og indst tekst
             LD     A,(VOLTMAX)    ; Hent maximum volt
             LD     HL,VOLT_DISPB+3   ; peg hvor max.volt skal skrives
             CALL   METER_ASCII    ; Konverter til ascii og indst tekst
             LD     A,(VOLTMIN)    ; Hent minimum volt
             LD     HL,VOLT_DISPB+12  ; Peg hvor min.volt skal skrives
             CALL   METER_ASCII    ; Konverter til ascii og indst tekst
             CALL   LINE1          ; Cursor til linie 1
             LD     HL,VOLT_DISPA  ; Peg p VOLTMETER tekst streng
             CALL   SKRIV          ; Skriv i hele displayet.
             CALL   HENTTAST
             CP     0
             JP     Z,RESETMINMAX
             CP     10             ; TEST om der er trykket p # S
             JP     Z,ANDETPRG     ; Hop til forige menu.
             JP     VOLT_LOOP



;*******************************************
;*  BATTERI DATA BANK, OPRET, NDRE, SLET  *
;*******************************************
AN_BATT:     CALL   CLS
             LD     HL,TXT_DATABANK  ; BATTERI DATA-BANK MENU
             CALL   SKRIV            ; 1:OPRET 2:NDRE/VIS 3:SLET
AN_BATTLOOP: CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AN_OPRET     ; Opret nyt batteri
             CP     2              ; 3 tasten
             JP     Z,AN_VIS       ; NDRE/VIS batteri data
             CP     3              ; 2 tasten
             JP     Z,AN_SLET      ; Slet batteri fra ram bank
             CP     10             ; Fortryd-tasten
             JP     Z,ANDETPRG     ; Hvis ;, hop til forige menu.
             JP     AN_BATTLOOP

AN_OPRET:    LD     HL,BANK_TEST   ; Peg p frste adresse i DATA BANKEN
             LD     A,0
             LD     (BAT_BATNR),A   ; Nulstil decimal banktller
             LD     (BAT_BATNR+1),A ; Nulstil decimal banktller
AN_FINDFRI:  LD     A,(HL)          ; Hent test byte fra BANK
             CP     0
             JP     Z,AN_BANKFRI   ; Nr bank_test=0 s er banken fri.
             INC    H              ; Peg p nste bank (HL +256)
             LD     A,(BAT_BATNR+1) ; Hent ener
             INC    A               ; ener +1
             CP     10
             JP     Z,AN_BNR10      ; Hvis 10, hop
             LD     (BAT_BATNR+1),A ; gem ener
             JP     AN_FINDMERE

AN_BNR10:    LD     A,0
             LD     (BAT_BATNR+1),A ; Nulstil ener
             LD     A,(BAT_BATNR)  ; Hent tier
             INC    A              ; Tier +1
             LD     (BAT_BATNR),A  ; gem tier

AN_FINDMERE: CP     10             ; Decimaltller = 100?
             JP     Z,AN_BANKFULL  ; Hvis A=10 s er hele banken benyttet
             JP     AN_FINDFRI

AN_BANKFRI:  LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     (BANK_ADR),HL  ; Gem start adressen p den aktive BANK
             CALL   CLS
             LD     HL,TXT_OPRET   ; NYT OPRETTET
             CALL   SKRIV          ; BATTERI NR.
             LD     A,0CH
             LD     B,'2'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,(BAT_BATNR)  ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     A,(BAT_BATNR+1) ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
AN_BANKFRI2: CALL   HENTTAST       ; Vnt p at der er trykket p en tast
             CP     $FF
             JP     Z,AN_BANKFRI2
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             INC    HL             ; Start adresse til navn
             LD     D,H
             LD     E,L            ; DE = Destination
             LD     HL,TXT_OPRET_STRING  ; KAN VRE FOLKS NAVN, VI BRUGER ....
             LD     BC,17          ; Antal karaktere
             LDIR                  ; kopier

AN_OPNAVN:   CALL   CLS
             LD     HL,TXT_BATNAVN ; INDTAST BATTERI NAVNET:'
             CALL   SKRIV
             CALL   NAVN_EDIT
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_BATT

AN_OPKAP:    CALL   INPUT_KAP
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_OPNAVN

 ; GEM KAPASITET I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,12H          ; Peg p kapasitet plads
             LD     D,H            ; DE destination
             LD     HL,BAT_KAP     ; HL Source
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM-Bank

AN_OPTID:    CALL   INPUT_OPTID
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_OPKAP

 ; TEST OM OPLADNING KAN FORETAGES

             CALL   OPTIMETEST     ; Test af input og beregning af-
             CP     0              ; opladestrm til DAC.
             JP     Z,AN_OPTID

 ; GEM OPLADE TIMER I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1AH          ; Peg p opladnings timer
             LD     BC,BAT_OP_TIM
             LD     A,(BC)         ; Hent tier
             LD     (HL),A         ; Gem Time Tier i RAM BANK
             INC    HL
             INC    BC
             LD     A,(BC)         ; Hent ener
             LD     (HL),A         ; Gem Time ener i RAM BANK

 ; GEM OPLADE STRM I BANK (til DAC)

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1EH          ; Peg p opladnings strm
             LD     A,(BAT_OP_DAC) ; hent strm fra RAM variabel
             LD     (HL),A         ; Gem oplade STRM i RAM-Bank

AN_OPSTROM:  CALL   AF_STROM       ; Indtast aflade strm
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_OPTID

 ; GEM AFLADE STRM I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,16H          ; Peg p AFLADE STRM
             LD     D,H            ; DE destination
             LD     HL,BAT_AF_mA   ; HL Source
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem aflade strm i RAM-Bank
             CALL   AF_CELLER
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_OPSTROM

 ; GEM ANTAL CELLER I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,1CH          ; Peg p antal celler
             LD     D,H            ; DE destination
             LD     HL,BAT_CELLER  ; HL Source
             LD     BC,2           ; Antal bytes der skal kopieres
             LDIR                  ; Gem i antal celler i RAM-Bank
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     A,0FFH
             LD     (HL),A         ; Marker at banken er i brug
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,20H          ; Peg p kapasitet malinger
             LD     D,H            ; DE destination
             LD     HL,TXT_BATMAAL  ; HL Source
             LD     BC,50          ; Antal bytes der skal kopieres
             LDIR                  ; Gem i antal celler i RAM-Bank
             CALL   CLS
             LD     HL,TXT_BAT_GEMT ; BATTERI DATA ER GEMT I NR.XX
             CALL   SKRIV
             LD     A,0EH
             LD     B,'2'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(BAT_BATNR)  ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     A,(BAT_BATNR+1) ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
AN_OPSTROM2: CALL   HENTTAST       ; Vent p at der er trykket p en tast
             CP     $FF
             JP     Z,AN_OPSTROM2
             JP     AN_BATT        ; Hop til batteri menu

AN_BANKFULL: CALL   CLS
             LD     HL,TXT_BANK_FYLDT  ;  BATTERI DATABANK ER FYLDT
              CALL   SKRIV             ;  SLET UBRUGTE BATTERIER
AN_BANKFULL2: CALL   HENTTAST          ; Vent p at der er trykket p en tast
              CP     $FF
              JP     Z,AN_BANKFULL2
              JP     AN_BATT        ; Hop til batteri menu

AN_SLET:     CALL   IND_BANK
             CP     0              ; Hvis a=0
             JP     Z,AN_BATT      ; s er der fejl...
             CALL   CLS
             LD     HL,TXT_KLAR_SLET  ; KLAR TIL AT SLETTE BATTERI??
             CALL   SKRIV
AN_SLETNO:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AN_SLETOK    ;
             CP     10             ; Fortryd-tasten
             JP     Z,AN_BATT      ; Hvis ;, hop til BATTERI menu
             JP     AN_SLETNO

AN_SLETOK:   LD     HL,(BANK_ADR)
             LD     (HL),0         ; Slet bank
             CALL   CLS
             LD     HL,TXT_BAT_SLETTET ; BATTERI DATA ER SLETTET
             CALL   SKRIV
AN_SLETOK2:  CALL   HENTTAST
             CP     $FF
             JP     Z,AN_SLETOK2
             JP     AN_BATT        ; Hop til batteri menu

AN_VIS:      CALL   CLS
             LD     HL,TXT_BAT5A   ; 'INPUT BATTERI BANK NR:  '
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Cursorposition
             LD     D,2            ; Max. antal input cifre
             LD     HL,BAT_BATNR   ; Startadr. hvor Batterinr gemmes
             CALL   TASTEINPUT     ; Hent Batterinr.
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_BATT      ; Hop til forige, hvis fortryd
             LD     HL,BAT_BATNR   ; Peg p tal der skal konverteres
             CALL   KONV_2DECI     ; konverter til HEX med 2 decimaler
             LD     HL,BANK_TEST   ; Peg p frste batteri bank
             ADD    A,H            ; adder indtastet nr til.
             LD     H,A
             LD     A,(HL)         ; Hent test data, fra indtastet bank nr
             CP     0
             JP     NZ,AN_B_FINDES ; Hvis OK, hop til BANK FINDES
             CALL   CLS
             LD     HL,TXT_BAT_FINDES_IKKE;
             CALL   SKRIV
AN_VIS2:     CALL   HENTTAST
             CP     $FF
             JP     Z,AN_VIS2
             JP     AN_BATT        ; HOP, der er der fejl...

AN_B_FINDES: LD     (BANK_ADR),HL  ; Gem adressen p banken
AN_OKNAVN:   CALL   CLS
             LD     HL,TXT_TJECK_NAVN
             CALL   SKRIV
             LD     A,$0D
             LD     B,'1'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(BAT_BATNR)  ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     A,(BAT_BATNR+1) ; Hent enere
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     HL,(BANK_ADR)
             LD     L,1            ; Peg p navn tekst start.
             CALL   LINE2
             CALL   SKRIV          ; Udskriv batteri navn

AN_EDITTEST: CALL   HENTTAST
             CP     10             ;
             JP     Z,AN_EDITNAVN  ; Hvis * hop EDIT NAVN
             CP     12
             JP     Z,AN_VISMER1   ; Hvis #, g til nste input
             JP     AN_EDITTEST

AN_EDITNAVN: CALL   NAVN_EDIT
             LD     A,(FORTRYDTAST)
             CP     $FF
             JP     Z,AN_VIS       ; hop til forige, hvis fortryd

AN_VISMER1:  CALL   CLS
             LD     HL,TXT_TJECK_KAP
             CALL   SKRIV
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,12H          ; Peg p kapasitet plads
             CALL   LINE2          ; Her skal kapasiteten sdskrives
             CALL   VIS_DATA4      ; Udskriv kapasiteten

AN_VISKAPA:  CALL   HENTTAST
             CP     10             ;
             JP     Z,AN_NYKAP     ; Hvis ;, hop EDIT KAPASITET
             CP     12
             JP     Z,AN_VISMER2   ; Hvis #, g til nste input
             JP     AN_VISKAPA

AN_NYKAP:    CALL   INPUT_KAP
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_OKNAVN    ; hop til forige, hvis fortryd

 ; GEM KAPASITET I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,12H          ; Peg p kapasitet plads
             LD     D,H            ; DE destination
             LD     HL,BAT_KAP     ; HL Source
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM-Bank
             CALL   OPTIMETEST     ; Test af input og beregning af-
             CP     0              ; opladestrm til DAC.
             JP     Z,AN_NYOPTID

AN_VISMER2:  CALL   CLS
             LD     HL,TXT_TJECK_AFLADE
             CALL   SKRIV
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,16H          ; Peg p aflade strm plads
             CALL   LINE2          ; Her skal AFLADE strm udskrives
             CALL   VIS_DATA4      ; Udskriv

AN_VAFSTR0M: CALL   HENTTAST
             CP     10             ;
             JP     Z,AN_NYAFSTR   ; Hvis * hop ny afladestrm
             CP     12
             JP     Z,AN_VISMER3   ; Hvis #, g til nste input
             JP     AN_VAFSTR0M

AN_NYAFSTR:  CALL   AF_STROM
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_VISMER1   ; hop til forige, hvis fortryd

 ; GEM AFLADE STRM I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,16H          ; Peg p AFLADE STRM
             LD     D,H            ; DE destination
             LD     HL,BAT_AF_mA   ; HL Source
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem aflade strm i RAM-Bank

AN_VISMER3:  CALL   CLS
             LD     HL,TXT_TJECK_OPLADE
             CALL   SKRIV
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1AH          ; Peg p OPLADE TID plads
             CALL   LINE2
             CALL   VIS_DATA2

AN_VOPTID:   CALL   HENTTAST
             CP     10             ;
             JP     Z,AN_NYOPTID   ; Hvis * hop ny OPLADE TID
             CP     12
             JP     Z,AN_VISMER4   ; Hvis #, g til nste input
             JP     AN_VOPTID

AN_NYOPTID:  CALL   INPUT_OPTID
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_VISMER2   ; hop til forige, hvis fortryd

 ; TEST OM OPLADNING KAN FORETAGES

             CALL   OPTIMETEST     ; Test af input og beregning af-
             CP     0              ; opladestrm til DAC.
             JP     Z,AN_NYOPTID

 ; GEM OPLADE TIMER I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1AH          ; Peg p opladnings timer

             LD     BC,BAT_OP_TIM
             LD     A,(BC)         ; Hent tier
             LD     (HL),A         ; Gem Time Tier i RAM BANK
             INC    HL
             INC    BC
             LD     A,(BC)         ; Hent ener
             LD     (HL),A         ; Gem Time ener i RAM BANK

 ; GEM OPLADE STRM I BANK (til DAC)

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1EH          ; Peg p opladnings strm
             LD     A,(BAT_OP_DAC) ; hent strm fra RAM variabel
             LD     (HL),A         ; Gem oplade STRM i RAM-Bank

AN_VISMER4:  CALL   CLS
             LD     HL,TXT_TJECK_CELLER
             CALL   SKRIV
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1CH          ; Peg p ANTAL CELLER plads
             CALL   LINE2
             CALL   VIS_DATA2

AN_VCELLER:  CALL   HENTTAST
             CP     10             ;
             JP     Z,AN_NYCELLER  ; Hvis ;, hop ny ANTAL CELLER
             CP     12
             JP     Z,AN_VISMAAL   ; Hvis #, g til bage til start
             JP     AN_VCELLER

AN_NYCELLER: CALL   AF_CELLER
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,AN_VISMER3   ; hop til forige, hvis fortryd

 ; GEM ANTAL CELLER I BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     E,$1C          ; Peg p antal celler
             LD     D,H            ; DE destination
             LD     HL,BAT_CELLER  ; HL Source
             LD     BC,2           ; Antal bytes der skal kopieres
             LDIR                  ; Gem i antal celler i RAM-Bank

AN_VISMAAL:  CALL   CLS
             LD     HL,TXT_MALINGER
             CALL   SKRIV
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,$20          ; Peg p frste kapacitets mling.

             LD     A,6            ; DER HVOR SELVE MLINGEN SKAL ST
             LD     B,'1'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     B,5
AN_VISMAAL2: CALL   SKRIV
             LD     A,' '
             CALL   SKRIVA
             CALL   SKRIVA
             LD     A,5
             ADD    A,L
             LD     L,A
             DJNZ   AN_VISMAAL2

             LD     A,6            ; DER HVOR SELVE MLINGEN SKAL ST
             LD     B,'2'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     B,5
AN_VISMAAL3: CALL   SKRIV
             LD     A,' '
             CALL   SKRIVA
             CALL   SKRIVA
             LD     A,5
             ADD    A,L
             LD     L,A
             DJNZ   AN_VISMAAL3


AN_VISMAAL4: CALL   HENTTAST
             CP     $ff
             JP     Z,AN_VISMAAL4    ; HVIS ALT ANDET ER TRYKKET S INGENTING

AN_EDITSLUT: CALL   CLS
             LD     HL,TXT_BAT_GEMT  ; BATTERI DATA ER GEMT I NR.
             CALL   SKRIV
             LD     A,0EH
             LD     B,'2'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(BAT_BATNR)  ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     A,(BAT_BATNR+1) ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
AN_EDITSLUT2: CALL   HENTTAST       ; Vnt p at der er trykket p en tast
             CP     $FF
             JP     Z,AN_EDITSLUT2
             JP     AN_BATT        ; Hop til batteri menu



;****************************
;*  KODE-SETUP              *
;****************************
AN_KODE:     CALL   CLS
             LD     HL,TXT_KODE1A  ; Peg p: '1:VIS KODE TID '
             CALL   SKRIV
AN_KOLOOP:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AN_KODEVIS   ; Vis hvor lang tid der er tilbage
             CP     2              ; 2 tasten
             JP     Z,AN_KODETID   ; Tiden skal indtastes med KODEN
             CP     10             ; Fortryd-tasten
             JP     Z,AN_MERE1     ; Hvis * hop til forige menu.
             JP     AN_KOLOOP

AN_KODEVIS:  CALL   CLS
             LD     HL,TXT_KODE2A  ; Peg p: 'TID TIL KODE:'
             CALL   SKRIV
AN_VISKODLP: LD     A,$05
             LD     B,'2'
             CALL   GOTOPOS
             CALL   SKRIVUR
             CALL   HENTTAST
             CP     $FF
             JP     Z,AN_VISKODLP
             CP     10             ; Fortryd-tasten
             JP     Z,AN_KODE      ; Hvis * hop til forige menu.
             LD     A,(KODERUN)
             CP     55H
             JP     NZ,AN_TIDSLUT  ; Hvis tid udlbet, hop
             LD     BC,2000        ; 0.2 SEK ELLERS MEGET ACTION P COM. PORT
             CALL   PAUSE
             JP     AN_VISKODLP    ; Hop til vis-kode-loop

AN_TIDSLUT:  CALL   LINE2
             LD     HL,TXT_KODE0B  ; '00:00:00:00'
             CALL   SKRIV
AN_TIDSLUT2: CALL   HENTTAST       ; Vent p at der trykkes p en tast
             CP     $FF
             JP     Z,AN_TIDSLUT2
             JP     AN_KODE        ; Hop til mode menu

AN_KODETID:  CALL   KODE           ; Test om der er adgangs tilladelse -
             CP     0
             JP     Z,AN_KODETID   ; hvis ikke, PRV IGEN
AN_KODETID2: CALL   CLS
             LD     HL,TXT_KODE2A  ; 'TID TIL KODE:'
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Position for cursor
             LD     D,2            ; 2 cifre
             LD     HL,DAGE_TI     ;
             CALL   TASTEINPUT     ; Indls data 1-99
             LD     IX,MAX_DAGE
             LD     IY,MIN_DAGE
             LD     HL,DAGE_TI
             LD     B,2            ; Antal cifre der skal testes
             LD     C,5            ; Fejl tekst, Hvis fejl
             CALL   INPUT_TEST
             DEC    C
             BIT    7,C
             JP     Z,AN_KODETID2  ; Hop, hvis fejl i input
             LD     A,(DAGE_TI)    ; Hent dage tiere
             LD     (KODE_DAG10),A ; Gem indtastet dage tiere
             LD     A,(DAGE_EN)    ; Hent dage enere
             LD     (KODE_DAG1),a  ; Gem indtastet dage enere

             DI                    ; Disable interrupt, s der ikke sker
             LD     A,0            ; fejl opdatering pga. nedtlling samtidig
             LD     (SEK_EN),A     ; Nulstil kode ur
             LD     (SEK_TI),A
             LD     (MIN_EN),A
             LD     (MIN_TI),A
             LD     (TIM_EN),A
             LD     (TIM_TI),A
             EI                    ; Enable interrupt igen
             CALL   CLS
             LD     HL,TXT_KODE3A  ; 'NU ER ANTAL DAGE'
             CALL   SKRIV
AN_KODETID3: CALL   HENTTAST
             CP     $FF
             JP     Z,AN_KODETID3
             JP     AN_KODE        ; Hop tilbage til kode menu



;****************************
;*  LYD-SETUP               *
;****************************
AN_LYD:      CALL   BLINK_OFF
             CALL   CLS
             LD     HL,TXT_ANDET2A ; LYD SETUP MENU
             CALL   SKRIV          ; 1:TASTEKLIK 2:FRDIG LYD
AN_L_LOOP:   CALL   HENTTAST
             CP     1              ; 1 tasten
             JP     Z,AN_KEY       ; Keyklik menu
             CP     2              ; 2 tasten
             JP     Z,AN_LYDEN     ; Frdig lyde menu
             CP     10             ; Fortryd-tasten
             JP     Z,AN_MERE1     ; Hvis ;, hop til forige menu
             JP     AN_L_LOOP      ; hop til andet-lyd-loop

AN_KEY:      CALL   CLS
             LD     HL,TXT_ANDET2B ; TASTE KLIK SETUP '
             CALL   SKRIV          ; 1:KRAFTIGERE 2:SVAGERE
AN_KEYLOOP:  CALL   HENTTAST       ; henttast og keyklik bruges
             CP     1              ; 2 tasten
             JP     Z,AN_KEYOP     ; Lyd skal vre lngere
             CP     2              ; 8 tasten
             JP     Z,AN_KEYNED    ; Lyd skal vre kortere
             CP     10             ; Fortryd-tasten
             JP     Z,AN_LYD       ; Hvis * hop tilbage
             JP     AN_KEYLOOP

AN_KEYOP:    LD     A,(KEYBPREF)   ; Hent Keylyd
             INC    A
             CP     51
             JP     Z,AN_KEYMAX    ; Hvis perioder=0, hop
             LD     (KEYBPREF),A   ; Gem Keylyd
             JP     AN_KEYLOOP

AN_KEYNED:   LD     A,(KEYBPREF)   ; Hent Keylyd
             DEC    A
             BIT    7,A
             JP     NZ,AN_KEYMIN   ; Hvis perioder<0, hop
             LD     (KEYBPREF),A   ; Gem Keylyd
             JP     AN_KEYLOOP

AN_KEYMIN:   LD     A,0            ; Antal perioder m ikke blive mindre end 0
             LD     (KEYBPREF),A   ; Gem Keylyd
             JP     AN_KEYLOOP

AN_KEYMAX:   LD     A,50           ; Antal perioder m ikke kre i ring
             LD     (KEYBPREF),A   ; Gem Keylyd
             JP     AN_KEYLOOP



; SLUT LYD TIL INDIKERING. NR AFLAD, OPLAD, ELLER KONDI ER FRDI

AN_LYDEN:    CALL   CLS
AN_SL_LOOP:  CALL   BLINK_OFF      ; S cursor ikke flimre mens der skrives..
             CALL   LINE1
             LD     HL,TXT_ANDET2C ; 1:ALARM 2:MELO 3:SKALA 4:READY 5:DING OSV
             CALL   SKRIV


ANSLVENT:    CALL   ANSL_CURSOR    ; Flyt cursor til valgt lyd
             CALL   BLINK_ON
ANSLVENT2:   CALL   HENTTAST       ; henttast og keyklik bruges
             CP     $FF
             JP     Z,ANSLVENT2
             CP     0              ; 1 tasten
             JP     Z,AN_SL_NO     ; Ingen slut lyd
             CP     1              ; 2 tasten
             JP     Z,AN_SL_ALAR   ; Alarm som slut lyd
             CP     2              ; 3 tasten
             JP     Z,AN_SL_MELO   ; Melodi som slut lyd
             CP     3              ; 4 tasten
             JP     Z,AN_SL_SKAL   ; Scalalyd som slut lyd
             CP     4
             JP     Z,AN_SL_SMP    ; SAMPLES
             CP     5
             JP     Z,AN_SL_FAD    ; FADE-LYD
             CP     6
             JP     Z,AN_SL_FAD2   ; FADE-LYD2
             CP     7
             JP     Z,AN_SL_TING   ;
             CP     8
             JP     Z,AN_SL_FLIP
             CP     10             ; TILBAGE-Tasten
             JP     Z,AN_LYD       ; Hvis * hop til forige menu.
             JP     ANSLVENT       ; Hop til slut-lyd-loop

AN_SL_NO:    LD     A,0
             LD     (SLUTPREF),A   ; Ingen lyd = 0
             JP     ANSLVENT       ; Hop til slut-lyd-loop

AN_SL_ALAR:  LD     A,1
             LD     (SLUTPREF),A   ; Alarm lyd = 1
             JP     AN_SL_SPIL

AN_SL_MELO:  LD     A,2
             LD     (SLUTPREF),A   ; Melodi lyd = 2
             JP     AN_SL_SPIL

AN_SL_SKAL:  LD     A,3
             LD     (SLUTPREF),A   ; Skala lyd = 3
             JP     AN_SL_SPIL

AN_SL_SMP:   LD     A,4
             LD     (SLUTPREF),A   ; Sample lyd = 4
             JP     AN_SL_SPIL

AN_SL_FAD:   LD     A,5
             LD     (SLUTPREF),A   ; Sample lyd = 5
             JP     AN_SL_SPIL

AN_SL_FAD2:  LD     A,6
             LD     (SLUTPREF),A   ; Sample lyd = 6
             JP     AN_SL_SPIL

AN_SL_TING:  LD     A,7
             LD     (SLUTPREF),A   ; Sample lyd = 7
             JP     AN_SL_SPIL

AN_SL_FLIP:  LD     A,8
             LD     (SLUTPREF),A   ; Sample lyd = 8

AN_SL_SPIL:  CALL   ANSL_CURSOR    ; Cursor opdteres fr, der afspilles lyd.
             LD     A,(SLUTPREF)   ; Henter slut kontrol ord
             CP     0
             JP     Z,AN_SL_LOOP
             CP     1
             CALL   Z,LYDALARM     ; Hvis det = 1 s afspil alarmlyd
             CP     2
             CALL   Z,LYDMELO      ; Hvis det = 2 s afspil melodi
             CP     3
             CALL   Z,LYDSKAL      ; Hvis det = 3 s afspil skala
             CP     4
             CALL   Z,SAMPLE
             CP     5
             CALL   Z,LYDFADER
             CP     6
             CALL   Z,LYDFADER2
             CP     7
             CALL   Z,LYDTING
             CP     8
             CALL   Z,LYDFLIP
             JP     ANSLVENT



ANSL_CURSOR: LD     A,(SLUTPREF)   ; sub-routine til at opdatere cursoren.
             CP     0
             JP     Z,ANSL0
             CP     1
             JP     Z,ANSL1
             CP     2
             JP     Z,ANSL2
             CP     3
             JP     Z,ANSL3
             CP     4
             JP     Z,ANSL4
             CP     5
             JP     Z,ANSL5
             CP     6
             JP     Z,ANSL6
             CP     7
             JP     Z,ANSL7
ANSL8:       LD     A,$17
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL7:       LD     A,$17
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL6:       LD     A,$10
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL5:       LD     A,$10
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL4:       LD     A,$08
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL3:       LD     A,$08
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL2:       LD     A,$00
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL1:       LD     A,$00
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANSLCUSLUT
ANSL0:       LD     A,$1F
             LD     B,'1'
             CALL   GOTOPOS
ANSLCUSLUT:  RET





;****************************
;*  SKRIV DIVERSE INFO      *
;****************************
AN_INFO:     CALL   CLS
             LD     HL,TXT_INFO0
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST
             CP     10
             JP     Z,AN_MERE1
             CALL   CLS
             LD     HL,TXT_INFO1
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST
             CP     10
             JP     Z,AN_MERE1
             CALL   CLS
             LD     HL,TXT_INFO2
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST
             CP     10
             JP     Z,AN_MERE1
             CALL   CLS
             LD     HL,TXT_INFO3
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST
             CP     10
             JP     Z,AN_MERE1
             CALL   CLS
             LD     HL,TXT_INFO4
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST
             CP     10
             JP     Z,AN_MERE1
             CALL   CLS
             LD     HL,TXT_INFO5
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST     ; PAUSE 1.7 Sekund
             CP     10
             JP     Z,AN_MERE1

             CALL   CLS
             LD     HL,TXT_INFO6
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST     ; PAUSE 1.7 Sekund
             CP     10
             JP     Z,AN_MERE1

             CALL   CLS            ; Clear display og cursor home
             LD     HL,TXT_INFO7
             CALL   SKRIV          ; Skriv tekst
             CALL   PAU_S_TAST     ; PAUSE 1.7 Sekund
             CP     10
             JP     Z,AN_MERE1

             JP     AN_INFO





;****************************
;*  COM-SETUP (SERIAL PORT) *
;****************************
AN_SERI:     CALL   CLS
             LD     HL,TXT_ANSER
             CALL   SKRIV
AN_SERI2:    LD     A,(SER_ON)     ; HENT ON-OFF STATUS
             CP     1
             JP     Z,ANPOSON
             JP     ANPOSOFF

AN_S_LOOP:   CALL   HENTTAST
             CP     1
             JP     Z,AN_SER_ON
             CP     2
             JP     Z,AN_SER_OFF
             CP     3
             JP     Z,AN_BAUD      ;
             CP     10             ; Fortryd-tasten
             JP     Z,AN_SERPRUT   ; Hvis * hop til forige menu
             JP     AN_S_LOOP      ; hop til andet-lyd-loop

AN_SER_ON:   LD     A,1
             LD     (SER_ON),A     ; GEM I VARIABEL
             JP     AN_SERI2

AN_SER_OFF:  LD     A,0
             LD     (SER_ON),A
             JP     AN_SERI2

AN_SERPRUT:  CALL   CURSOR_OFF     ; SLUK CURSOR FR DER VENDES TILBAGE
             JP     AN_MERE1

ANPOSON:     LD     A,$00          ; CURSOREN FLYTTES BARE
             LD     B,'1'
             CALL   GOTOPOS
             CALL   BLINK_ON
             JP     AN_S_LOOP
ANPOSOFF:    LD     A,$00
             LD     B,'2'
             CALL   GOTOPOS
             CALL   BLINK_ON
             JP     AN_S_LOOP

AN_BAUD:     CALL   BLINK_OFF
             CALL   LINE1
             LD     HL,TXT_ANDETSE  ; SERIAL BAUD VALG MENU
             CALL   SKRIV
             CALL   BLINK_ON

ANBAVENT:    CALL   ANBA_CURSOR
ANBAVENT2:   CALL   HENTTAST       ; henttast og keyklik bruges
             CP     $FF
             JP     Z,ANBAVENT2
             CP     1
             JP     Z,AN_BA1200
             CP     2
             JP     Z,AN_BA2400
             CP     3
             JP     Z,AN_BA4800
             CP     4
             JP     Z,AN_BA9600
             CP     5
             JP     Z,AN_BA19K2
             CP     6
             JP     Z,AN_BA38K4
             CP     7
             JP     Z,AN_BA57K6
             CP     8
             JP     Z,AN_BA76K8
             CP     10             ; * TILBAGE-Tasten
             JP     Z,AN_BASLUT
             JP     ANBAVENT

AN_BASLUT:   CALL   CURSOR_OFF     ; SLUK LIGE CURSOR FR RETUR TIL MENU.
             JP     AN_SERI

AN_BA1200:   LD     A,1
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA2400:   LD     A,2
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA4800:   LD     A,3
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA9600:   LD     A,4
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA19K2:   LD     A,5
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA38K4:   LD     A,6
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA57K6:   LD     A,7
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT

AN_BA76K8:   LD     A,8
             LD     (SER_BAUD),A
             CALL   INIT_UART
             JP     ANBAVENT
                                   ; SUB TIL AT OPDATERE CURSOREN.
ANBA_CURSOR: LD     A,(SER_BAUD)   ; HENT AKTIV BAUD
             CP     1
             JP     Z,ANBA1
             CP     2
             JP     Z,ANBA2
             CP     3
             JP     Z,ANBA3
             CP     4
             JP     Z,ANBA4
             CP     5
             JP     Z,ANBA5
             CP     6
             JP     Z,ANBA6
             CP     7
             JP     Z,ANBA7
ANBA8:       LD     A,$15
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA7:       LD     A,$15
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA6:       LD     A,$0E
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA5:       LD     A,$0E
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA4:       LD     A,$07
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA3:       LD     A,$07
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA2:       LD     A,$00
             LD     B,'2'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA1:       LD     A,$00
             LD     B,'1'
             CALL   GOTOPOS
             JP     ANBACUSLUT
ANBA0:       LD     A,$1F
             LD     B,'1'
             CALL   GOTOPOS
ANBACUSLUT:  RET





;******************************************************************
;*       SUB-RUTINE..: KONV_2DECI                                 *
;*       Funktion....: Konverterer 2-cifret decimaltal til hexa-  *
;*                     decimaltal i A-reg.                        *
;*       Input.......: HL peger p de to decimalcifre             *
;*       Output......: Hexadecimaltal i A-reg.                    *
;*       delgger...: HL,A                                       *
;*       Kalder......: Ingen                                      *
;*       Initialer...: KEA.   dato: 25/10-93                      *
;******************************************************************
KONV_2DECI:  PUSH   BC
             LD     A,0
             CP     (HL)
             JP     Z,KONV_2_EN
             LD     B,(HL)
KONV_2LOOP:  ADD    A,10
             DJNZ   KONV_2LOOP
KONV_2_EN:   INC    HL            ; enere
             ADD    A,(HL)
             POP    BC
             RET



;******************************************************************
;        SUB-RUTINE..: KONV_4DECI                                 ;
;        Funktion....: Konverterer 4-cifret decimaltal til hexa-  ;
;                      decimaltal i HL-reg.                       ;
;        Input.......: IX peger p de 4 decimal der skal konvert. ;
;        Output......: Hexadecimaltal i HL-reg.                   ;
;        delgger...:                                            ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 25/10-93                      ;
;******************************************************************
KONV_4DECI:  PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     B,(IX+0)
             LD     HL,0
             INC    B
             DEC    B
             JP     Z,KONV_4_HUND
             LD     DE,1000
KONV_4LOOP1: ADD    HL,DE
             DJNZ   KONV_4LOOP1
KONV_4_HUND: LD     B,(IX+1)
             INC    B
             DEC    B
             JP     Z,KONV_4_TIER
             LD     DE,100
KONV_4LOOP2: ADD    HL,DE
             DJNZ   KONV_4LOOP2
KONV_4_TIER: LD     B,(IX+2)
             INC    B
             DEC    B
             JP     Z,KONV_4_ENER
             LD     DE,10
KONV_4LOOP3: ADD    HL,DE
             DJNZ   KONV_4LOOP3
KONV_4_ENER: LD     B,(IX+3)
             INC    B
             DEC    B
             JP     Z,KONV_4_SLUT
             LD     DE,1
KONV_4LOOP4: ADD    HL,DE
             DJNZ   KONV_4LOOP4

KONV_4_SLUT: POP    DE
             POP    BC
             POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: HEX_DIV10                                  ;
;        Funktion....: Dividerer tallet i HL-reg. med 10 og lgger;
;                      resultatet i HL-reg. (Runder op)           ;
;        Input.......: HL indeholder tallet der skal divideres.   ;
;        Output......: Hexadecimaltal i HL-reg                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 25/10-93                      ;
;******************************************************************
HEX_DIV10:   PUSH   DE
             PUSH   BC
             LD     BC,0
             LD     DE,10
DIV10_LOOP:  INC    C
             CALL   Z,DIV10_INC
             OR     A              ; Clear carry flag
             SBC    HL,DE
             JP     C,DIV10_SLUT
             JP     Z,DIV10_SLUT
             JP     DIV10_LOOP
DIV10_SLUT:  LD     H,B
             LD     L,C
             POP    BC
             POP    DE
             RET
DIV10_INC:   INC    B
             RET



;******************************************************************
;        SUB-RUTINE..: HEX_DIV5                                   ;
;        Funktion....: Dividerer tallet i HL-reg. med 5 og lgger ;
;                      resultatet i A-reg. (Runder op)            ;
;        Input.......: HL indeholder tallet der skal divideres.   ;
;        Output......: Hexadecimaltal i A-reg.                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 25/10-93                      ;
;******************************************************************
HEX_DIV5:    PUSH   DE
             LD     DE,5
             LD     A,0
             OR     A              ; Clear carry flag
DIV5_LOOP:   INC    A
             SBC    HL,DE
             JP     C,DIV5_SLUT
             JP     Z,DIV5_SLUT
             JP     DIV5_LOOP
DIV5_SLUT:   POP    DE
             RET



;******************************************************************
;        SUB-RUTINE..: HEX_DIV3                                   ;
;        Funktion....: Dividerer tallet i HL-reg. med 3 og lgger ;
;                      resultatet i A-reg. (Runder op)            ;
;        Input.......: HL indeholder tallet der skal divideres.   ;
;        Output......: Ht/              A-reg.                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 28/10-93                      ;
;******************************************************************
HEX_DIV3:    PUSH   DE
             PUSH   BC
             LD     BC,0
             LD     DE,3
DIV3_LOOP:   INC    C
             CALL   Z,DIV3_INC
             OR     A              ; Clear carry flag
             SBC    HL,DE
             JP     C,DIV3_SLUT
             JP     Z,DIV3_SLUT
             JP     DIV3_LOOP
DIV3_SLUT:   LD     H,B
             LD     L,C
             POP    BC
             POP    DE
             RET
DIV3_INC:    INC    B
             RET



;******************************************************************
;        SUB-RUTINE..: HEX_MUL18                                  ;
;        Funktion....: Multiplicerer HL-reg. med 18 og lgger     ;
;                      resultatet i HL-reg.                       ;
;        Input.......: HL indeholder tallet der skal multipliceres;
;        Output......: Hexadecimaltal i HL-reg                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 25/10-93                      ;
;******************************************************************
HEX_MUL18:   PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     D,H
             LD     E,L
             LD     B,4
MUL18_LOOP:  SLA    H
             SLA    L
             CALL   C,MUL18_MENTE
             DJNZ   MUL18_LOOP
             LD     B,2
MUL18_LOOP2: ADD    HL,DE
             DJNZ   MUL18_LOOP2
             POP    DE
             POP    BC
             POP    AF
             RET
MUL18_MENTE: SET    0,H
             RET



;******************************************************************
;        SUB-RUTINE..: HEX_MUL6                                   ;
;        Funktion....: Multiplicerer HL-reg. med 6 og lgger      ;
;                      resultatet i HL-reg.                       ;
;        Input.......: HL indeholder tallet der skal multipliceres;
;        Output......: Hexadecimaltal i HL-reg                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 28/10-93                      ;
;******************************************************************
HEX_MUL6:    PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     D,H
             LD     E,L
             LD     B,5
MUL6_LOOP2:  ADD    HL,DE
             DJNZ   MUL6_LOOP2
             POP    DE
             POP    BC
             POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: DIV_HL_DE                                  ;
;        Funktion....: Dividerer tallet i HL-reg. med tallet i    ;
;                      DE-reg. og lgger resultatet i HL-reg.     ;
;                      (Runder ned)                               ;
;        Input.......: HL indeholder tallet i nvneren.           ;
;                      DE indeholder tallet i tlleren.           ;
;        Output......: Hexadecimaltal i HL-reg                    ;
;        delgger...: HL                                         ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 25/10-93                      ;
;******************************************************************
DIV_HL_DE:   PUSH   AF
             PUSH   BC
             LD     BC,0
             DEC    D
             INC    D
             JP     Z,DIV_HL_TEST
             JP     DIV_HL_LOOP
DIV_HL_TEST: DEC    E
             INC    E
             JP     Z,DIV_HL_FEJL
DIV_HL_LOOP: OR     A              ; Clear carry flag
             SBC    HL,DE
             JP     C,DIV_HL_SLUT
             JP     Z,DIV_HL_SLUT
             INC    C
             CALL   Z,DIV_HL_MNTE
             JP     DIV_HL_LOOP
DIV_HL_SLUT: LD     H,B
             LD     L,C
             POP    BC
             POP    AF
             RET
DIV_HL_MNTE: INC    B
             RET
DIV_HL_FEJL: LD     HL,0FFFFH
             JP     DIV_HL_SLUT


;*********************************************************************
;        SUB-RUTINE..: VIS_DATA4                                     ;
;        Funktion....: Udlser bank data til display 4CIFRE          ;
;        Input.......: HL,Startdata                                  ;
;        Output......: ASCII Tal I LCD                               ;
;        delgger...: A, HL                                         ;
;        Kalder......: DISPLAYBUSY                                   ;
;        Initialer...: TST.   dato: 29/10-93                         ;
;*********************************************************************
VIS_DATA4:   LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(HL)         ; Hent 1.ciffer
             CP     0
             JP     NZ,F0RSTE_OK   ; hvis 1. er nul skrives et space
             LD     A,20H          ; skriv space
             CALL   SKRIVA         ; Skriv tal
             INC    HL             ; Peg p nste ciffer
             LD     A,(HL)         ; Hent 2.ciffer
             CP     0
             JP     NZ,ANDET_OK    ; hvis 2. er nul skrives et space
             LD     A,20H          ; skriv space
             CALL   SKRIVA         ; Skriv tal
             JP     HENT_NR3

F0RSTE_OK:   ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Vndt p at display er klar til data

HENT_NR2:    INC    HL             ; Peg p nste ciffer
             LD     A,(HL)         ; Hent 2. ciffer
ANDET_OK:    ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv tal

HENT_NR3:    INC    HL             ; Peg p nste ciffer
             LD     A,(HL)         ; Hent 3. ciffer
             ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv tal
             INC    HL             ; Peg p nste ciffer
             LD     A,(HL)         ; Hent 4. ciffer
             ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv tal
             RET



;*********************************************************************
;        SUB-RUTINE..: VIS_DATA2                                     ;
;        Funktion....: Udlser bank data til display 2CIFRE          ;
;        Input.......: HL,Startdata                                  ;
;        Output......: ASCII Tal I LCD                               ;
;        delgger...: A, HL                                         ;
;        Kalder......: DISPLAYBUSY                                   ;
;        Initialer...: TST.   dato: 29/10-93                         ;
;*********************************************************************
VIS_DATA2:   LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(HL)         ; Hent 1.ciffer
             CP     0
             JP     NZ,F0RSTE2_OK  ; hvis 1. er nul skrives et space
             LD     A,20H          ; skriv space
             CALL   SKRIVA         ; Skriv tal
             JP     HENT2_NR2

F0RSTE2_OK:  ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv 1. tal

HENT2_NR2:   INC    HL             ; Peg p nste ciffer
             LD     A,(HL)         ; Hent 2. ciffer
             ADD    A,30H          ; konverter til ASCII
             CALL   SKRIVA         ; Skriv tal
             RET



;*********************************************************************
;        SUB-RUTINE..: IND_BANK                                      ;
;        Funktion....: Indlser bank data til alle system variabler  ;
;        Input.......: Det taster man selv                           ;
;        Output......: Alle strmme og tider mm.  A=00 hvis fejl.    ;
;        delgger...: A registeret.              A=FF hvis ok.      ;
;        Kalder......: CLS, LINE2, SKRIV, TASTEINPUT, KONV_2DECI     ;
;                      GOTOPOS, DISPLAYBUSY, HENTTAST                ;
;        Initialer...: TST.   dato: 27/10-93                         ;
;*********************************************************************
IND_BANK:    PUSH   DE
             PUSH   HL

IND_IGEN:    CALL   CLS
             LD     HL,TXT_BAT5A   ; 'INPUT BATTERI   '
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A            ; Cursorposition
             LD     D,2            ; Max. antal input cifre
             LD     HL,BAT_BATNR   ; Startadr. hvor Batterinr gemmes
             CALL   TASTEINPUT     ; Hent Batterinr.
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,INB_FORTRYD
             LD     HL,BAT_BATNR   ; Peg p tal der skal konverteres
             CALL   KONV_2DECI     ; konverter til HEX med 2 decimaler
             LD     HL,BANK_TEST   ; Peg p frste batteri bank
             ADD    A,H            ; adder indtastet nr til.
             LD     H,A
             LD     A,(HL)         ; Hent test data, fra indtastet bank nr
             CP     0
             JP     Z,INDB_FIKKE   ; Hvis a=0, hop til findes ikke.

 ; BANKEN FINDES

             LD     (BANK_ADR),HL  ; Gem adressen p banken
             CALL   CLS
             LD     HL,TXT_TJECK_INPUT ; NR:XX MED NAVN:
             CALL   SKRIV
             LD     A,03H
             LD     B,'1'
             CALL   GOTOPOS        ; Cursor til den rigtige position
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,(BAT_BATNR)  ; Hent tier
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     A,(BAT_BATNR+1) ; Hent enere
             ADD    A,30H          ; Konverter til ascii
             CALL   SKRIVA         ; skriv karakter
             LD     HL,(BANK_ADR)
             LD     L,1            ; Peg p navn tekst start.
             CALL   LINE2
             CALL   SKRIV          ; Udskriv batteri navn
IND_IGEN2:   CALL   HENTTAST
             CP     $FF
             JP     Z,IND_IGEN2
             CP     10
             JP     Z,IND_IGEN

 ; HENT KAPASITET FRA BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,12H          ; Peg p kapasitet plads
             LD     DE,BAT_KAP     ; HL Source, DE destination
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM variabel

 ; HENT AFLADE STRM FRA BANK (intastet)

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,16H          ; Peg p strm plads
             LD     DE,BAT_AF_mA   ; HL Source, DE destination
             LD     BC,4           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM variabel

 ; HENT OPLADE TIMER FRA BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1AH          ; Peg p timer plads
             LD     DE,BAT_OP_TIM  ; HL Source, DE destination
             LD     BC,2           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM variabel

 ; HENT ANTAL CELLER FRA BANK

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1CH          ; Peg p celler plads
             LD     DE,BAT_CELLER  ; HL Source, DE destination
             LD     BC,2           ; Antal bytes der skal kopieres
             LDIR                  ; Gem kapasitet i RAM variabel

 ; HENT OPLADE STRM FRA BANK TIL DAC

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1EH          ; Peg p strm til DAC
             LD     A,(HL)
             LD     (BAT_OP_DAC),A

 ; HENT AFLADE STRM FRA BANK TIL DAC

             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             LD     L,1FH          ; Peg p strm til DAC
             LD     A,(HL)
             LD     (BAT_AF_DAC),A
             LD     A,0FFH          ; Marker at data er hentet OK
             LD     (BANK_AKTIV),A ; Marker at der bruges Data-Bank
             JP     INDB_SLUT

INDB_FIKKE:  CALL   CLS
             LD     HL,TXT_BAT_FINDES_IKKE
             CALL   SKRIV
INDB_FIKKE2: CALL   HENTTAST
             CP     $FF
             JP     Z,INDB_FIKKE2
INB_FORTRYD: LD     A,0
             LD     (BANK_AKTIV),A ; Marker at der ikke bruges Data-Bank
             JP     INDB_SLUT      ; hentes data...

INDB_SLUT:   POP    HL
             POP    DE
             RET



;************************************************************************
;        SUB-RUTINE..: NAVN_EDIT                                        ;
;        Funktion....: Editere navnet p valgt Data-Bank.               ;
;        Input.......: RAM registre                                     ;
;        Output......: Navn i Bank                                      ;
;        delgger...: AF, BC, HL                                       ;
;        Kalder......: GOTOPOS, SKRIV, CURSOR_ON, HENTTAST, BLINK_OFF   ;
;        Initialer...: TST.   dato: 28/10-93                            ;
;************************************************************************
NAVN_EDIT:   PUSH   DE
             CALL   CLS
             LD     HL,TXT_EDITOR
             CALL   SKRIV
             CALL   CURSOR_ON      ; Cursor tndes og blinker ikke
             LD     A,0
             LD     (KARAKPOS),A   ; Peg p frste karakter
             LD     BC,(BANK_ADR)
             INC    BC             ; Peg p tekst
             LD     A,$FF
             LD     (TEMPGEM),A    ; Marker ndringer af tekst
             LD     A,0
             LD     (FORTRYDTAST),A

KARAKEDIT:   LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             INC    HL             ; Peg p start adresse af navn.
             CALL   LINE2
             CALL   SKRIV          ; udskriv hele linjen
             LD     A,(KARAKPOS)   ; Hent karakter position
             PUSH   BC             ; GEM POINTER
             LD     B,'2'          ; LINJE2
             CALL   GOTOPOS        ; GOTOPOS SKAL HAVE LINJEN I "B"
             POP    BC             ; HENT POINTER IGEN

KARAKEDIT2:  CALL   HENTTAST       ; henttast og keyklik bruges
             CP     $FF
             JP     Z,KARAKEDIT2
             CP     2              ; 2 tasten
             JP     Z,KARAKTEROP   ; Karakter op
             CP     8              ; 8 tasten
             JP     Z,KARAKTERNED  ; Karakter ned
             CP     4              ; 4 tasten
             JP     Z,KARAKTERVEN  ; Plads venstre
             CP     6              ; 6 tasten
             JP     Z,KARAKTERH0J  ; Plads hjer
             CP     10             ; Fortryd-tasten
             JP     Z,KARSLETALT   ; Hvis * Slet alle karaktere
             CP     12
             JP     Z,KARAK_SLUT   ; Hvis #, hop til afslut
             JP     KARAKEDIT2

KARAKTEROP:  LD     A,$FF
             LD     (TEMPGEM),A    ; Marker ndringer af tekst
             LD     A,0
             LD     (FORTRYDTAST),A
             LD     A,(BC)         ; hent karakter
             INC    A
             CP     $5B            ; s skal der komme et ''
             JP     Z,KARAK_AE
             CP     $03            ; s skal der komme et 'SPACE'
             JP     Z,KARAK_SP
             CP     $27            ; s skal der komme et '0'
             JP     Z,KARAK_NUL
             CP     $3A            ; s skal der komme et 'A'
             JP     Z,KARAK_A
             LD     (BC),A
             JP     KARAKEDIT      ; forset edit

KARAKTERNED: LD     A,0FFH
             LD     (TEMPGEM),A    ; Marker ndringer af tekst
             LD     A,00H
             LD     (FORTRYDTAST),A
             LD     A,(BC)         ; hent karakter
             DEC    A
             CP     $FF            ; s skal der komme et 'Z'
             JP     Z,KARAK_Z
             CP     2FH            ; s skal der komme et '&'
             JP     Z,KARAK_OG
             CP     1FH            ; s skal der komme et ''
             JP     Z,KARAK_AA
             CP     40H            ; s skal der komme et '9'
             JP     Z,KARAK_9
             LD     (BC),A
             JP     KARAKEDIT      ; forset edit

KARAK_AE:    LD     A,0
             LD     (BC),A         ; Skriv ''
             JP     KARAKEDIT      ; forset edit
KARAK_SP:    LD     A,' '
             LD     (BC),A         ; Skriv 'space'
             JP     KARAKEDIT      ; forset edit
KARAK_NUL:   LD     A,'0'
             LD     (BC),A         ; Skriv '0'
             JP     KARAKEDIT      ; forset edit
KARAK_A:     LD     A,'A'
             LD     (BC),A         ; Skriv 'A'
             JP     KARAKEDIT      ; forset edit
KARAK_Z:     LD     A,'Z'
             LD     (BC),A         ; Skriv 'Z'
             JP     KARAKEDIT      ; forset edit
KARAK_OG:    LD     A,'&'          ; $26
             LD     (BC),A         ; Skriv '&'
             JP     KARAKEDIT      ; forset edit
KARAK_AA:    LD     A,2
             LD     (BC),A         ; Skriv ''
             JP     KARAKEDIT      ; forset edit
KARAK_9:     LD     A,'9'
             LD     (BC),A         ; Skriv '9'
             JP     KARAKEDIT      ; forset edit

KARAKTERVEN: LD     A,$FF
             LD     (TEMPGEM),A    ; Marker ndringer af tekst
             LD     A,0
             LD     (FORTRYDTAST),A
             LD     A,(KARAKPOS)   ; Hent karakter position
             CP     0              ; test om plads er helt til venstre
             JP     Z,KARAKMIN
             DEC    A              ; flyt 1 plads til venstre
             LD     (KARAKPOS),A   ; Gem karakter position
             AND    00001111B      ; fratrk linje2 ofset
             LD     BC,(BANK_ADR)
             INC    BC             ; peg p tekst
             ADD    A,C
             LD     C,A
             JP     KARAKEDIT      ; forset edit

KARAKTERH0J: LD     A,$FF
             LD     (TEMPGEM),A    ; Marker ndringer af tekst
             LD     A,0
             LD     (FORTRYDTAST),A
             LD     A,(KARAKPOS)   ; Hent karakter position
             CP     15             ; test om plads er helt til hjere
             JP     Z,KARAKMAX
             INC    A              ; flyt 1 plads til hjer
             LD     (KARAKPOS),A   ; Gem karakter position
             AND    00001111B      ; fratrk linje2 ofset
             LD     BC,(BANK_ADR)
             INC    BC
             ADD    A,C
             LD     C,A
             JP     KARAKEDIT      ; forset edit

KARAKMIN:    LD     A,0
             LD     (KARAKPOS),A   ; peg p frsta synlige position
             JP     KARAKEDIT      ; forset edit

KARAKMAX:    LD     A,15
             LD     (KARAKPOS),A   ; peg p sidste synlige position
             JP     KARAKEDIT      ; forset edit

KARSLETALT:  LD     A,(TEMPGEM)
             CP     0
             JP     Z,KARKFORTRYD
             LD     HL,(BANK_ADR)  ; Hent aktiv bank start adresse
             INC    L              ; Peg p tekst start
             LD     B,16           ; Stop ofset
KARSLETLOOP: LD     (HL),' '       ; Slet tekst
             INC    L              ; nste karakter
             DJNZ   KARSLETLOOP

KARSLETSLUT: LD     A,0
             LD     (KARAKPOS),A   ; flyt cursor til frste plads
             LD     BC,(BANK_ADR)
             INC    BC             ; Peg p tekst
             LD     A,0
             LD     (TEMPGEM),A    ; Marker at alt er slettet
             JP     KARAKEDIT      ; her starter edit igen

KARKFORTRYD: LD     A,$FF
             LD     (FORTRYDTAST),A
KARAK_SLUT:  CALL   BLINK_OFF      ; Sluk cursor
             POP    DE
             RET



;************************************************************************
;        SUB-RUTINE..: INPUT_KAP                                        ;
;        Funktion....: Indtastning af batteri kapasitet, og test limit  ;
;        Input.......: Indtastning                                      ;
;        Output......: RAM registre                                     ;
;        delgger...: IX,IY                                            ;
;        Kalder......: CLS, SKRIV, LINE2, TASTEINPUT, INPUT_TEST        ;
;        Initialer...: TST.   dato: 28/10-93                            ;
;************************************************************************
INPUT_KAP:   PUSH   HL
             PUSH   AF
             PUSH   DE
             PUSH   BC

INDKAPIGEN:  CALL   CLS
             LD     HL,TXT_BAT3A   ; 'INPUT KAPACITET '
             CALL   SKRIV          ;  mA>
             CALL   FINDPOS2
             LD     E,A            ; pos
             LD     D,4            ; cifre
             LD     HL,BAT_KAP     ; hvor data lagres
             CALL   TASTEINPUT     ; INDLS
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,INP_KAP_SL

 ; TEST OM INPUT ER 50-9999mAT

             LD     IX,MAX_KAP     ; Maximum kapacitet
             LD     IY,MIN_KAP     ; minimum kapacitet
             LD     HL,BAT_KAP     ; Indtastet kap
             LD     B,4            ; Max. antal input
             LD     C,0            ; Fejlnr.
             CALL   INPUT_TEST     ; Er input tilladeligt?
             INC    C
             DEC    C              ; Er fejl <> 0?
             JP     NZ,INDKAPIGEN  ; Hvis fejl, s input afladestrm. igen

INP_KAP_SL:  POP    BC
             POP    DE
             POP    AF
             POP    HL
             RET



;************************************************************************
;        SUB-RUTINE..: INPUT_OPTID                                      ;
;        Funktion....: Indtastning af opladetid, og test limit          ;
;        Input.......: Indtastning                                      ;
;        Output......: RAM registre                                     ;
;        delgger...: IX,IY                                            ;
;        Kalder......: CLS, SKRIV, LINE2, TASTEINPUT, INPUT_TEST        ;
;        Initialer...: TST.   dato: 28/10-93                            ;
;************************************************************************
INPUT_OPTID: PUSH   HL
             PUSH   AF
             PUSH   DE
             PUSH   BC

OPTID_IGEN:  CALL   CLS
             LD     HL,TXT_OP1A    ; 'INPUT OPLADE TID'
             CALL   SKRIV
             CALL   FINDPOS2
             LD     E,A
             LD     D,2            ;
             LD     HL,BAT_OP_TIM  ;
             CALL   TASTEINPUT     ;
             LD     A,(FORTRYDTAST)
             CP     0FFH
             JP     Z,OPTID_SLUT

 ; TEST OM INPUT ER 1-24 TIMER

             LD     IX,MAX_OP_TIM
             LD     IY,MIN_OP_TIM
             LD     HL,BAT_OP_TIM
             LD     B,2
             LD     C,1
             CALL   INPUT_TEST
             DEC    C
             BIT    7,C
             JP     Z,OPTID_IGEN

OPTID_SLUT:  POP    BC
             POP    DE
             POP    AF
             POP    HL
             RET



;************************************************************************
;        SUB-RUTINE..: OPTIMETEST                                       ;
;        Funktion....: Tester om der kan oplades p den givne tid,      ;
;                      og beregner oplade strm til DAC..               ;
;                      Hvis det ikke kan lade sig gre skrives der fejl.;
;        Input.......: RAM variabler, opladestrm, opladetimer          ;
;        Output......: RAM var, BAT_OP_DAC       A=FF hvis okk          ;
;        delgger...: AF,HL,BC,DE               A=00 hvis fejl         ;
;        Kalder......: KONV_2DECI, KONV_4DECI, HEX_DIV5                 ;
;        Initialer...: TST.   dato: 28/10-93                            ;
;************************************************************************
OPTIMETEST:  LD     HL,BAT_OP_TIM  ; Input oplade timer
             CALL   KONV_2DECI     ; konverter til HEX med 2 decimaler
             LD     B,0
             LD     C,A
             LD     IX,BAT_KAP     ; Input batteri kapasitet
             CALL   KONV_4DECI     ; konverter til HEX med 4 decimaler
                                   ; BC = TIMER I HEX
                                   ; HL = KAPASITET I HEX
             LD     DE,0
OPTDIVLOOP:  INC    DE             ; Division resultat
             SCF                   ; Set carry flag
             CCF                   ; Inverter carry flag
             SBC    HL,BC          ; HL=kapasitet-Timer
             JP     Z,OPTDIV_OK
             JP     NC,OPTDIVLOOP
OPTDIV_OK:   LD     H,D            ; LD  HL,DE
             LD     L,E            ; Hent resultat til HL
             LD     BC,20
             SCF                   ; Set carry flag
             CCF                   ; Inverter carry flag
             SBC    HL,BC          ; Trk 20 fra
             JP     C,OPTFEJL1     ; FEJL=Formange timer og forlidt strm
             LD     H,D            ; LD  HL,DE
             LD     L,E            ; Hent resultat til HL
             LD     BC,910
             SCF                   ; Set carry flag
             CCF                   ; Inverter carry flag
             SBC    HL,BC          ; Trk 910 fra
             JP     NC,OPTFEJL2    ; FEJL=Forlidt timer og formeget strm
             LD     H,D            ; LD  HL,DE
             LD     L,E            ; GEM resultat i HL
             SRL    E              ; Div med 2 i 8 LSB
             SRL    D              ; Div med 2 i 8 MSB
             JP     NC,OPTDIV2OK
             SET    7,E            ; Hvis der er carry s set bit 7 i LSB

OPTDIV2OK:   ADD    HL,DE          ; Nu er der ganget med 1.5
             SRL    E              ; Div med 4 i 8 LSB
             SRL    D              ; Div med 4 i 8 MSB
             JP     NC,OPTDIV8OK1
             SET    7,E            ; Hvis der er carry s set bit 7 i LSB

OPTDIV8OK1:  SRL    E              ; Div med 8 i 8 LSB
             SRL    D              ; Div med 8 i 8 MSB
             JP     NC,OPTDIV8OK2
             SET    7,E            ; Hvis der er carry s set bit 7 i LSB

OPTDIV8OK2:  SCF                   ; Set carry flag
             CCF                   ; Inverter carry flag
             SBC    HL,DE          ; Trk 1/8 fra det 1.5 gange mellem resultat
             CALL   HEX_DIV5       ; Resultat skal passe til strm gen.
             LD     (BAT_OP_DAC),A ; Gem strm i RAM variabel
             LD     A,0FFH
             JP     OPTSLUT

OPTFEJL1:    CALL   LINE1
             LD     HL,TXT_FEJL7A  ; 'KAN IKKE OPLADE!'
             CALL   SKRIV
             CALL   LINE2
             LD     HL,TXT_FEJL7C  ; 'FOR MEGET TID.. '
             CALL   SKRIV
OPTFEJL12:   CALL   HENTTAST
             CP     $FF
             JP     Z,OPTFEJL12
             LD     A,0
             JP     OPTSLUT

OPTFEJL2:    CALL   LINE1
             LD     HL,TXT_FEJL7A  ; 'KAN IKKE OPLADE!'
             CALL   SKRIV
             CALL   LINE2
             LD     HL,TXT_FEJL7B  ; 'FOR LIDT TID... '
             CALL   SKRIV
OPTFEJL22:   CALL   HENTTAST
             CP     $FF
             JP     Z,OPTFEJL22
             LD     A,0

OPTSLUT:     RET



;************************************************************************
;        SUB-RUTINE..: OPLADE_UR                                        ;
;        Funktion....: Skriver opladnings tiden p den rigtige position.;
;        Input.......: RAM registre                                     ;
;        Output......: tekst i display                                  ;
;        delgger...: AF                                               ;
;        Kalder......: GOTOPOS, DISPLAYBUSY                             ;
;        Initialer...: TST.   dato: 28/10-93                            ;
;************************************************************************
OPLADE_UR:   LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     A,$08
             LD     B,'2'
             CALL   GOTOPOS        ; Peg p frste tal i uret
             LD     A,(OP_TIM_TI)  ; Hent Nedtller time tiere
             ADD    A,$30          ; konverter til ASCII
             CALL   SKRIVA

             LD     A,(OP_TIM_EN)  ; Hent Nedtller time enere
             ADD    A,30H          ; konverter til ASCII

             CALL   SKRIVA

             LD     A,':'

             CALL   SKRIVA

             LD     A,(OP_MIN_TI)  ; Hent Nedtller minutter enere
             ADD    A,30H          ; konverter til ASCII

             CALL   SKRIVA

             LD     A,(OP_MIN_EN)  ; Hent Nedtller minutter enere
             ADD    A,30H          ; konverter til ASCII

             CALL   SKRIVA

             LD     A,':'

             CALL   SKRIVA

             LD     A,(OP_SEK_TI)  ; Hent Nedtller sekunder enere
             ADD    A,30H          ; konverter til ASCII

             CALL   SKRIVA

             LD     A,(OP_SEK_EN)  ; Hent Nedtller sekunder enere
             ADD    A,30H          ; konverter til ASCII

             CALL   SKRIVA

             RET








;******************************************************************
;        SUB-RUTINE..: STROM_ON                                   ;
;        Funktion....: 'Enabler' strmgeneratoren                 ;
;        Input.......: Intet                                      ;
;        Output......: Strmgen. kan oplade/aflade                ;
;        delgger...: Ingen registre                             ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 24/10-93                      ;
;******************************************************************
STROM_ON:    PUSH   AF
             LD     A,(OUTREG)
             SET    0,A
             OUT    (UART4),A
             LD     (OUTREG),A
             POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: STROM_OFF                                  ;
;        Funktion....: 'Disabler' strmgeneratoren                ;
;        Input.......: Intet                                      ;
;        Output......: Strmgen. kan ikke oplade/aflade           ;
;        delgger...: Ingen registre                             ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.   dato: 24/10-93                      ;
;******************************************************************
STROM_OFF:   PUSH   AF
             LD     A,(OUTREG)
             RES    0,A
             OUT    (UART4),A
             LD     (OUTREG),A
             POP    AF
             RET



;************************************************************************
;        SUB-RUTINE..: OPLAD_ON                                         ;
;        Funktion....: Forbinder Strmgeneratoren s batt. kan oplades  ;
;        Input.......: Intet                                            ;
;        Output......: Strmgen. kan oplade                             ;
;        delgger...: Ingen registre                                   ;
;        Kalder......: Ingen                                            ;
;        Initialer...: TST.   dato: 25/10-93                            ;
;************************************************************************
OPLAD_ON:    PUSH   AF
             LD     A,(OUTREG)
             RES    1,A           ; Bit 1 = 0
             OUT    (UART4),A     ; rel trkkes
             LD     (OUTREG),A
             POP    AF
             RET



;************************************************************************
;        SUB-RUTINE..: AFLAD_ON                                         ;
;        Funktion....: Forbinder strmgeneratoren s batt. kan aflades  ;
;        Input.......: Intet                                            ;
;        Output......: Strmgen. kan aflade                             ;
;        delgger...: Ingen registre                                   ;
;        Kalder......: Ingen                                            ;
;        Initialer...: TST.   dato: 25/10-93                            ;
;************************************************************************
AFLAD_ON:    PUSH   AF
             LD     A,(OUTREG)
             SET    1,A           ; Bit 1 = 1
             OUT    (UART4),A     ; rel slippes
             LD     (OUTREG),A
             POP    AF
             RET


;*******************************************************************
;        SUB-RUTINE..: HENTTAST                                    ;
;        Funktion....: henter en tast der bliver trykket og gemmer ;
;                      tastenr. i A-reg.                           ;
;        Input.......: Keyboard                                    ;
;        Output......: Tastenr. i A-reg. 20=DER SKAL SKRIVES ALT   ;
;        delgger...: Intet             FORDI DER VAR FEJL.       ;
;        Kalder......: TASTEKLIK                                   ;
;        Initialer...: KEA.   dato: 19/10-93                       ;
;*******************************************************************
HENTTAST:    CALL   CHECK_PT
             CP     20
             JP     Z,HENT_FEJL

             LD     A,(KEYNR)      ; Hent keynr.
             BIT    6,A            ; Test om der er trykket p en ny tast
             JP     Z,HENT_SLUT2   ; Hop hvis der er trykket p en tast
             LD     A,$FF          ; Ingen tast trykket: a=$FF
             RET
HENT_SLUT2:  CALL   TASTEKLIK      ; Klik nr der er trykket p en tast
             SET    6,A            ; markr at der er trykket p en tast
             LD     (KEYNR),A      ; Gem i Keynr
             RES    6,A            ; Markr at ny data er hentet
HENT_FEJL:   RET




;******************************************************************
;        SUB-RUTINE..: CHECK_POL OG TEMP                          ;
;        Funktion....: Teste om TEMPERATUR ER FOR HJ             ;
;                      HVIS FORHJ, S PAUSE STRM OG TIDEN       ;
;        delgger...: A                                          ;
;        Kalder......: SKRIV, PAUSE                               ;
;        Initialer...: TST.   dato: 28/1-96                       ;
;******************************************************************
CHECK_PT:    PUSH   BC
             LD     A,(FEJLTEMP)
             CP     1
             JP     Z,CHK_TFEJL    ; TEMP FOR HJ

             LD     A,0            ; MERKER AT DER VAR IKKE TEMP FEJL..
             JP     CHECKT_OK

CHK_TFEJL:   LD     A,1
             LD     (STOP_TID),A   ; STOP OP-AF TLLERE
             CALL   STROM_OFF
             CALL   AFLAD_ON       ; Slipper rel VARIABLER SETTES
             CALL   CLS
             LD     HL,TXT_TEMP
             CALL   SKRIV
             LD     A,(TEMP_1GANG)
             CP     $FF            ; FOR AT SE OM DER HAR VRET PAUSE FR.
             JP     Z,CHK_1GANG
             JP     CHKT_IGEN      ; GIV 10 SEK MERE.

CHK_1GANG:   LD     A,1            ; FRSTE GANG DER ER TEMPERATUR FEJL
             LD     (TEMP_DEL1),A  ; 10 SEKUNDER PAUSE
             LD     (TEMP_DEL10),A ;
             LD     (TEMP_1GANG),A ; S ER DET IKKE FRSTE GANG MERE

CHK_NYTDEL:  LD     A,(TEMP_DEL1)  ; HENT ENERE SEKUNDER
             LD     B,A
             LD     A,(TEMP_DEL10) ; HENT TIERE SEKUNDER
             LD     C,A
             CALL   CHKPAUSE       ; PAUSE TID, TIL AFKLING.
CHK_TLOOP:   LD     A,(FEJLTEMP)
             CP     1              ; 1=FEJL
             JP     Z,CHKT_IGEN    ; CHECK TEMP FEJL IGEN..
CHECK_SLUT:  LD     A,0
             LD     (STOP_TID),A   ; START IGEN. OP-AF TLLERE
             LD     A,20           ; MARKER DER HAR VRET FEJL
CHECKT_OK:   POP    BC
             RET


CHKT_IGEN:   LD     A,(TEMP_DEL10) ; HENT TIER
             INC    A              ; Ekstra 10 sekunder
             CP     10
             JP     Z,CHK_90SEK    ; HVIS TIER ER 10, GEMMES DER IKKE
             LD     (TEMP_DEL10),A ; GEM NY TIER
             JP     CHK_NYTDEL
CHK_90SEK:   LD     A,10
             LD     (TEMP_DEL1),A  ; DETTE GIVER MAX P 99 SEK..
             JP     CHK_NYTDEL

CHKPAUSE:    LD     A,(INTTAL)     ; INTERRUPT TLLER VARIABEL.
             CP     2              ; SEKUND TESTER
             JP     NZ,CHKPAUSE

CHK_TEST2:   LD     A,(INTTAL)     ; INTERRUPT TLLER VARIABEL.
             CP     3              ; SEKUND TESTER
             JP     NZ,CHK_TEST2   ; DER SKAL VRE 2 TEST, FORDI ROUTINEN ER,
                                   ; FRDIG INDEN DER HAR VRET INTERRUPT..
CHKP_1SEK:   DEC    B

             PUSH   BC
             LD     A,38
             LD     B,'2'
             CALL   GOTOPOS        ; DER HVOR RESTTIDEN SKAL SKRIVES.
             POP    BC

             LD     A,C            ; HENT TIER
             ADD    A,$30          ; KONV. TIL ACSII
             CALL   SKRIVA
             LD     A,B            ; HENT ENER
             ADD    A,$30          ; KONV. TIL ACSII
             CALL   SKRIVA
             INC    B
             DEC    B
             JP     Z,CHKP_ZB      ; VED NEGATIV OVERFLOW HOP.
             JP     CHKPAUSE

CHKP_ZB:     LD     B,10
             DEC    C
             JP     M,CHKP_SLUT    ; NEGATIV = AFSLUT
             JP     CHKPAUSE
CHKP_SLUT:   RET

;******************************************************************
;        SUB-RUTINE..: RAM_TEST                                   ;
;        Funktion....: Teste om RAM er ok, ellers default.        ;
;        delgger...: A,B,HL                                     ;
;        Kalder......: SKRIV, PAUSE                               ;
;        Initialer...: TST.   dato: 21/11-94                      ;
;******************************************************************
RAM_TEST:
             CALL   CLS
             LD     HL,TXT_TESTER
             CALL   SKRIV          ; 'TESTER RAMMEN...'


             LD     B,0            ;  Indholds test
             LD     HL,RAMSTART
RAM_TST_LP:  LD     A,(HL)
             CP     B
             JP     NZ,RAM_BAD     ; fejl i indholdet
             INC    HL
             INC    B
             JP     NZ,RAM_TST_LP

                                   ; Hardware fejl test
             LD     HL,RAMSTART
RAM_LP2:     LD     A,55H
             LD     B,(HL)         ; Hent original byte
             LD     (HL),A         ; Skriv 55H i rammen
             LD     A,(HL)
             CP     55H            ; Test om 55H er ok??
             JP     NZ,RAM_DEF
             LD     (HL),B         ; Skriv original byte
             LD     A,(HL)
             CP     B              ; test om original byte kan skrives/lses igen
             JP     NZ,RAM_DEF
             INC    HL
             LD     A,0
             CP     H
             JP     Z,RAM_EROK
             JP     RAM_LP2

 ; Nu skal hele RAM'en slettes, fordi der er fejl i indholdet..

RAM_BAD:
             LD     HL,RAMSTART
             LD     A,0            ; Tallet som skal sammenlignes med H
             LD     B,0            ; Data der skal lgges i rammen
RAM_SLET:    LD     (HL),B         ; Her bliver rammen fyldt op med 0'er
             INC    HL             ; Peg p nste adresse
             CP     H              ; Er HL net til adresse 0000H?
             JP     NZ,RAM_SLET    ; Hvis ikke, forst.
             JP     DEFAULT        ; Ellers sttes default og reset system

RAM_EROK:    CALL   LINE2
             LD     HL,TXT_OK      ; Peg p 'RAM TEST OK'
             CALL   SKRIV          ; Skriv tekst i LCD-display
             LD     BC,5000
             CALL   PAUSE
             RET

RAM_DEF:     CALL   CLS
             LD     HL,TXT_DEF     ; Peg p 'RAM DEFEKT'
             CALL   SKRIV          ; Skriv tekst i LCD-display
             DI
             HALT






ER_DER_RAM:  LD     HL,RAMSTART
             LD     A,55H
             LD     B,(HL)         ; Hent original byte
             LD     (HL),A         ; Skriv 55H i rammen
             LD     A,(HL)
             CP     55H            ; Test om 55H er ok??
             JP     NZ,RAM_NOPE
             LD     (HL),B         ; Skriv original byte
             LD     A,(HL)
             CP     B              ; test om original byte kan skrives/lses igen
             JP     NZ,RAM_NOPE
             JP     DER_ER_RAM
RAM_NOPE:    LD     D,128          ; Antal perioder p lyden.

RAM_NLOOP:   LD     A,255          ; Stter hjttaler hj.
             OUT    (DACLYD),A
             LD     B,40           ; Tid hj.
RAMNOPELP1:  NOP
             DJNZ   RAMNOPELP1
             LD     A,0            ; Stter hjttaler lav.
             OUT    (DACLYD),A
             LD     B,40           ; Tid lav.
RAMNOPELP2:  NOP
             DJNZ   RAMNOPELP2

             DEC    D
             JP     NZ,RAM_NLOOP   ; Test er antal perioder frdig


             LD     A,255
RAMNOPAU2:   LD     B,255
RAMNOPAU1:   NOP
             NOP
             NOP
             NOP
             DJNZ   RAMNOPAU1
             DEC    A
             JP     NZ,RAMNOPAU2
             JP     RAM_NOPE       ; FORFRA IGEN



;********************************************************************
;        SUB-RUTINE..: RAM_ALARM (kaldes kun fra default)           ;
;        Funktion....: Bipper i hjttaleren til der trykkes en tast ;
;        Input.......: Tastetryk                                    ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: A,B,C,D                                      ;
;        Kalder......: PAUSE, KEYB_SCAN                             ;
;        Initialer...: KEA.TST.     dato: 20/9-93                   ;
;********************************************************************
RAM_ALARM:   LD     D,128          ; Antal perioder p lyden.

RAM_ALOOP:   LD     A,255          ; Stter hjttaler hj.
             OUT    (DACLYD),A
             LD     BC,1           ; Tid hj.
             CALL   PAUSE
             LD     A,0            ; Stter hjttaler lav.
             OUT    (DACLYD),A
             LD     BC,1           ; Tid lav.
             CALL   PAUSE
             DEC    D
             JP     NZ,RAM_ALOOP   ; Test er antal perioder frdig
             LD     BC,512         ; Pause der svarer til lyd tiden
             CALL   PAUSE          ; (tid hj + tid lav) ; antal gennemlb
                                   ; Eks: (2 + 2) ; 128 = 512
             CALL   KEYB_SCAN      ; Opdater keyboard
             LD     A,(KEYNR)
             BIT    7,A            ; Test om en tast er trykket-
             JP     NZ,RAM_ALARM   ; hvis ikke, bip videre.
             RET



;******************************************************************
;        SUB-RUTINE..: DEFAULT                                    ;
;        Funktion....: Stter alle RAM register vrdier til -     ;
;                      default, skal kun kres efter RAM fejl.    ;
;        Input.......: Intet                                      ;
;        Output......: Data til RAM variabler                     ;
;        delgger...: A, HL                                      ;
;        Kalder......: SKRIV, PAUSE, CLS, RAM_ALARM               ;
;        Initialer...: TST.      dato: 21/11-94                   ;
;******************************************************************
DEFAULT:     LD     A,0            ; Vrdi der skal ligge p frste plads-
             LD     HL,RAMSTART
DEFAULT_LP:  LD     (HL),A         ; Her fyldes de frste 256 bytes med data
             INC    HL             ; fra 0 - 255
             INC    A
             JP     NZ,DEFAULT_LP

             CALL   LYDALARM

             LD     A,1
             LD     (KEYBPREF),A   ; 2 Perioder keyklik som default
             LD     A,0
             LD     (SER_ON),A     ; SERIAL PORT OFF
             LD     A,5
             LD     (SER_BAUD),A   ; 19200 BAUD 8N1
             LD     A,0
             LD     (SLUTPREF),A   ; Ingen lyd nr> op,af,kondi er stopet (frdig)
             LD     A,0
             LD     (KOD_RETRY),A
             LD     A,0
             LD     (LAD_STAT),A   ; Lader laver ingenting ved power-up
             LD     A,1            ; 10 Dage til kode som default
             LD     (KODE_DAG10),A ; Gem indtastet dage tiere
             LD     A,0
             LD     (KODE_DAG1),a  ; Gem indtastet dage enere
             CALL   CLS            ; Clear display og cursor home
             LD     HL,TXT_DEF1    ; Peg p 'RAM BACK-UP FEJL'
             CALL   SKRIV          ; Skriv tekst i LCD-display

             CALL   RAM_ALARM      ; Bipper i hjttaler og venter p knap
             JP     0              ; Software reset



;********************************************************************
;        SUB-RUTINE..: LYDFADER                                     ;
;        Funktion....: Bipper i hjttaleren med variabelt volume    ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: PAUSE                                        ;
;        Initialer...: TST.     dato: 21/7-95                       ;
;********************************************************************
LYDFADER:    ;DI
             PUSH   AF
             PUSH   BC
             PUSH   DE
             PUSH   HL

             LD     HL,FADERDATA

LYDFADLP:    LD     C,30           ; ANTAL PERIODER PR. VOLUME
             LD     A,STOP
             LD     D,(HL)
             CP     D
             JP     Z,LYDFADSLUT
             INC    HL
             LD     E,(HL)
             INC    HL

LYDFAD0:     LD     A,D
             OUT    (DACLYD),A     ; PULS

             LD     B,120
LYDFAD1:     NOP
             DJNZ   LYDFAD1

             LD     A,E
             OUT    (DACLYD),A     ; PAUSE

             LD     B,120
LYDFAD2:     NOP
             DJNZ   LYDFAD2

             DEC    C
             JP     NZ,LYDFAD0

             JP     LYDFADLP

FADERDATA:   .byte     7Fh,7fH, 0b0H,4eH, 0d9h,25H, 0f4h,0AH, 0feh,00H, 0f4h,0AH
             .byte     0e0h,20H, 0d0h,30H, 0c0H,40H, 0b0H,50H, 0a7h,57H, 0a0H,60H
             .byte     97h,67H, 90h,70H, 8Bh,73H, 87h,77H, 85h,79H, 83h,7BH
             .byte     82h,7CH, 81h,7DH, 80h,7EH, 7Fh,7FH, 0FFH

LYDFADSLUT:  POP    HL
             POP    DE
             POP    BC
             POP    AF
            ; EI
             RET


;********************************************************************
;        SUB-RUTINE..: LYDFADER2                                    ;
;        Funktion....: Bipper i hjttaleren med variabelt volume    ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: PAUSE                                        ;
;        Initialer...: TST.     dato: 21/7-95                       ;
;********************************************************************
LYDFADER2:   DI
             PUSH   AF
             PUSH   BC
             PUSH   DE
             PUSH   HL

             LD     HL,FADERDATA

LYD2FADLP:   LD     C,30           ; ANTAL PERIODER PR. VOLUME
             LD     A,STOP
             LD     D,(HL)
             CP     D
             JP     Z,LYD2FADSLUT
             INC    HL
             LD     E,(HL)
             INC    HL

LYD2FAD0:    LD     A,D
             OUT    (DACLYD),A     ; PULS

             LD     B,40
LYD2FAD1:    NOP
             DJNZ   LYD2FAD1

             LD     A,E
             OUT    (DACLYD),A     ; PAUSE

             LD     B,40
LYD2FAD2:    NOP
             DJNZ   LYD2FAD2

             DEC    C
             JP     NZ,LYD2FAD0

             JP     LYD2FADLP


LYD2FADSLUT: POP    HL
             POP    DE
             POP    BC
             POP    AF
             EI
             RET


;********************************************************************
;        SUB-RUTINE..: LYDALARM                                     ;
;        Funktion....: Bipper i hjttaleren 3 gange                 ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: PAUSE                                        ;
;        Initialer...: TST.     dato: 23/10-93                      ;
;********************************************************************
LYDALARM:    PUSH   AF
             PUSH   BC
             PUSH   DE
             PUSH   HL
             LD     E,4            ; Antal bip+1

LYDALP3:     LD     B,120          ; ANTAL PERIODER
LYDALP:      LD     C,64           ; TABEL STRELSE
             LD     HL,SINE64
LYDAL:       LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    C              ; TABEL TLLER
             JP     NZ,LYDAL
             DEC    B              ; PERIODE TLLER
             JP     NZ,LYDALP
             LD     A,7FH
             OUT    (DACLYD),A
             LD     BC,300
             CALL   PAUSE          ; Pause svarende til bip tiden
             DEC    E              ; Er de 3 gennem ld frdige?
             JP     NZ,LYDALP3     ; hvis ikke, bip igen .

             POP    HL
             POP    DE
             POP    BC
             POP    AF
             RET


;********************************************************************
;        SUB-RUTINE..: LYDALARM1                                    ;
;        Funktion....: Bipper i hjttaleren 1 gang                  ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: Intet                                        ;
;        Initialer...: TST.     dato: 21/7-95                       ;
;********************************************************************
LYDALARM1:   DI
             PUSH   AF
             PUSH   DE

             LD     E,200          ; ANTAL PERIODER

LYDAL0:      LD     D,128          ; TABEL STRELSE
             LD     HL,SINE128
LYDAL1:      LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    D              ; TABEL TLLER
             JP     NZ,LYDAL1
             DEC    E              ; PERIODE TLLER
             JP     NZ,LYDAL0
             LD     A,7FH
             OUT    (DACLYD),A

             POP    DE
             POP    AF
             EI
             RET


;********************************************************************
;        SUB-RUTINE..: LYDTING                                      ;
;        Funktion....: Bipper i hjttaleren                         ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: Intet                                        ;
;        Initialer...: TST.     dato: 27/12-95                      ;
;********************************************************************
LYDTING:     DI
             PUSH   AF
             PUSH   DE
             PUSH   BC
             LD     B,4

LYDTINGLP:
             LD     E,50           ; ANTAL PERIODER
LYDTING0:    LD     D,128          ; TABEL STRELSE
             LD     HL,SINE128
LYDTING1:    LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    D              ; TABEL TLLER
             JP     NZ,LYDTING1
             DEC    E              ; PERIODE TLLER
             JP     NZ,LYDTING0
             LD     E,100          ; ANTAL PERIODER
LYDTING2:    LD     D,64           ; TABEL STRELSE
             LD     HL,SINE64
LYDTING3:    LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    D              ; TABEL TLLER
             JP     NZ,LYDTING3
             DEC    E              ; PERIODE TLLER
             JP     NZ,LYDTING2
             DJNZ   LYDTINGLP

             LD     A,7FH
             OUT    (DACLYD),A
             POP    BC
             POP    DE
             POP    AF
             EI
             RET


;********************************************************************
;        SUB-RUTINE..: LYDFLIP                                      ;
;        Funktion....: Bipper i hjttaleren                         ;
;        Input.......: intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: Intet                                        ;
;        Initialer...: TST.     dato: 27/12-95                      ;
;********************************************************************
LYDFLIP:     DI
             PUSH   AF
             PUSH   DE
             PUSH   BC
             LD     B,20
             LD     C,40
LYDFLIPLP:
             LD     E,B            ; ANTAL PERIODER
LYDFLIP0:    LD     D,128          ; TABEL STRELSE
             LD     HL,SINE128
LYDFLIP1:    LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    D              ; TABEL TLLER
             JP     NZ,LYDFLIP1
             DEC    E              ; PERIODE TLLER
             JP     NZ,LYDFLIP0
             LD     E,C            ; ANTAL PERIODER
LYDFLIP2:    LD     D,64           ; TABEL STRELSE
             LD     HL,SINE64
LYDFLIP3:    LD     A,(HL)
             OUT    (DACLYD),A
             INC    HL
             DEC    D              ; TABEL TLLER
             JP     NZ,LYDFLIP3
             DEC    E              ; PERIODE TLLER
             JP     NZ,LYDFLIP2
             DEC    C
             DEC    C
             DJNZ   LYDFLIPLP

             LD     A,7FH
             OUT    (DACLYD),A
             POP    BC
             POP    DE
             POP    AF
             EI
             RET



;********************************************************************
;        SUB-RUTINE..: LYDSKALA                                     ;
;        Funktion....: Laver en skala op-ned lyd                    ;
;        Input.......: Intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: PAUSE                                        ;
;        Initialer...: TST.     dato: 23/10-93                      ;
;********************************************************************
LYDSKAL:     DI                    ; Ingen taste afbrydelser TAK.
             PUSH   AF
             PUSH   BC
             PUSH   DE

             LD     E,20           ; Antal lyde i skala op
             LD     BC,1           ; Start pause
LYDSIGEN1:   LD     D,10           ; Antal perioder p hver lyd.
LYDSLOOP1:   LD     A,0FFH         ; Stter hjttaler hj.
             OUT    (DACLYD),A
             PUSH   BC
             CALL   PAUSE          ; Tid hj.
             POP    BC
             LD     A,0            ; Stter hjttaler lav.
             OUT    (DACLYD),A
             PUSH   BC
             CALL   PAUSE          ; Tid lav.
             POP    BC
             DEC    D
             JP     NZ,LYDSLOOP1   ; Test er antal perioder frdig
             INC    BC             ; Lav lyd lavere frekvens
             DEC    E              ; Tl antal lyde
             JP     NZ,LYDSIGEN1   ; hvis ikke frdig, s bip videre.
             LD     E,10           ; Antal lyde i skala ned
             LD     BC,20          ; Start pause
LYDSIGEN2:   LD     D,10           ; Antal perioder p hver lyd.
LYDSLOOP2:   LD     A,0FFH          ; Stter hjttaler hj.
             OUT    (DACLYD),A
             PUSH   BC
             CALL   PAUSE          ; Tid hj.
             POP    BC
             LD     A,0            ; Stter hjttaler lav.
             OUT    (DACLYD),A
             PUSH   BC
             CALL   PAUSE          ; Tid lav.
             POP    BC
             DEC    D
             JP     NZ,LYDSLOOP2   ; Test er antal perioder frdig
             DEC    BC             ; Lav lyd Hjere frekvens
             DEC    BC             ; med hurtigere stigning
             DEC    E              ; Tl antal lyde
             JP     NZ,LYDSIGEN2   ; hvis ikke frdig, s bip videre.
             POP    DE
             POP    BC
             POP    AF
             EI
             RET


;********************************************************************
;        SUB-RUTINE..: SAMPLE                                       ;
;        Funktion....: Afstiller en AMIGA RAW 8 bit samble          ;
;        Input.......: data fra eprommen                            ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: PAUSE                                        ;
;        Initialer...: TST.     dato: 21/7-95                       ;
;********************************************************************
SAMPLE:      DI                    ; Ingen taste afbrydelser TAK.
             PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     HL,OKREADY     ; PEG P SAMPLEN
             LD     DE,8125        ; SAMPLE LNGDE

SAMP_LOOP:   LD     A,(HL)
             ADD    A,128          ; Inverter bit7 = AMIGA RAW FORMAT
             OUT    (DACLYD),A
             LD     B,30           ; Her sttes afspille hastighed
SAMP_LP      NOP                   ; stre tal = langsomere tale...
             DJNZ   SAMP_LP
             INC    HL
             DEC    E
             JP     NZ,SAMP_LOOP
             DEC    D
             JP     NZ,SAMP_LOOP
             LD     A,7FH
             OUT    (DACLYD),A     ; MIDDEL VRDI

SAMP_SLUT:   POP    DE
             POP    BC
             POP    AF
             EI
             RET




;********************************************************************
;        SUB-RUTINE..: LYDMELODI                                    ;
;        Funktion....: Laver en lille melodi                        ;
;        Input.......: Intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Ingen registre                               ;
;        Kalder......: LYD2PAUSE (lokal subrutine)                  ;
;        Initialer...: TST.  KEA   dato: 3/11-93   rev2             ;
;********************************************************************
LYDMELO:     DI
             PUSH   AF
             PUSH   BC
             PUSH   HL
             PUSH   DE

             LD     HL,LYDDATA     ; Peg p lyd tabel
LYDMUZLOOP:  LD     A,(HL)         ; Hent antal perioder p lyden
             CP     STOP
             JP     Z,LYDMELSLUT   ; Test om melodien er slut
             LD     D,A            ; Flyt antal perioder til D-reg.
             INC    HL             ; Peg p periode tid
             LD     E,(HL)         ; Hent periodetid
             CALL   LYDMUZAK       ; Afspil tone
             INC    HL             ; Peg p antal perioder
             JP     LYDMUZLOOP

LYDMUZAK:    LD     A,0FFH
             OUT    (DACLYD),A     ; Stter hjttaler hj.
             LD     C,E            ; Hent periodetid
             CALL   LYD2PAUSE      ; Tid hj.
             LD     A,0
             OUT    (DACLYD),A     ; Stter hjttaler lav.
             LD     C,E            ; Hent periodetid
             CALL   LYD2PAUSE      ; Tid lav.
             DEC    D
             JP     NZ,LYDMUZAK    ; Test om tonen er frdig
             RET

;            ANTAL-PERIODER,PERIODE-TID
;                    E     F      G     F     E     D      C
LYDDATA:     .byte 110,74,46,69,156,62,46,69,88,74,80,83,126,93,STOP

;*******************************************************************
; Denne pause varer (C ; 20.5) + 2.5 microsekunder  KEA.           ;
;*******************************************************************
LYD2PAUSE:   LD     B,5            ; 1.75uS
LYD2LOOP2:   DJNZ   LYD2LOOP2      ; 3.25uS  (B=0 : 2uS)
             DEC    C              ; 1uS
             JP     NZ,LYD2PAUSE   ; 2.5uS
             RET                   ; 2.5uS

LYDMELSLUT:  POP    DE
             POP    HL
             POP    BC
             POP    AF
             EI
             RET



;******************************************************************
;        SUB-RUTINE..: STARTUP                                    ;
;        Funktion....: Opstter brugerdefinerede settings         ;
;        Input.......: Intet                                      ;
;        Output......: Variabler                                  ;
;        delgger...: A                                          ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.TST.   dato: 6/9-93                    ;
;******************************************************************
STARTUP:     LD     A,0
             OUT    (DACSTR0M),A   ; Stter strm til nul
             LD     A,00000010B    ; B2:!conv. start, B1:!afladning
                                   ; B0:!Strm
             LD     (OUTREG),A     ; Gem i RAM register
             OUT    (UART4),A      ; St bits p porten
             LD     A,11000000B    ; Ingen tast trykket, Ingen ny tast trykket
             LD     (KEYNR),A      ; Gem tastkode
             LD     A,0
             LD     (DEBUG),A      ; SL DEBUGER FRA VED START
             LD     A,1
             LD     (TEMP_DEL1),A  ; 1-1 = 0 SDAN ER DET BARE..
             LD     (TEMP_DEL10),A ; 10 SEKUNDER PAUSE
             LD     A,$FF
             LD     (TEMP_1GANG),A ; MARKER DER IKKE HAR VRET TEMP FEJL.
             RET



;******************************************************************
;        SUB-RUTINE..: KODERETRY                                  ;
;        Funktion....: At stoppe en kode hacker DELAY 6 SEK       ;
;        Input.......: Variabel KOD_RETRY                         ;
;        Output......: Variabler                                  ;
;        delgger...: A                                          ;
;        Kalder......: Ingen                                      ;
;        Initialer...: TST.   dato: 21/11 1994                    ;
;******************************************************************
KODERETRY:   LD     A,(KOD_RETRY)
             CP     0
             JP     Z,KOD_R_SLUT
             CALL   CLS
             LD     HL,TXT_RETRYA
             CALL   SKRIV
KODE_R_LP:   LD     BC,60000      ; pause 6 sek.
             CALL   PAUSE
KOD_R_SLUT:  RET




;********************************************************************
;        SUB-RUTINE..: TASTEINPUT                                   ;
;        Funktion....: Indlser D antal data fra keyboard og gemmer ;
;                      dem i rammem hvor HL peger.                  ;
;        Input.......: HL peger p startadr. hvor tasteinput gemmes ;
;                      D=Max. antal inputcifre     E=cursorposition ;
;        Output......: Gemte decimaldata i rammen                   ;
;        delgger...: BC,DE,HL                                     ;
;        Kalder......:                                              ;
;        Initialer...: KEA.   dato: 22/10-93                        ;
;********************************************************************
TASTEINPUT:  PUSH   AF
             PUSH   BC
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     (TASTEPEGER),HL ; Gem pegepind
             LD     B,D            ; Hent antal cifre
TAST_0_STIL: LD     (HL),0         ; Gem '0' hvor pegepind peger
             INC    HL             ; Peg p nste plads
             DJNZ   TAST_0_STIL    ; Indtil alle pladser er fyldt med '0'

TAST_NED:    LD     A,(KEYNR)      ; Hent tast
             BIT    7,A            ; Er der trykket p en tast
             JP     Z,TAST_NED     ; Venter p at ingen tast er aktiveret
             CALL   BLINK_ON       ; Blinkende cursor
STARTINPUT:  LD     HL,TEMPGEM     ; Hent startadr. p midlertidigt ramlager
             LD     A,E            ; Hent cursorposition
             LD     B,'2'
             CALL   GOTOPOS        ; Placer cursor
             LD     B,D            ; Hent antal INPUT-karakterer
INPUTLOOP:   CALL   HENTTAST
             CP     $FF
             JP     Z,INPUTLOOP
             CP     10             ; Test om det er #-tryk
             JP     Z,SLETKEY      ; S slet INPUT-omrde p skrmen.
             CP     12             ; Test om det er ;-tryk
             JP     Z,ENTERKEY     ; S Gem det indtastede
             LD     (HL),A         ; Gem det indtastede i TEMPGEM
             ADD    A,$30          ; Konverter indtastet tal til ASCII
             CALL   SKRIVA         ; Skriv karakter i display
             INC    HL             ; Peg p nste plads i TEMPGEM
             DJNZ   INPUTLOOP      ; Indtil max. antal cifre er trykket
INPUTLOOP2:  CALL   HENTTAST       ; Hent Trykket tast
             CP     10             ; Test om det er #-tryk
             JP     Z,SLETKEY      ; S slet INPUT-omrde p skrmen.
             CP     12             ; Test om det er ;-tryk
             JP     Z,ENTERKEY     ; S Gem det indtastede
             JP     INPUTLOOP2     ; Venter p en trykket tast

SLETKEY:     LD     A,B            ; Hent antal manglende indtastninger
             CP     D              ; Trk max. antal indtastninger fra
             JP     Z,TASTFORTRYD  ; Hvis ingen indtastninger: Afslut med fejl
             LD     A,E            ; Hent cursorposition
             LD     B,'2'
             CALL   GOTOPOS        ; Placer cursor
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             LD     B,D            ; Hent max. antal INPUT-cifre
SLETKEYLOOP: LD     A,' '
             CALL   SKRIVA         ; Skriv mellemrum i display
             DJNZ   SLETKEYLOOP    ; 'Max. cifre' antal gange
             JP     STARTINPUT     ; Start forfra p INPUT
TASTFORTRYD: LD     A,0FFH         ; Marker at der skal hoppes en menu tilbage
             LD     (FORTRYDTAST),A
             JP     TASTESLUT
ENTERKEY:    LD     A,D            ; Hent max. antal INPUT-cifre
             SUB    B              ; Trk manglende indtastninger fra
             JP     Z,STARTINPUT   ; Hvis ingen indtastninger: Start forfra
             LD     HL,(TASTEPEGER) ; Hent startadr. hvor INPUT-data skal
                                   ; ligge
             INC    B
             DEC    B
             JP     Z,MAX_TAST     ; Hvis Max. cifre er trykket: hop
ENTERLOOP:   INC    HL             ; Peg p 1. cifferplads
             DJNZ   ENTERLOOP
MAX_TAST:    LD     D,H            ; Flyt HL til DE
             LD     E,L
             LD     HL,TEMPGEM     ; Hent startadr. p det nyligt indtastede
             LD     B,0            ; High-byten=0
             LD     C,A            ; Lo-byten=antal indtastninger
             LDIR                  ; Kopier det indtastede til det
                                   ; specificerede ram-omrde
             LD     A,0
             LD     (FORTRYDTAST),A

TASTESLUT:   CALL   BLINK_OFF      ; Sluk cursor-blink
             POP    BC
             POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: INPUT_TEST                                 ;
;        Funktion....: Tester om input er inden for de tilladte   ;
;                      rammer, ellers returneres med et fejlflag  ;
;        Input.......: IX=Max. input      IY=min. input           ;
;                      HL=aktuel input    B=max. antal cifre      ;
;                      C=Fejlnr.                                  ;
;        Output......: Eventuel fejlindikering                    ;
;        delgger...: ingen                                      ;
;        Kalder......: SKRIV, PAUSE, CLS, RAM_ALARM               ;
;        Initialer...: KEA.  dato: 25/10-93                       ;
;******************************************************************
INPUT_TEST:  PUSH   AF             ; Gem registre
             PUSH   DE
             LD     (TEMPGEM),HL   ; Gem pegepind
             LD     D,B            ; Gem antal cifre
INP_MAX:     LD     A,(IX+0)       ; Hent Max. input
             CP     (HL)           ; Trk Aktuel input fra
             JP     Z,INP_MAX_ENS  ; Hvis Max. input = Aktuel input: Test
                                   ; nste ciffer
             JP     C,INPUTFEJL    ; Hvis Max. input < Aktuel input: Fejl
             JP     INP_MIN        ; Test om aktuel input er for lille
INP_MAX_ENS: INC    IX             ; Peg p nste Max.ciffer
             INC    HL             ; Peg p nste Aktuelciffer
             DJNZ   INP_MAX        ; Test nste ciffer
             JP     INPUT_T_OK
INP_MIN:     LD     HL,(TEMPGEM)   ; Hent pegepind
             LD     B,D            ; Hent antal cifre
INP_MINLOOP: LD     A,(IY+0)       ; Hent Min. input
             CP     (HL)           ; Trk Aktuel input fra
             JP     Z,INP_MIN_ENS  ; Hvis Min. input = Aktuel input: Test
                                   ; nste ciffer
             JP     NC,INPUTFEJL   ; Hvis Min. input > Aktuel input: Fejl
             JP     INPUT_T_OK     ; Input er godkendt
INP_MIN_ENS: INC    IY             ; Peg p nste Min.ciffer
             INC    HL             ; Peg p nste Aktuelciffer
             DJNZ   INP_MINLOOP    ; Test nste ciffer
             JP     INPUT_T_OK
INPUTFEJL:   CALL   CLS
             LD     HL,TXT_FEJL
             CALL   LINE1
             CALL   SKRIV          ; SKRIV 'FEJLINDTASTNING!'
             LD     HL,TXT_FEJL0   ; Peg p fejltekst0
             INC    C
             DEC    C              ; Test om fejlnr=0
             LD     B,C
             JP     Z,INP_FJL_TXT  ; Hvis fejl0 skal pegepinden ikke rykkes
INP_FEJL_LP: INC    HL             ; peg p nste karakter i fejlkoderne
             LD     A,$0D          ; $0D=carriage return
             CP     (HL)           ; Test om CR findes i tekst
             JP     Z,INP_FJLLOOP  ; Hvis CR s hop
             JP     INP_FEJL_LP    ; Hvis ingen CR hop tilbage og sg videre
INP_FJLLOOP: INC    HL             ; Peg p nste karakter i fejlkoderne
             DJNZ   INP_FEJL_LP    ; Indtil pegepind er p rigtig fejltekst
INP_FJL_TXT: CALL   LINE2          ; Flyt cursor til linie 2
             CALL   SKRIV          ; Skriv fejl i linie 2
             LD     C,1            ; Indiker fejl
INP_FJL_TXT2: CALL   HENTTAST
             CP     $FF
             JP     Z,INP_FJL_TXT2
             JP     INP_T_SLUT

INPUT_T_OK:  LD     C,0            ; Indiker ingen fejl
INP_T_SLUT:  POP    DE
             POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: METER_ASCII                                ;
;        Funktion....: Konverterer binr-spndingen i A-reg. til  ;
;                      ASCII, som gemmes i en tekststreng.        ;
;        Input.......: A=Volt binr, HL=Adr. i tekststreng        ;
;        Output......: Indstter Volt-ASCII i tekststreng         ;
;        delgger...: HL,A                                       ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.          dato: 20/10-93               ;
;******************************************************************
METER_ASCII: PUSH   BC
             LD     B,'0'          ; 100-tller = 0
MTRLOOP_100: CP     100            ; Test om der kan trkkes 100 fra tallet
             JP     C,MTR_GEM_100  ; Hvis ikke s gem 100-tller
             SUB    100            ; Trk 100 fra volt binr
             INC    B              ; forg 100-tller med 1
             JP     MTRLOOP_100
MTR_GEM_100: LD     C,A            ; Gem binr volt
             LD     A,B            ; 100-tller kopieres til A.reg.
             CP     '0'            ; Test om 100-tller = '0'
             JP     Z,MTR_NUL_100  ; Hvis ja: hop til MTR_NUL_100
             LD     (HL),B         ; Gem 100-tller
             JP     MTR_10_TAEL    ; Tl tiere
MTR_NUL_100: LD     (HL),' '       ; Indst mellemrum nr spnding er under
                                   ; 10 volt
MTR_10_TAEL: LD     A,C            ; Hent binr volt
             LD     B,'0'          ; 10-tller = '0'
MTRLOOP_10:  CP     10             ; Test om der kan trkkes 10 fra tallet
             JP     C,MTR_GEM_10   ; Hvis ikke s gem 10-tller
             SUB    10             ; Trk 10 fra volt binr
             INC    B              ; Forg 10-tller med 1
             JP     MTRLOOP_10
MTR_GEM_10:  INC    HL             ; Peg p tiernes karakterplads
             LD     (HL),B         ; Gem 10-tller
             ADD    A,'0'          ; De enere der er i volt binr adderes
                                   ; med '0'
             INC    HL             ; Spring '.' over
             INC    HL             ; Peg p enernes karakterplads
             LD     (HL),A         ; Gem enere
             POP    BC
             RET



;******************************************************************
;        SUB-RUTINE..: VOLT_MAXMIN                                ;
;        Funktion....: Opdaterer max.- og min. spndingen i for-  ;
;                      hold til klemspndingen.                   ;
;        Input.......: A=Klemspndingen                           ;
;        Output......: Opdaterede max.- og min.spndinger         ;
;        delgger...: Ingen                                      ;
;        Kalder......: Ingen                                      ;
;        Initialer...: KEA.          dato: 20/10-93               ;
;******************************************************************
VOLT_MAXMIN: PUSH   BC
             PUSH   AF
             LD     B,A            ; Gem klemspnding
             LD     A,(VOLTMAX)    ; Hent maximumsspnding
             CP     B              ; Sammenlign de to spndinger
             JP     NC,TEST_MIN    ; Hop TEST MIN hvis klemsp. < max.spnd.
             LD     A,B            ; Ellers flyt klemspndingen til A
             LD     (VOLTMAX),A    ; og gem den i MAX TEMP
             JP     MIN_MAXSLUT    ; Afslut rutine
TEST_MIN:    LD     A,(VOLTMIN)    ; Hent minimumstemperatur
             CP     B              ; Sammenlign de to temperaturer
             JP     C,MIN_MAXSLUT  ; Hop MIN_MAXSLUT hvis klemsp. > min.spnd
             LD     A,B            ; Ellers flyt klemspndingen til A
             LD     (VOLTMIN),A    ; og gem den i VOLT_MIN
MIN_MAXSLUT: POP    AF
             POP    BC             ; Hent gemte registre
             RET



;******************************************************************
;        SUB-RUTINE..: SLUTLYDTEST                                ;
;        Funktion....: Tester vilken lyd der skal afspiles-       ;
;                      Nr opladning, afladning, kondi er frdig  ;
;        Input.......: Variabel: slutlyd, slutpref                ;
;        Kalder......: LYDMELO, LYDSKAL, LYDALARM                 ;
;        Bruger......: Ingen registre                             ;
;        Initialer...: TST.   dato: 6/11-93  rev2                 ;
;******************************************************************
SLUTLYDTEST: PUSH   AF
             LD     A,(SLUTLYD)    ; Der skal kun laves lyd
             CP     00H            ; hvis ladning selv slutter.
             JP     Z,SLUTLYDNO
             LD     A,(SLUTPREF)   ; Henter slut kontrol ord
             CP     0
             JP     Z,SLUTLYDNO
             CP     1
             CALL   Z,LYDALARM     ; Hvis det = 1 s afspil alarmlyd
             CP     2
             CALL   Z,LYDMELO      ; Hvis det = 2 s afspil melodi
             CP     3
             CALL   Z,LYDSKAL      ; Hvis det = 3 s afspil skala
             CP     4
             CALL   Z,SAMPLE
             CP     5
             CALL   Z,LYDFADER
             CP     6
             CALL   Z,LYDFADER2
             CP     7
             CALL   Z,LYDTING
             CP     8
             CALL   Z,LYDFLIP
SLUTLYDNO:   POP    AF             ; Ellers afspil intet
             RET





;******************************************************************
;        SUB-RUTINE..: KODETEST                                   ;
;        Funktion....: Tester om der skal indtastes access koden  ;
;        Kalder......: KODE (hvis den skal indtastes)             ;
;        Bruger......: Ingen registre                             ;
;        Initialer...: TST.   dato: 18/10-93                      ;
;******************************************************************
KODETEST:    PUSH   AF
             LD     A,(KODERUN)    ; Hent kontrol register
             CP     55H            ; Hvis det indeholder 55H
             JP     Z,KODEOK       ; afsluttes sub-rutinen
KODE_IGEN:   CALL   KODE           ; Ellers indtastes koden..
             CP     0              ; 0=IKKE GODKENDT
             JP     Z,KODE_IGEN
             LD     A,55H          ; Her er koden godkent
             LD     (KODERUN),A
             LD     A,0
             LD     (KOD_RETRY),A  ; set ingen RETRY
             LD     (SEK_EN),A     ; Nulstil kode ur
             LD     (SEK_TI),A
             LD     (MIN_EN),A
             LD     (MIN_TI),A
             LD     (TIM_EN),A
             LD     (TIM_TI),A
             LD     A,(KODE_DAG1)  ; Hent indtastet dage enere
             LD     (DAGE_EN),A
             LD     A,(KODE_DAG10) ; Hent indtastet dage tiere
             LD     (DAGE_TI),A
             JP     KODEOK

KODEOK:      POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: KODE                                       ;
;        Funktion....: Indlser Access kode.                      ;
;        Output......: A = 0 hvis fejl                            ;
;        Kalder......: SKRIV, LINE2, CLS, GOTOPOS, BLINK_ON -     ;
;                      BLINK_OFF, KEYB_SCAN, KODETAST(LOKAL)      ;
;        Bruger......: AF                                         ;
;        Initialer...: TST.   dato: 21/11-94                      ;
;******************************************************************
KODE:        PUSH   BC
             PUSH   HL
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             CALL   CLS            ; Display slettes
             LD     HL,TXT_KOD1A   ; Peg p 'INDTAST ACCESS- '
             CALL   SKRIV          ; Skriv tekst
             CALL   FINDPOS2       ; Cursor til position efter'>'
             CALL   BLINK_ON       ; Blinkene Cursor
             LD     B,4            ; Antal cifre i koden
             LD     HL,TEMPGEM     ; der skal indtastede taster gemmes
KODEIND:     CALL   HENTTAST       ; Henter tast
             CP     $FF
             JP     Z,KODEIND
             LD     (HL),A         ; Gem tast i ram
             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.
             INC    HL             ; plads til nste tast
             LD     A,'*'
             CALL   SKRIVA         ; Skriv ASCII karakter i display
             DJNZ   KODEIND        ; Test antal cifre i koden
             CALL   BLINK_OFF      ; Sluk cursor
             LD     BC,2000
             CALL   PAUSE          ; Pause i 0.2 Sekund.

KODETESTEN:  LD     HL,TEMPGEM     ; Peg p 1. indtastede tal
             LD     A,KODE1        ; Her er 1. tal i koden
             CP     (HL)           ; Test om 1. tal
             JP     Z,KODEOK1      ; Hop hvis 1. tal er ok
             JP     KODE_FEJL      ; Ellers er der fejl i koden
KODEOK1:     LD     (HL),0         ; Slet rigtig tast i ram
             INC    HL             ; Peg p 2. indtastede tal
             LD     A,KODE2        ; Her er 2. tal i koden
             CP     (HL)           ; Test om 2. tal
             JP     Z,KODEOK2      ; Hop hvis 2. tal er ok
             JP     KODE_FEJL      ; Ellers er der fejl i koden
KODEOK2:     LD     (HL),0         ; Slet rigtig tast i ram
             INC    HL             ; Peg p 3. indtastede tal
             LD     A,KODE3        ; Her er 3. tal i koden
             CP     (HL)           ; Test om 3. tal
             JP     Z,KODEOK3      ; Hop hvis 3. tal er ok
             JP     KODE_FEJL      ; Ellers er der fejl i koden
KODEOK3:     LD     (HL),0         ; Slet rigtig tast i ram
             INC    HL             ; Peg p 4. indtastede tal
             LD     A,KODE4        ; Her er 4. tal i koden
             CP     (HL)           ; Test om 4. tal
             JP     Z,KODE_OK      ; Hop hvis 4. tal er ok
                                   ; Ellers er der fejl i koden

KODE_FEJL:   CALL   CLS            ; Display slettes
             LD     HL,TXT_KOD3A   ; Peg p 'FORKERT KODE!?! '
             CALL   SKRIV          ; Skriv tekst
             LD     BC,20000
             CALL   PAUSE
             LD     A,0
             JP     KODESLUT

KODE_OK:     CALL   CLS            ; Display slettes
             LD     HL,TXT_KOD2A   ; 'RIGTIG KODE.    '
             CALL   SKRIV          ; Skriv tekst
             LD     BC,10000
             CALL   PAUSE          ; Pause i 1.0 Sekund.
             LD     A,1
             LD     HL,TEMPGEM
             LD     (TEMPGEM),A    ; SLET rigtig kode fra rammen...
             INC    HL
             LD     (TEMPGEM),A
             INC    HL
             LD     (TEMPGEM),A
             INC    HL
             LD     (TEMPGEM),A

KODESLUT:    POP    HL
             POP    BC
             RET




;******************************************************************
;        SUB-RUTINE..: INIT_LCD                                   ;
;        Funktion....: 2 linjer LCD-Display setup                 ;
;        Input.......: Intet                                      ;
;        Output......: Intet                                      ;
;        delgger...: Intet                                      ;
;        Kalder......: PAUSE                      TST 1993 + 1994 ;
;******************************************************************
INIT_LCD:    LD     BC,150
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,38H          ; Reset Display
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,100
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,38H          ; Reset Display
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,38H          ; Reset Display
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,38H          ; Display FUNCTION SET
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,06H          ; Display ENTRY MODE SET
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,0CH          ; Display ON/OFF CONTROL
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,01H          ; Display CLEAR
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'I'          ; I
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'N'          ; N
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'I'          ; I
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'T'          ; T
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'-'          ;
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'O'          ; O
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,30
             CALL   PAUSE

             LD     A,'K'          ; K
             OUT    (PIOB),A
             LD     A,9
             OUT    (PIOC),A
             LD     A,1
             OUT    (PIOC),A

             LD     BC,300
             CALL   PAUSE
             CALL   GFXSET
             RET




;******************************************************************
;        INIT_UART                                                ;
;        Funktion....: Initialisere seriel porten  >8250<         ;
;                      9600 Baud, 8 bit, 1 stopbit, 0 paritet     ;
;        Output......:                                            ;
;        delgger...: A,                                         ;
;        Kalder......: PAUSE                             TST 1993 ;
;******************************************************************
INIT_UART:   LD     A,$AA
             OUT    (UART7),A
             IN     A,(UART7)
             CP     $AA           ; Test om vrdien kunne gemmes
             JP     NZ,INITUARTFEJL
             LD     A,$55
             OUT    (UART7),A
             IN     A,(UART7)
             CP     $55           ; Test om vrdien kunne gemmes
             JP     NZ,INITUARTFEJL
             JP     UART_OK

INITUARTFEJL:                      ; Her er der fejl i UART
             LD     A,0
             LD     (SER_ON),A     ; SLUK SERPORT
             CALL   CLS
             LD     HL,TXT_UART1A  ; FEJL BESKED
             CALL   SKRIV
             LD     BC,10000
             CALL   PAUSE
             LD     A,1
             LD     (UARTFEJL),A
.IF LAVFINAL=1
             HALT
.ENDIF
             JP     INITRET



UARTFEJLDEF:
             LD     A,0
             LD     (SER_ON),A     ; SLUK SERPORT
             CALL   CLS
             LD     HL,TXT_UART2   ; FEJL BESKED "BAUD RATE IKKE DEFINERET"
             CALL   SKRIV          ;              VLGER 19K2
             LD     BC,60000
             CALL   PAUSE
             JP     UART19K2

UART_OK:     LD     A,0
             LD     (UARTFEJL),A   ; UART OK FUNDET
             LD     A,(SER_BAUD)
             CP     1
             JP     Z,UART1200
             CP     2
             JP     Z,UART2400
             CP     3
             JP     Z,UART4800
             CP     4
             JP     Z,UART9600
             CP     5
             JP     Z,UART19K2
             CP     6
             JP     Z,UART38K4
             CP     7
             JP     Z,UART57K6
             CP     8
             JP     Z,UART76K8
             JP     UARTFEJLDEF

UART1200:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,218         ; (218.45)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART2400:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,109         ; (109.23)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART4800:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,55          ; (54.61)
             OUT    (UART0),A     ;
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART9600:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,27          ; (27.3)
             OUT    (UART0),A     ; Set BAUD rate til 9600
             LD     A,00H
             OUT    (UART1),A     ; Set BAUD rate til 9600
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART19K2:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,14          ; (13.65)
             OUT    (UART0),A     ;
             LD     A,0
             OUT    (UART1),A     ;
             LD     A,3
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART38K4:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,7
             OUT    (UART0),A     ; (6.82)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART57K6:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,5
             OUT    (UART0),A     ; (4.55)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
             JP     INITRET       ; 0 paritet, reset DLAP FLAG
UART76K8:    LD     A,80H
             OUT    (UART3),A     ; SET DLAB FLAG
             LD     A,3
             OUT    (UART0),A     ; (3.41)
             LD     A,00H
             OUT    (UART1),A     ;
             LD     A,03H
             OUT    (UART3),A     ; Set 8 bit data, 1 stopbit
                                  ; 0 paritet, reset DLAP FLAG
INITRET:     RET




;******************************************************************
;        INIT_PIO                                                 ;
;        Funktion....: Initialisere parallel port kredsen >8255<  ;
;        Kalder......:                               tst 2-5-1994 ;
;******************************************************************
INIT_PIO:
BOUT:        LD     A,10010000B    ; A = INPUT, B = OUTPUT C= OUTPUT
             OUT    (PIOCONT),A
             RET

BIN:         LD     A,10010010B    ; Port B = input (DATA FRA LCD)
             OUT    (PIOCONT),A
             RET



;********************************************************************
;        SUB-RUTINE..: TASTEKLIK                                    ;
;        Funktion....: Bipper i hjttaleren                         ;
;        Input.......: Intet                                        ;
;        Output......: Lyd i hjttaleren                            ;
;        delgger...: Intet register                               ;
;        Kalder......: LYDPAUSE (lokal sub)                         ;
;        Initialer...: TST. KEA.dato: 11/10-93     rev2 keybpref    ;
;********************************************************************
TASTEKLIK:   PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     A,(KEYBPREF)   ; Antal perioder hentes fra ram
             CP     0
             JP     Z,LYD_SLUT     ; hvis 0 perioder: ingen lyd
             LD     D,A            ; perioder p lyden.
             LD     A,(OUTREG)     ; Henter keydata og kontrol-ord.
LYD_LOOP:    LD     A,$D0          ; Stter hjttaler hj.
             OUT    (DACLYD),A
             CALL   LYDPAUSE
             LD     A,$30          ; Stter hjttaler lav.
             OUT    (DACLYD),A
             CALL   LYDPAUSE
             DEC    D
             JP     NZ,LYD_LOOP    ; Hvis ikke frdig, hop
             JP     LYD_SLUT

LYDPAUSE:    LD     B,60           ; Bestemmer den halve periodetid
LYD_PAU2:    DJNZ   LYD_PAU2       ; Hop hvis B <> 0.
             RET

LYD_SLUT:    POP    DE
             POP    BC
             POP    AF
             RET




;***********************************************************************
;  SUB-RUTINE..: POL_OG_TEMP (kaldes fra interrupt)                    ;
;  Funktion....: Tester om der er omvndt polaitet p terminalerne, og ;
;                for overvarm kleplade.                               ;
;  Kalder......: LYDALARM,                                             ;
;  Bruger......: A,B,HL                                                ;
;  Initialer...: TST.   dato: 28/1 96                                  ;
;***********************************************************************
POL_OG_TEMP: PUSH   AF
             PUSH   HL
             LD     A,0
             LD     (FEJLTEMP),A   ; MARKER OK, INGEN OVER TEMPERATUR
             LD     (FEJLPOL),A
             IN     A,(PIOA)       ; Hent alle input signaler
             BIT    5,A            ; Isoler pol-bit.
             JP     NZ,POL_OK      ; Hvis bit=1, s ingen pol. fejl
             JP     POL_FEJL

POL_OK:      BIT    4,A            ; Isoler Temperatur-bit.
             JP     NZ,TEMP_SLUT   ; Hvis bit=1, s pol. eller temp. fejl

TEMP_FEJL:   LD     A,(LAD_STAT)
             CP     0
             JP     Z,TEMP_SLUT    ; HVIS DER IKKE OP/AF-LADES, S AFSLUT
             LD     A,1
             LD     (FEJLTEMP),A   ; MARKER TEMPERATUREN ER FOR HJ
             JP     TEMP_SLUT

POL_FEJL:    CALL   LYDALARM       ; 3 bip
             IN     A,(PIOA)       ; Hent alle input signaler
             BIT    5,A            ; isoler pol-bit.
             JP     Z,POL_FEJL     ; Her loopes til der ikke er fejl mere


TEMP_SLUT:   POP    HL
             POP    AF
             RET                   ; Her fortstter interruptet.




;********************************************************************
;*       SUB-RUTINE..: KEYBOARDSCAN (kaldes med interrupt)          *
;*       Funktion....: Aflser keyboard og registrerer tastetryk    *
;*       Input.......: Tastatur                                     *
;*       Output......: Den sidst trykkede tast gemmes i TASTMEM     *
;*       delgger...: AF,BC                                        *
;*       Kalder......: Intet                                        *
;*       Initialer...: Tst: 27/12-95                                *
;********************************************************************
KEYB_SCAN:   IN     A,(PIOC)
             AND    00001111B
             OR     01000000B      ; SET 369# HJ
             OUT    (PIOC),A       ; Skriv portdata til porten

             CALL   KEYB_DELAY
             IN     A,(PIOA)       ; Ls keyboardport
             AND    00001111b      ; Isoler keyboardbit
             LD     B,A            ; GEM 3. RKKE

             IN     A,(PIOC)
             AND    00001111B
             OR     00100000b      ; SET 2580 HJ
             OUT    (PIOC),A

             CALL   KEYB_DELAY
             IN     A,(PIOA)       ; Ls keyboardport
             AND    00001111b      ; Isoler keyboardbit
             LD     C,A            ; GEM 2. RKKE

             IN     A,(PIOC)
             AND    00001111B
             OR     00010000b      ; SET 147* HJ
             OUT    (PIOC),A

             CALL   KEYB_DELAY
             IN     A,(PIOA)       ; Ls keyboardport
             AND    00001111b      ; Isoler keyboardbit
             LD     D,A            ; GEM 1. RKKE
             LD     A,B            ; HENT 3.
             CP     0
             JP     Z,KB_B0
KB_BX:       LD     A,C            ; HENT 2.
             CP     0
             JP     Z,KB_BX_C0
             JP     KEYB_SLUT
KB_BX_C0:    LD     A,D            ; HENT 1.
             CP     0
             JP     Z,KB_BX_C0_D0
             JP     KEYB_SLUT
KB_B0:       LD     A,C            ; HENT 2.  B=NEJ
             CP     0
             JP     Z,KB_B0_C0
             LD     A,D            ; HENT 1.  B=NEJ C=JA
             CP     0
             JP     Z,KB_B0_CX_D0
             JP     KEYB_SLUT      ;          B=NEJ C=JA D=JA
KB_B0_C0:    LD     A,D            ; HENT 1.  B=NEJ C=NEJ
             CP     0
             JP     Z,KEYB_INGEN   ; INGEN TASTER
             JP     KB_B0_C0_DX

KB_BX_C0_D0: LD     A,(KEYNR)      ; HER ER DER KUN NOGET I 3. RKKE
             BIT    7,A            ; Test om tast lige har vret aktiv
             JP     Z,KEYB_SLUT    ; Hvis ja, s afslut
             LD     A,B            ; HENT TASTEN
             CP     8
             JP     Z,KB_B3
             CP     4
             JP     Z,KB_B6
             CP     2
             JP     Z,KB_B9
             CP     1
             JP     Z,KB_B12
             JP     KEYB_SLUT      ; FLERE TASTER SAMTIDIG
KB_B3:       LD     A,3
             JP     KEYB_TAST
KB_B6:       LD     A,6
             JP     KEYB_TAST
KB_B9:       LD     A,9
             JP     KEYB_TAST
KB_B12:      LD     A,12
             JP     KEYB_TAST

KB_B0_CX_D0: LD     A,(KEYNR)      ; HER ER DER KUN NOGET I 2. RKKE
             BIT    7,A            ; Test om tast lige har vret aktiv
             JP     Z,KEYB_SLUT    ; Hvis ja, s afslut
             LD     A,C            ; HENT TASTEN
             CP     8
             JP     Z,KB_C2
             CP     4
             JP     Z,KB_C5
             CP     2
             JP     Z,KB_C8
             CP     1
             JP     Z,KB_C0
             JP     KEYB_SLUT      ; FLERE TASTER SAMTIDIG
KB_C2:       LD     A,2
             JP     KEYB_TAST
KB_C5:       LD     A,5
             JP     KEYB_TAST
KB_C8:       LD     A,8
             JP     KEYB_TAST
KB_C0:       LD     A,0
             JP     KEYB_TAST

KB_B0_C0_DX: LD     A,(KEYNR)      ; HER ER DER KUN NOGET I 1. RKKE
             BIT    7,A            ; Test om tast lige har vret aktiv
             JP     Z,KEYB_SLUT    ; Hvis ja, s afslut
             LD     A,D            ; HENT TASTEN
             CP     8
             JP     Z,KB_D1
             CP     4
             JP     Z,KB_D4
             CP     2
             JP     Z,KB_D7
             CP     1
             JP     Z,KB_D10
             JP     KEYB_SLUT      ; FLERE TASTER SAMTIDIG

KB_D1:       LD     A,1
             JP     KEYB_TAST
KB_D4:       LD     A,4
             JP     KEYB_TAST
KB_D7:       LD     A,7
             JP     KEYB_TAST
KB_D10:      LD     A,10
             JP     KEYB_TAST

KEYB_TAST:   LD     (KEYNR),A
             RES    6,A            ; indiker at ny tast er trykket
             LD     (KEYNR),A
             JP     KEYB_SLUT

KEYB_INGEN:  LD     A,(KEYNR)      ; Hent KEYNR
             SET    7,A            ; Indiker at ingen tast er trykket
             LD     (KEYNR),A      ; Gem KEYNR
             JP     KEYB_SLUT

KEYB_SLUT:   IN     A,(PIOC)
             AND    00001111B      ; Reset alle keyboardbit
             OUT    (PIOC),A       ; Skriv portdata til port
             RET

KEYB_DELAY:  PUSH   BC
             LD     B,40            ; DELAY LOOP TIL AT FJERNE PRELL MED
KEYB_DEL:    NOP
             NOP
             DJNZ   KEYB_DEL
             POP    BC
             RET



;***********************************************************************
;        SUB-RUTINE..: UR_REAL (kaldes med interrupt)                  ;
;        Funktion....: Opdatere real-time ure                          ;
;        Input.......: Ram variabler                                   ;
;        Output......: Uret i ram register                             ;
;        delgger...: A                                               ;
;        Kalder......: Ingen                                           ;
;        Initialer...: TST.     dato: 25/10-93                         ;
;***********************************************************************
UR_REAL:     LD     A,(INTTAL)     ; Hent interrupt tller
             INC    A              ; +1
             CP     NET_FREK       ;
             JP     Z,SEK1         ; Hvis der er get et sekund, hop..
             LD     (INTTAL),A     ; Gem Tller
             JP     UR_ALT_SLUT    ; Hvis der ikke er get et sekund afslut alt.

SEK1:        LD     A,0
             LD     (INTTAL),A     ; Nulstil interrupt tller
             LD     A,(SEK_EN)
             CP     0
             JP     Z,SEK10        ; Hvis sek negativ, hop
             DEC    A
             LD     (SEK_EN),A     ; gem sek-ener
             JP     NEDSLUT        ; Nedtller slut

SEK10:       LD     A,9
             LD     (SEK_EN),A     ; 9stil sek-ener
             LD     A,(SEK_TI)
             CP     0              ; Sek-Tier -1
             JP     Z,MIN1         ; Hvis tier negativ, hop
             DEC    A
             LD     (SEK_TI),A     ; gem sek-tier
             JP     NEDSLUT        ; Nedtller slut

MIN1:        LD     A,5
             LD     (SEK_TI),A     ; 5stil sek-tier
             LD     A,(MIN_EN)
             CP     0
             JP     Z,MIN10        ; Hvis ener negativ, hop
             DEC    A              ; Minut-ener -1
             LD     (MIN_EN),A     ; Gem Minut-ener
             JP     NEDSLUT        ; Nedtller slut

MIN10:       LD     A,9
             LD     (MIN_EN),A     ; 9stil Minut-ener
             LD     A,(MIN_TI)
             CP     0
             JP     Z,TIM1         ; Hvis tier negativ, hop
             DEC    A              ; Minut-tier -1
             LD     (MIN_TI),A     ; Gem Minut-tier
             JP     NEDSLUT        ; Nedtller slut

TIM1:        LD     A,5
             LD     (MIN_TI),A     ; 5stil Minut-tier
             LD     A,(TIM_EN)
             CP     0
             JP     Z,TIM10        ; Hvis ener negativ, hop
             DEC    A              ; Time-ener -1
             LD     (TIM_EN),A     ; Gem Time-ener
             JP     NEDSLUT        ; Nedtller slut

TIM10:       LD     A,9
             LD     (TIM_EN),A     ; 9stil Time-ener
             LD     A,(TIM_TI)
             CP     0
             JP     Z,DAGE1        ; Hvis hegativ, hop
             DEC    A              ; Time-tier -1
             LD     (TIM_TI),A     ; gem Time-tier
             JP     NEDSLUT        ; Nedtller slut

DAGE1:       LD     A,3
             LD     (TIM_EN),A     ; 3stil TIME-ener
             LD     A,2
             LD     (TIM_TI),A     ; 2stil TIME-tier
             LD     A,(DAGE_EN)
             CP     0
             JP     Z,DAGE10       ; Hvis negativ, hop
             DEC    A              ; Dage-ener -1
             LD     (DAGE_EN),A    ; Gem dage-ener
             JP     NEDSLUT        ; Nedtller slut

DAGE10:      LD     A,9
             LD     (DAGE_EN),A    ; 9stil dage-ener
             LD     A,(DAGE_TI)
             CP     0
             JP     Z,DAGE0        ; Hvis negativ, hop
             DEC    A              ; Dage-tier -1
             LD     (DAGE_TI),A    ; Gem dage-tier
             JP     NEDSLUT        ; Nedtller slut

DAGE0:       LD     A,0
             LD     (KODERUN),A    ; Nu skal der ind tastes AccessKode
                                   ; nste gang der tndes for laderen.

 ; KODE Nedtller slut.

NEDSLUT:     LD     A,(STOP_TID)   ; Hent stop tid variable
             CP     0              ; 0=tiden krer
             JP     NZ,UR_ALT_SLUT ; 1=pause tid


 ; Her starter preset-optller, til aflader mling..

             LD     A,(AFLAD_1SEK)
             INC    A              ; Sek +1
             CP     2
             JP     Z,AF_SEK2      ; Hvis sek=2, hop
             LD     (AFLAD_1SEK),A ; gem sek-ener
             JP     UR_AF_SLUT

AF_SEK2:     LD     HL,(AFLAD_2SEK) ; Hent 16 bit 2sekund tller
             INC    HL              ; +1
             LD     (AFLAD_2SEK),HL ; Gem igen
             LD     A,0
             LD     (AFLAD_1SEK),A  ; Nulstil sek-ener

 ; Optller til afladning slut

UR_AF_SLUT:

 ; her kommer der en preset ned tller, til opladningen.

OP_SEK1:     LD     A,(OP_SEK_EN)
             CP     0
             JP     Z,OP_SEK10     ; Hvis sek negativ, hop
             DEC    A
             LD     (OP_SEK_EN),A  ; gem sek-ener
             JP     OPSLUT         ; Nedtller slut

OP_SEK10:    LD     A,9
             LD     (OP_SEK_EN),A  ; 9stil sek-ener
             LD     A,(OP_SEK_TI)
             CP     0
             JP     Z,OP_MIN1      ; Hvis tier negativ, hop
             DEC    A              ; Sek-Tier -1
             LD     (OP_SEK_TI),A  ; gem sek-tier
             JP     OPSLUT         ; Nedtller slut

OP_MIN1:     LD     A,5
             LD     (OP_SEK_TI),A  ; 5stil sek-tier
             LD     A,(OP_MIN_EN)
             CP     0
             JP     Z,OP_MIN10     ; Hvis ener negativ, hop
             DEC    A              ; Minut-ener -1
             LD     (OP_MIN_EN),A  ; Gem Minut-ener
             JP     OPSLUT         ; Nedtller slut

OP_MIN10:    LD     A,9
             LD     (OP_MIN_EN),A  ; 9stil Minut-ener
             LD     A,(OP_MIN_TI)
             CP     0
             JP     Z,OP_TIM1      ; Hvis tier negativ, hop
             DEC    A              ; Minut-tier -1
             LD     (OP_MIN_TI),A  ; Gem Minut-tier
             JP     OPSLUT         ; Nedtller slut

OP_TIM1:     LD     A,5
             LD     (OP_MIN_TI),A  ; 5stil Minut-tier
             LD     A,(OP_TIM_EN)
             CP     0
             JP     Z,OP_TIM10     ; Hvis ener negativ, hop
             DEC    A              ; Time-ener -1
             LD     (OP_TIM_EN),A  ; Gem Time-ener
             JP     OPSLUT         ; Nedtller slut

OP_TIM10:    LD     A,9
             LD     (OP_TIM_EN),A  ; 9stil Time-ener
             LD     A,(OP_TIM_TI)
             CP     0
             JP     Z,OP_LADET_OK  ; Hvis negativ, s er batteriet opladet
             DEC    A              ; Time-tier -1
             LD     (OP_TIM_TI),A  ; gem Time-tier
             JP     OPSLUT         ; Nedtller slut

OP_LADET_OK: LD     A,0
             LD     (LADNING_OP),A ; marker opladning er frdig

OPSLUT:
UR_ALT_SLUT: RET



;******************************************************************
;        SUB-RUTINE..: SKRIVUR                                    ;
;        Funktion....: Skriver hvor lang tid der er til,          ;
;                      at der skal indtastes access koden.        ;
;        Input.......: RAM variabler                              ;
;        Output......: Tal p nederste linje                      ;
;        delgger...: Ingen registre                             ;
;        Kalder......: GOTOPOS, DISPLAYBUSY                       ;
;        Initialer...: TST.  dato: 3/1-96                         ;
;******************************************************************
SKRIVUR:     PUSH   AF
             LD     A,1
             OUT    (PIOC),A      ; TXT, WRITE, NO ENABEL.
             LD     A,(DAGE_TI)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(DAGE_EN)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,':'
             CALL   SKRIVA        ; Vent p at display er klar
             LD     A,(TIM_TI)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(TIM_EN)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,':'
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(MIN_TI)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(MIN_EN)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,':'
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(SEK_TI)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             LD     A,(SEK_EN)
             ADD    A,$30         ; Konverter tal til ASCII
             CALL   SKRIVA        ; Skriv ASCII karakter i display
             POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: PAUSE                                      ;
;        Funktion....: Pause i 100uS. gange BC                    ;
;        Input.......: BC                                         ;
;        Output......: Variabel pause                             ;
;        delgger...: BC                                         ;
;        Kalder......: Intet                                      ;
;        Initialer...: KEA.      dato: 23/5-93                    ;
;******************************************************************
PAUSE:       PUSH   AF
             INC    B
             INC    C              ; Justering for at loop'en er rigtig
PAUSELOOP1:  LD     A,15H          ; Justerer sub-rutinen
PAUSELOOP2:  DEC    A              ; Formindsk tller. 4 T-states = 1 uS.
             JP     NZ,PAUSELOOP2  ; Hop til PAUSELOOP2 hvis A <> 0.
             DEC    C              ; Formindsk tller.
             JP     NZ,PAUSELOOP1  ; Hop til PAUSELOOP1 hvis C <> 0.
             DJNZ   PAUSELOOP1     ; Hop til PAUSELOOP1 hvis B <> 0.
PAUSESLUT:   POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: PAU_S_TAST  pause SEKUND med taste test    ;
;        Funktion....: Pause X sekunder interrupt styret = presis ;
;        Input.......: intet                                      ;
;        Output......: A er 10 hvis der trykkes '*'               ;
;        delgger...: ABCD                                       ;
;        Kalder......: HENTTAST, PAUSE                            ;
;        Initialer...: TST.          17/11 94                     ;
;******************************************************************
PAU_S_TAST:  LD     D,0            ; nulstil
PAU_S_LOOP:  CALL   HENTTAST
             CP     10             ; '*' FORTRYD-tasten
             JP     Z,PAU_S_SLUT
             LD     A,(INTTAL)     ; Hent interrupt tller
             CP     1
             JP     Z,PAU_S_1
             JP     PAU_S_LOOP
PAU_S_1:     LD     A,D            ; hent tlleren
             INC    A
             CP     9              ; HER STTES TIDEN
             JP     Z,PAU_S_SLUT
             LD     D,A            ; gem tlleren
             LD     BC,400
             CALL   PAUSE
             JP     PAU_S_LOOP
PAU_S_SLUT:  RET





;******************************************************************
;        SUB-RUTINE..: SKRIV                                      ;
;        Funktion....: Udskriver tekst i display.                 ;
;        Input.......: HL peger p tekst start adresse            ;
;                 vari SPROG fortller hvilket sprog der er valgt ;
;        Output......: Tekst i display                            ;
;        delgger...: Ingen                                      ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.     dato: 23/11-94                    ;
;******************************************************************
SKRIV:       PUSH   AF
             PUSH   BC
             PUSH   DE
             LD     (TEMPGEM),HL   ; GEMMES TIL FINDPOS2

             LD     A,1
             OUT    (PIOC),A       ; TXT, WRITE, NO ENABEL.

SKRIV_OK:    LD     B,41           ; Antal MAX karaktere
SKRIVLOOP:   LD     A,(HL)         ; Hent karakter til A
             CP     ''            ; Test om AE
             JP     Z,SKRIV_AE
             CP     ''            ; Test om AA
             JP     Z,SKRIV_OO
             CP     1              ; Test om 1 DER ER 
             JP     Z,SKRIV_OO
             CP     ''            ; Test om AA
             JP     Z,SKRIV_AA
             CP     '}'            ; Test om PIL TIL HJ
             JP     Z,SKRIV_H0J
             CP     '{'            ; Test om PIL TIL VEN
             JP     Z,SKRIV_VEN

             CP     STOP           ; $FF FOR BANK NAVN UDSKRIVNING
             JP     Z,SKRIVSLUT
             CP     $0A            ; NU BRUGER VI "LINE FEED"
             JP     Z,SKRIVDUM

SKRIV_UD:    CALL   DISPLAYBUSY    ; Vent p at display er klar
             OUT    (PIOB),A       ; Skriv karakter TIL display

             LD     B,A            ; GEM KARAKTER
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,SKRIVLCD     ; SKRIV IKKE SERIAL
             LD     A,B            ; HENT KARAKTER

             CP     0              ; Test om AE
             JP     Z,SKR_C_AE
             CP     1              ; Test om AA
             JP     Z,SKR_C_OO
             CP     2              ; Test om AA
             JP     Z,SKR_C_AA
             CP     3              ; Test om PIL TIL HJ
             JP     Z,SKR_C_H0J
             CP     4              ; Test om PIL TIL VEN
             JP     Z,SKR_C_VEN

SKRIV_COM:   CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

SKRIVLCD:    LD     A,9            ; WRITE
             OUT    (PIOC),A
             LD     A,1            ; NO-WRITE
             OUT    (PIOC),A
             INC    HL             ; Peg p nste karakter
             DJNZ   SKRIVLOOP      ; Hop til SKRIVLOOP
             JP     SKRIVSLUT

SKRIVDUM:    INC    HL
             LD     A,(HL)
             CP     $0D            ; TEST OM VI ER HELT FRDIGE
             JP     Z,SKRIVSLUT
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     1
             JP     NZ,SKRIVNOT2   ; SKRIV IKKE SERIAL

             CALL   NYLINJE

SKRIVNOT2:   CALL   LINE2          ; ELLERS SKRIV LIGE LINJE2
             LD     (TEMPGEM),HL   ; GEMMES TIL FINDPOS DER LEDER I LINJE2
             JP     SKRIV_OK       ;

SKRIV_AE:    LD     A,0
             JP     SKRIV_UD
SKRIV_AA:    LD     A,2
             JP     SKRIV_UD
SKRIV_OO:    LD     A,'0'          ; DET VIRKER FANME IKKE MED "1"
             JP     SKRIV_UD       ; S KARAKTER FOR "" BLIVER "0"
SKRIV_H0J:   LD     A,3            ; DER ER FAKTISK INGEN FORESKEL.
             JP     SKRIV_UD
SKRIV_VEN:   LD     A,4
             JP     SKRIV_UD

SKR_C_AE:    LD     A,''
             JP     SKRIV_COM
SKR_C_AA:    LD     A,''
             JP     SKRIV_COM
SKR_C_OO:    LD     A,'0'
             JP     SKRIV_COM
SKR_C_H0J:   LD     A,'>'
             JP     SKRIV_COM
SKR_C_VEN:   LD     A,'<'      ; DISSE ER IKKE DE RIGTIGE ACSII TING (LORT)
             JP     SKRIV_COM  ; MED JEG KENDER IKKE DE RIGTIGE KODER ENDU

SKRIVSLUT:
SKRIVNOT3:   LD     HL,(TEMPGEM)   ; TIL FINDPOS2, STARTADR P LINJE 2
             POP    DE
             POP    BC
             POP    AF
             RET







;******************************************************************
;        SUB-RUTINE..: SKRIVA                                     ;
;        Funktion....: Udskriver tekst i display.                 ;
;        Input.......: A ER ASCII KARAKTER                        ;
;        Output......: Tekst i display                            ;
;        delgger...: INTET                                      ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.     dato: 3/1-96                      ;
;******************************************************************
SKRIVA:      PUSH   BC
             LD     B,A            ; GEM KARAKTER

             CALL   DISPLAYBUSY    ; Vent p at display er klar til data
             OUT    (PIOB),A       ; Skriv DATA TIL LCD-DISPLAY
             LD     A,9            ; WRITE
             OUT    (PIOC),A
             LD     A,1            ; NO-WRITE
             OUT    (PIOC),A

             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,SKRIVAEND    ; SKRIV IKKE SERIAL
             LD     A,B            ; HENT KARAKTER
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER SERIELT.

SKRIVAEND:   LD     A,B            ; HENT KARAKTER
             POP    BC
             RET









;******************************************************************
;        SUB-RUTINE..: GFXSET                                     ;
;        Funktion....: Laver bruger grafik tegn i display         ;
;        Input.......: Intet                                      ;
;        Output......: Intet                                      ;
;        delgger...: A, HL                                      ;
;        Kalder......: DISPLAYBUSY+2                 TST 4-5-1994 ;
;******************************************************************
GFXSET:      PUSH   AF
             CALL   DISPLAYBUSY     ; Vent p display
             LD     A,0
             OUT    (PIOC),A
             LD     A,40H          ; Set grafik download
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL
             LD     A,0
             OUT    (PIOC),A

             LD     HL,GFX_TEGN
GFX_SETLP:   LD     A,(HL)
             CP     STOP           ; Test om stop
             JP     Z,GFXSLUT      ; Hop til SKRIVSLUT hvis stop-byte
             CALL   DISPLAYBUSY     ; Vent p at display er klar
             LD     A,01H
             OUT    (PIOC),A       ; Gr klar til data overfrsel
             LD     A,(HL)
             OUT    (PIOB),A       ; Skriv karakter P data busen
             LD     A,09H          ; ENABEL1
             OUT    (PIOC),A
             LD     A,01H
             OUT    (PIOC),A
             INC    HL             ; Peg p nste karakter
             JP     GFX_SETLP      ; Hop til SKRIVLOOP

             CALL   DISPLAYBUSY
             LD     A,0
             OUT    (PIOC),A
             LD     A,80H          ; SET TXT MODE
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL
             LD     A,0
             OUT    (PIOC),A

GFXSLUT:     POP    AF
             RET












;******************************************************************
;        SUB-RUTINE..: DISPLAYBUSY1                               ;
;        Funktion....: venter p at display er klar               ;
;        Input.......: Bittest p LCD-display                     ;
;        Output......: Intet                                      ;
;        delgger...: Intet                                      ;
;        Kalder......: BOUT, BIN                     TST 3-5-1994 ;
;******************************************************************
DISPLAYBUSY: PUSH   AF
DISLOOP1:    CALL   BIN
             LD     A,2
             OUT    (PIOC),A       ; READ, REGISTER
             LD     A,10           ; READ, REGISTER, ENABEL1
             OUT    (PIOC),A
             IN     A,(PIOB)       ; LS STATUS FRA DISPLAY
             BIT    7,A            ; Test busy bit nr. 7
             JP     NZ,DISLOOP1    ; Hop til DISLOOP indtil bit 7=0
             LD     A,1
             OUT    (PIOC),A       ; ENABEL INTET
             CALL   BOUT
             POP    AF
             RET





;******************************************************************
;        SUB-RUTINE..: CLS                                        ;
;        Funktion....: clear display og rykker cursor home        ;
;        Input.......: Intet                                      ;
;        Output......: Slettet display                            ;
;        delgger...: Intet                                      ;
;        Kalder......: GFXSET, LINE1                 TST 3-1-1996 ;
;******************************************************************
CLS:         PUSH   AF
             CALL   DISPLAYBUSY
             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,1            ; Display CLEAR
             OUT    (PIOB),A
             LD     A,8            ; VERSTE
             OUT    (PIOC),A
             LD     A,0
             OUT    (PIOC),A
             CALL   GFXSET         ; Det er ndvndigt, fordi ALT bliver
             CALL   LINE1          ; slettet ved 'Display reset'
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,CLS_END      ; SKRIV IKKE SERIAL
             LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
CLS_END:     POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: LINE1                                      ;
;        Funktion....: Flytter cursor til linje 1 (sletter ikke)  ;
;        Input.......: Intet                                      ;
;        Output......: Intet                                      ;
;        delgger...: Intet                                      ;
;        Kalder......: DISPLAYBUSY, SKRIV            TST 3-1-1996 ;
;******************************************************************
LINE1:       PUSH   AF
             CALL   DISPLAYBUSY     ; Vent p display
             LD     A,0
             OUT    (PIOC),A
             LD     A,80H          ; POSITION
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL 1
             LD     A,0
             OUT    (PIOC),A
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,LINE1_END    ; SKRIV IKKE SERIAL
             ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'1'          ; POS NEDAD
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$3b          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'1'          ; POS TIL hjer
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$48          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
LINE1_END:   POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: LINE2                                      ;
;        Funktion....: Flytter cursor til linje 2 (sletter ikke)  ;
;        Input.......: Intet                                      ;
;        Output......: Intet                                      ;
;        delgger...: Intet                                      ;
;        Kalder......: DISPLAYBUSY, SKRIV            TST 3-1-1996 ;
;******************************************************************
LINE2:       PUSH   AF
             CALL   DISPLAYBUSY    ; Vent p display
             LD     A,0
             OUT    (PIOC),A
             LD     A,0c0H         ; POSITION
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL 1
             LD     A,0
             OUT    (PIOC),A
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,LINE2_END    ; SKRIV IKKE SERIAL
             ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'2'          ; POS NEDAD DVS 2. LINJE
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$3b          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'1'          ; POS P LINJEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$48          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
LINE2_END:   POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: BLINK_ON                                   ;
;        Funktion....: Cursor on og blinker, p positionen        ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.  dato: 3/1-96                         ;
;******************************************************************
BLINK_ON:    PUSH   AF
             LD     A,0
             OUT    (PIOC),A      ; RS + write
             LD     A,0FH         ; Display on/off control - 00001DCB
             CALL   DISPLAYBUSY    ; ON, CURSOR, BLINK
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A      ; ENABEL
             LD     A,0
             OUT    (PIOC),A
             LD     A,1            ; MARKER HVILKEN TYPE CURSOR
             LD     (CURSORTYPE),A ; TIL DISPLAYCOPY-RESTORE RUTINEN
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,BLINKON_END  ; SKRIV IKKE SERIAL
             ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'1'          ; on
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$20          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$70
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
BLINKON_END: POP    AF
             RET



;******************************************************************
;        SUB-RUTINE..: BLINK_OFF                                  ;
;        Funktion....: Cursor slukkes                             ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.  dato: 17/10-93                       ;
;******************************************************************
CURSOR_OFF:
BLINK_OFF:   PUSH   AF
             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,0CH          ; Display on/off control - 00001DCB
             CALL   DISPLAYBUSY    ; CURSOR OFF, BLINK OFF
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL
             LD     A,0
             OUT    (PIOC),A
             LD     A,0            ; MARKER HVILKEN TYPE CURSOR
             LD     (CURSORTYPE),A ; TIL DISPLAYCOPY-RESTORE RUTINEN
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,BLINKOFFEND  ; SKRIV IKKE SERIAL
             ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'0'          ; off
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$20          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$70
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
BLINKOFFEND: POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: CURSOR_ON                                  ;
;        Funktion....: Cursor on p positionen (uden blink)       ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.  dato: 27/10-93                       ;
;******************************************************************
CURSOR_ON:   PUSH   AF
             LD     A,0
             OUT    (PIOC),A       ; RS + write
             LD     A,0EH          ; Display on/off control - 00001DCB
             CALL   DISPLAYBUSY    ; ON, CURSOR, BLINK
             OUT    (PIOB),A
             LD     A,8
             OUT    (PIOC),A       ; ENABEL
             LD     A,0
             OUT    (PIOC),A
             LD     A,2            ; MARKER HVILKEN TYPE CURSOR
             LD     (CURSORTYPE),A ; TIL DISPLAYCOPY-RESTORE RUTINEN
             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,CURSORONEND  ; SKRIV IKKE SERIAL
             ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,'1'          ; on
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$20          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$70          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
CURSORONEND: POP    AF
             RET




;******************************************************************
;        SUB-RUTINE..: GOTOPOS                                    ;
;        Funktion....: Cursor gr til position der er i A reg.    ;
;                      $00-                                       ;
;        Input.......: A reg. POS P LINJEN                       ;
;                    : B reg. LINJE 1-9 ASCII                     ;
;        delgger...: A reg.                                     ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.  dato: 17/10-93   (3/1-96)            ;
;******************************************************************
GOTOPOS:     PUSH   BC
             PUSH   DE
             PUSH   HL
             LD     C,A           ; GEM POS I C
             LD     A,B           ; HENT LINJEN
             CP     '2'           ; HVIS LINJE 2 S ADD $40 FOR LCD DISP.
             JP     Z,GOLINE2
             CP     '1'
             JP     Z,GOLINE1
             JP     GOLINEX       ; ALLE ANDRE LINJER ER KUN TIL COM PORTEN

GOLINEX:     LD     H,B           ; LINJEN TIL H
             JP     GOTO_L1

GOLINE2:     LD     A,C           ; HENT POS
             OR     $40           ; POS FOR LINJE 2 I LCD
             LD     H,B           ; HENT LINJEN
             JP     GOTOLCD
GOLINE1:     LD     A,C           ; HENT POS
GOTOLCD:     SET    7,A           ; Definer DD-RAM-Address-set
             LD     B,A           ; GEM POS TIL LCD

             LD     A,1
             OUT    (PIOC),A       ; KLARGR LCD CONTROL SIGNALER.
             LD     A,B            ; HENT LCD POS.
             CALL   DISPLAYBUSY
             OUT    (PIOB),A       ; ST POSITION P DISPLAY DATA BUS
             LD     A,8
             OUT    (PIOC),A       ; ENABEL
             LD     A,1
             OUT    (PIOC),A

             LD     A,(SER_ON)     ; SKAL DER SKRIVES P SERIAL ELLER HVAD?
             CP     0
             JP     Z,GOTOPOS_END  ; SKRIV IKKE SERIAL


             ; INPUT A=POS P LINJEN I BIN
             ; OUT   H=LINJE I ASCII   TIL TERMINAL POS 1 EL. 2
             ; OUT   L=POS TIER ASCII
             ; OUT   E=POS ENER ASCII

GOTO_L1:     LD     A,C
             INC    A             ; LCD POS 0 = POS 1, I EN TERMINAL
             AND    00111111B     ; ISOLER KUN POSITION P LINJE1
             LD     E,'0'         ; ENER = 0
             LD     L,'0'         ; TIER = 0
GOTOL1LP1:   CP     10            ; KAN DER TRKKES 10 FRA A ??
             JP     C,GOTOL1LP2   ; HVIS IKKE, PRV ENER
             SUB    10            ; DET KUNDE DER GODT, S TRK 10 FRA A
             INC    L             ; TIER +1
             JP     GOTOL1LP1
GOTOL1LP2:   CP     1             ; KAN DER TRKKES 1 FRA A ??
             JP     C,GOTOL1LP3   ; HVIS IKKE, AFSLUT
             SUB    1             ; DET KUNDE DER GODT, S TRK 1 FRA A
             INC    E             ; ENER +1
             JP     GOTOL1LP2
GOTOL1LP3:


GOTOCOM:     ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             ld     a,H            ; HENT LINJE I ASCII FORMAT
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             ld     a,$3b          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     A,L            ; HENT TIER POS P LINJEN I ASCII FORMAT
             CP     '0'
             JP     Z,GOTO_NO_TI

             CALL   TX_BUSY        ; MEST BETYDENE TAL (TIER) FRST
             OUT    (UART0),A      ; SEND TIER, HVIS IKKE '0'

GOTO_NO_TI:  LD     A,E            ; HENT ENER
             CALL   TX_BUSY        ;
             OUT    (UART0),A      ; SEND ENER ALTID.

             ld     a,$48          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

GOTOPOS_END: POP    HL
             POP    DE
             POP    BC
             RET




;******************************************************************
;        SUB-RUTINE..: GOTOPOSCOM til com porten                  ;
;        Funktion....: Cursor gr til position der er i regs.     ;
;        Input.......: B  POS P LINJEN ENER ASCII                ;
;                    : C  POS P LINJEN TIER ASCII                ;
;                    : D  LINJE         ENER ASCII                ;
;                    : E  LINJE         TIER ASCII                ;
;        Kalder......: TX_BUSY                                    ;
;        Initialer...: TST.  dato: 7/1-96                         ;
;******************************************************************
GOTOPOSCOM:  ld     a,$1b          ; esc
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             ld     a,$5b          ; [
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             ld     a,E            ; HENT LINJE TIER I ASCII FORMAT
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             ld     a,D            ; HENT LINJE ENER I ASCII FORMAT
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             ld     a,$3b          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     A,C            ; HENT POS TIER
             CALL   TX_BUSY        ;
             OUT    (UART0),A

             LD     A,B            ; HENT POS ENER
             CALL   TX_BUSY        ;
             OUT    (UART0),A

             ld     a,$48          ;
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             RET



;******************************************************************
;        SUB-RUTINE..: FINDPOS2   til linje 2                     ;
;        Funktion....: Cursor gr til per i top af ram9 A reg.    ;
;                      00 Linje1, c0H  Linje2                     ;
;                      Rutinen finder '>' og peger p den         ;
;        Input.......: HL peger p tekst som sedvanlig            ;
;        Output......: A reg.                                     ;
;        delgger...: A reg.                                     ;
;        Kalder......: DISPLAYBUSY                                ;
;        Initialer...: TST.  dato: 17/12-94                       ;
;******************************************************************
FINDPOS2:    PUSH   HL
             PUSH   DE
             PUSH   BC

             LD     B,40           ; antal karaktere pr. linje
FIND2_LP2:   LD     A,(HL)         ; Hent karakter til A
             CP     '>'
             JP     Z,FIND2_OK     ; Her er '>' fundet
             INC    HL             ; Peg p nste karakter
             DJNZ   FIND2_LP2      ; Hop til SKRIVLOOP
FIND2_OK:    LD     A,41
             SUB    B
             LD     B,'2'          ; LINJE2
             POP    BC
             POP    DE
             POP    HL
             RET




;******************************************************************
;        TX_SER                                                   *
;        Funktion....: Sender tekst og data p serielporten       *
;        Input.......: HL peger p tekst start adresse            *
;        Output......: Tekst p serielport                        *
;        delgger...: A,HL                                       *
;        Kalder......: TX_BUSY                      tst 28-4-1994 *
;******************************************************************
TX_SER:      PUSH   AF
             LD     A,(SER_ON)     ; HVIS COM ER OFF
             CP     0              ; SKRIVES DER IKKE..
             JP     Z,TX_SLUT
TX_SERLP:    LD     A,(HL)         ; Hent karakter til A
             CP     $ff            ; Test om teksten er slut
             JP     Z,TX_SLUT      ; Hop til TX SLUT hvis teksten er slut
             CALL   TX_BUSY        ; vent p uart er klar
             OUT    (UART0),A      ; Skriv karakter p serielporten
             INC    HL
             JP     TX_SERLP       ; Hop til TX LOOP
TX_SLUT:     POP    AF
             RET



;******************************************************************
;        RX_BUSY                                                  *
;        Funktion....: Venter p at UART har data i buffer        *
;        Input.......: Bit 0 fra UART'ens MODEM KONTROL REGISTER  *
;******************************************************************
RX_BUSY:     PUSH   AF
RX_BUSYLP:   IN     A,(UART5)      ; Ls Line Status Register
             BIT    0,A            ; Test om der er modtaget data
             JP     Z,RX_BUSYLP    ; vent til der er data
             POP    AF
             RET


;******************************************************************
;        TX_BUSY                                                  *
;        Funktion....: Venter p at UART har TX buffer fri        *
;        Input.......: Bit 5 fra UART'ens MODEM KONTROL REGISTER  *
;******************************************************************
TX_BUSY:     PUSH   AF
TX_BUSYLP:   IN     A,(UART5)     ; Ls Line Status Register
             BIT    5,A           ; Test om UART er klar til at sende
             JP     Z,TX_BUSYLP ; Hop til TX_BUSY indtil UART har bufferen fri
             POP    AF
             RET

NYLINJE:     LD     A,$0A
             CALL   TX_BUSY
             OUT    (UART0),A
             LD     A,$0D
             CALL   TX_BUSY
             OUT    (UART0),A
             RET

;*********************************************************************
;*        SUB-RUTINE..: SERIAL                                       *
;*        Funktion....: STYRER INPUT FRA IBM-PC KALDES FRA INTERRUPT *
;*        Input.......: POINTER TIL TXT: SER_POINT                   *
;*        Output......: MODTAGET TEXT I: SER_STRING                  *
;*        delgger...: A,BC,HL                                      *
;*        Kalder......: TX_BUSY                                      *
;*        Initialer...: TST. dato: 3/1-96                            *
;*********************************************************************
SERIAL:      LD     A,(SER_ON)     ; HVIS COM ER OFF
             CP     0              ; KAN DER IKKE STYRES + UDLSES
             JP     Z,SERIAL_END
             IN     A,(UART5)      ; Ls Line Status Register
             BIT    0,A            ; Test om der er modtaget data
             JP     Z,SERIAL_END   ; AFSLUT HVIS IKKE DATA I MODTAGE BUFFER
             IN     A,(UART0)      ; hent data
             CP     $0D
             JP     Z,SER_RETURN   ; HVIS DER ER TRYKKET RETURN, INTET ECHO
             CALL   TX_BUSY
             OUT    (UART0),A      ; ECHO
             LD     B,A            ; GEM MODTAGET KARAKTER

             LD     HL,SER_STRING  ; MODTAGET TEKST STRENG
             LD     A,(SER_POINT)  ; POINTER TIL HVOR DER SKAL GEMMES
SER_LP1:     INC    HL             ; INC HL, A ANTAL GANGE
             DEC    A
             JP     NZ,SER_LP1
             LD     A,B            ; HENT MODTAGET DATA
             LD     (HL),A         ; GEM KARAK. I STRING.
             LD     A,(SER_POINT)
             INC    A
             LD     (SER_POINT),A  ; PEG P NSTE PLADS
             CP     20
             JP     Z,SER_RETURN   ; HVIS 20 KARAKTERE LANG, S NULSTIL.
SERIAL_END:  RET

SER_RETURN:  LD     A,(DEBUG)
             CP     1
             JP     Z,DEBUG_ON
             LD     A,(HELP)
             CP     1
             JP     Z,HELP_ON       ; hvis on, s sl help fra.

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT    ; lav ny prompt
             CALL   TX_SER          ; og slet alt indtastet
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_RESET    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_RESET     ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_HELP1    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_HELP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_HELP2    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_HELP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_DEBUG    ; HER ER KOMANDOEN
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DEBUG     ; HVIS INPUT PASSER TIL COM_RESET  S..

SERIAL_REND: CALL   SER_SLET
             JP     SERIAL_END

;HER STR DE KOMANDOER DER DUER

COM_RESET:   .BYTE "RESET",$FF      ; SER_RESET
COM_DEBUG:   .BYTE "DEBUG",$FF      ;
COM_Q:       .BYTE "Q",$FF          ; QUIT DEBUGER
COM_H:       .BYTE "?",$FF          ; HELP DEBUG  MODE
COM_D:       .BYTE "D",$FF          ; DUMP ADRESSE
COM_HELP1:   .BYTE "H",$FF          ; HELP NORMAL MODE
COM_HELP2:   .BYTE "?",$FF          ; HELP NORMAL MODE
COM_E:       .BYTE "E",$FF          ; EDIT

COM_DL:      .BYTE "DOWNLOAD",$FF   ;
COM_UL:      .BYTE "UPLOAD",$FF     ;

SER_RESET:   CALL   SER_SLET
             LD     HL,TX_RESET
             CALL   TX_SER
             JP     0

SER_HELP:    LD     A,1
             LD     (HELP),A        ; MARKER HELP ER ON
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT
             CALL   TX_SER
             CALL   SER_SLET
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'6'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_HELP
             CALL   TX_SER          ; SKRIV DEBUG HELP SCREEN
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END


SER_DEBUG:   CALL   SER_SLET
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'6'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_DEBUG
             CALL   TX_SER          ; SKRIV DEBUG HELP SCREEN
             LD     A,1
             LD     (DEBUG),A       ; DEBUG ER NU ON
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END

HELP_ON:     LD     A,0
             LD     (HELP),A        ; SL HJELP FRA
             JP     SER_Q           ; SLET SKRM

DEBUG_ON:    LD     A,(DEBUG_EDIT)
             CP     1
             JP     Z,EDIT_DAT_IND

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_Q        ; Q = QUIT
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_Q         ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_H        ; ? = HELP
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DEBUG     ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_D        ; ? = HELP
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_DUMP      ; HVIS INPUT PASSER TIL COM_RESET  S..

             LD     HL,SER_STRING+1 ; modtaget tekst
             LD     BC,COM_E        ; E = EDIT
             CALL   SER_COMPARE
             CP     $FF
             JP     Z,SER_EDIT      ; HVIS INPUT PASSER TIL COM_RESET  S..

             CALL   SER_SLET
             JP     SERIAL_END


SER_EDIT:    LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     B,'0'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,SER_STRING+1 ; HER STARTER START ADR.
EDI_DU_FIND: INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC),A  ; GEM 1. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+1),A  ; GEM 2. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN+1)  ; HENT MEST BETYD NIBBLE
             ADD    A,C               ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD BYTE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+2),A  ; GEM 3. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN),A  ; GEM MEST BETYD NIBBLE I LOW

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDI_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+3),A  ; GEM 4. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN)  ; HENT MEST BETYD NIBBLE
             ADD    A,C             ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN),A  ; GEM MEST BETYD BYTE
             LD     A,$FF
             LD     (DUMP_A_ASC+4),A  ; GEM 5. KARAK ER STOP

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
             LD     HL,(DUMP_A_BIN) ; HER ER ADRESSEN MAN INDTASTEDE
             LD     A,(HL)          ; HENT DATA FRA ADRESSEN
             CALL   CONV_A2_ASC
             PUSH   HL
             LD     HL,DUMP_KARAK
             CALL   TX_SER
             POP    HL

             LD     A,','          ; KOMMA TIL INDTASTNING AF NY DATA
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     B,'9'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     A,1
             LD     (DEBUG_EDIT),A  ; ST EDIT DATA INPUT MODE
                                    ; TIL NSTE INDTASTNING
             CALL   SER_SLET
             JP     SERIAL_END



EDIT_DAT_IND:
             LD     HL,SER_STRING   ; HER STARTER START ADR.
             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDIT_DAT_FEJL
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (EDIT_BIN),A    ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,EDIT_DAT_FEJL
             LD     A,(EDIT_BIN)    ; HENT MEST BETYD NIBBLE
             ADD    A,C             ; ADDER DE TO NIBBLER
             LD     (EDIT_BIN),A    ; GEM MEST BETYD BYTE

             LD     HL,(DUMP_A_BIN) ; ADRESSEN MAN VILLE NDRE.
             LD     (HL),A          ; SKRIV BYTEN MAN INDTASTEDE
EDIT_DAT_FEJL:                      ; VED FEJL I INPUT DATA, GEMMES DER IKKE
             CALL   SER_SLET

             LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.

             LD     A,0
             LD     (DEBUG_EDIT),A ; AFSLUT EDIT DATA INPUT MODE
             JP     SER_DEBUG





SER_DUMP:    LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'7'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,SER_STRING+1 ; HER STARTER START ADR.
SER_DU_FIND: INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,SER_DU_FIND
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC),A  ; GEM 1. KARAK I ADRESSEN
             LD     A,C             ; OK FUNDET GODT TAL.
             SCF
             CCF
             RLCA
             RLCA
             RLCA
             RLCA
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD NIBBLE

             INC    HL
             LD     A,(HL)
             CALL   CHK_ASCII       ; B=ASCII C=HEX A=OK ELLER TALLET
             CP     $FF             ; FEJL IKKE 0-9 ELLER A-F
             JP     Z,DUMP_1TAL
             LD     A,B             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+1),A  ; GEM 2. KARAK I ADRESSEN
             LD     A,(DUMP_A_BIN+1)  ; HENT MEST BETYD NIBBLE
             ADD    A,C               ; ADDER DE TO NIBBLER
             LD     (DUMP_A_BIN+1),A  ; GEM MEST BETYD BYTE

DUMP_FUNDET: LD     A,'0'             ; OK FUNDET GODT TAL.
             LD     (DUMP_A_ASC+2),A  ; GEM 3. KARAK I ADRESSEN
             LD     (DUMP_A_ASC+3),A  ; GEM 4. KARAK I ADRESSEN
             LD     A,$FF
             LD     (DUMP_A_ASC+4),A  ; GEM 5. KARAK ER STOP
             LD     A,0
             LD     (DUMP_A_BIN),A   ;

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
             LD     HL,(DUMP_A_BIN) ; HER ER ADRESSEN MAN INDTASTEDE

             LD     B,16            ; ANTAL LINJER
DUMPLINJER:  PUSH   BC              ; GEM ANTAL LINJER

             LD     B,16            ; ANTAL HEX TAL PR. LINJE
             LD     D,H
             LD     E,L             ; GEM START AF LINJE, TIL ASC-DUMP
DUMPLINE_HX: LD     A,(HL)          ; HENT DATA FRA ADRESSEN
             CALL   CONV_A2_ASC     ; KONVERT TIL ACSII, I 2 CIFRE
             PUSH   HL              ; GEM ADRESSE-DUMP TLLER
             LD     HL,DUMP_KARAK   ; PEG P ASCII, DER ER HEX TALLET KONV.
             CALL   TX_SER
             POP    HL              ; HENT ADRESSE-DUMP TLLER
             INC    HL              ; NSTE ADR.
             DJNZ   DUMPLINE_HX     ; DUMP IGEN, INDTIL DER ER SKREVET-
                                    ; 16 HEX TAL P LINJEN
             LD     B,3
             LD     A,' '
DUMP3SP:     CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             DJNZ   DUMP3SP        ; 3 SPACES
             PUSH   HL
             LD     H,D
             LD     L,E            ; HENT START AF LINJEN

             LD     B,16           ; ANTAL ASCII DUMP PR. LINJE
DUMPLINEAS:  LD     A,(HL)
             JP     DUMP_CHECK
DUMP_UD:     CALL   TX_BUSY
             OUT    (UART0),A
             INC    HL
             DJNZ   DUMPLINEAS

             POP    HL             ; RESTORE HL TIL NSTE LINJE

             CALL   NYLINJE

             PUSH   HL
             LD     HL,DUMP_A_ASC+2  ; TIER ADR. ASCII
             LD     A,(HL)         ; DEN TLLER JO OP..
             INC    A
             CP     ':'            ; KARAKTER EFTER '9'
             JP     Z,DET_ER_A
             CP     'G'
             JP     Z,DET_ER_G
ALLE_ASCII:  LD     (HL),A

             LD     HL,DUMP_A_ASC
             CALL   TX_SER
DUMP_OVER:   POP    HL             ; RESTORE PEGER P ADR.

             POP    BC             ; HENT ANTAL LINJER
             DJNZ   DUMPLINJER

             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_D_PROMPT  ; DEBUG PROMPT
             CALL   TX_SER
             LD     B,'2'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'5'           ; LINJE ENER
             LD     E,'1'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC

             CALL   SER_SLET
             JP     SERIAL_END

DET_ER_A:    LD     A,'A'
             JP     ALLE_ASCII
DET_ER_G:    LD     A,'F'
             JP     DUMP_OVER
DUMP_CHECK:  CP     $FF
             JP     Z,DUMP_SP
             CP     $00
             JP     Z,DUMP_SP
             CP     $05
             JP     Z,DUMP_SP
             CP     $07
             JP     Z,DUMP_SP
             CP     $08
             JP     Z,DUMP_SP
             CP     $09
             JP     Z,DUMP_SP
             CP     $0A
             JP     Z,DUMP_SP
             CP     $0B
             JP     Z,DUMP_SP
             CP     $0C
             JP     Z,DUMP_SP
             CP     $0D
             JP     Z,DUMP_SP
             CP     $13
             JP     Z,DUMP_SP
             CP     $14
             JP     Z,DUMP_SP
             CP     $15
             JP     NZ,DUMP_UD
DUMP_SP:     LD     A,'.'        ; DEN PRIK DER SKRIVES, NR DER ER DUM ASCII
             JP     DUMP_UD

DUMP_1TAL:   LD     A,'0'            ; HVIS MAN KUN TASTER 1 TAL, I ADRESSEN
             LD     (DUMP_A_ASC),A   ; VIL DEN VLGE ADR=0000
             LD     (DUMP_A_ASC+1),A
             LD     A,0
             LD     (DUMP_A_BIN+1),A
             JP     DUMP_FUNDET

SER_Q:       LD     A,0
             LD     (DEBUG),A      ; DEBUG ER NU AFSLUTTET
             CALL   SER_SLET
             LD     A,$0C          ; CLEAR SCREEN KODEN
             CALL   TX_BUSY
             OUT    (UART0),A      ; SEND KARAKTER.
             LD     B,'1'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             LD     HL,TX_PROMPT
             CALL   TX_SER
             LD     B,'4'           ; POS ENER
             LD     C,'0'           ; POS TIER
             LD     D,'4'           ; LINJE ENER
             LD     E,'0'           ; LINJE TIER
             CALL   GOTOPOSCOM      ; FLYT CURSOR P PC
             JP     SERIAL_END


SER_SLET:    PUSH   HL       ; DENNE SUB, SLETTER DEN MODTAGNE STRING.
             PUSH   BC       ; FRA MODTAGE BUFFER P 20 BYTES.
             PUSH   AF
             LD     HL,SER_STRING
             LD     B,20           ; ANTAL KARAKTERE DER SKAL SLETTES
             LD     A,0
SER_SLETLP:  LD     (HL),A
             INC    HL
             DJNZ   SER_SLETLP
             LD     A,1
             LD     (SER_POINT),A  ; KLAR P 1. PLADS I BUFFER
             POP    AF
             POP    BC
             POP    HL
             RET


SER_COMPARE: LD     A,(BC) ; KENNY RULEZ!!!!!
             CP     $FF
             JP     Z,SER_COMP_OK
             CP     (HL)
             JP     NZ,SER_COMP_NO
             INC    HL
             INC    BC
             JP     SER_COMPARE
SER_COMP_NO: LD     A,0
SER_COMP_OK: RET


CONV_A2_ASC: PUSH   HL
             PUSH   BC
             PUSH   DE
             LD     B,A
             LD     HL,DUMP_KARAK
             LD     A,' '
             LD     (HL),A
             INC    HL
             LD     A,B
             RRCA                  ; A ER INPUT HEV TAL I 8 BIT
             RRCA                  ; HL PEGER P STED HVOR ASCII GEMMES
             RRCA                  ; FOR MESTE NIBBLE
             RRCA
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A
             SUB    10             ; DEC ELLER HEX??
             JP     NC,CONV_HX
             LD     A,D
             ADD    A,$30
             JP     CONV_UD
CONV_HX:     ADD    A,$41
CONV_UD:     LD     (HL),A
             INC    HL
             LD     A,B            ; TALLET DER SKAL KONVERTERES
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A            ; FOR LAVESTE NIBBLE
             SUB    10
             JP     NC,CONV_HX1
             LD     A,D
             ADD    A,$30
             JP     CONV_UD1
CONV_HX1:    ADD    A,$41
CONV_UD1:    LD     (HL),A
             INC    HL
             LD     A,$FF          ; STOP
             LD     (HL),A
             POP    DE
             POP    BC
             POP    HL
             RET

                             ; A=INPUT
CHK_ASCII:   CP     '0'      ; OUTPUT B=ASCII C=HEX (A=$FF FEJL, ELLER TALLET)
             JP     Z,CHK_0
             CP     '1'
             JP     Z,CHK_1
             CP     '2'
             JP     Z,CHK_2
             CP     '3'
             JP     Z,CHK_3
             CP     '4'
             JP     Z,CHK_4
             CP     '5'
             JP     Z,CHK_5
             CP     '6'
             JP     Z,CHK_6
             CP     '7'
             JP     Z,CHK_7
             CP     '8'
             JP     Z,CHK_8
             CP     '9'
             JP     Z,CHK_9
             CP     'A'
             JP     Z,CHK_A
             CP     'B'
             JP     Z,CHK_B
             CP     'C'
             JP     Z,CHK_C
             CP     'D'
             JP     Z,CHK_D
             CP     'E'
             JP     Z,CHK_E
             CP     'F'
             JP     Z,CHK_F
             CP     'a'
             JP     Z,CHK_A
             CP     'b'
             JP     Z,CHK_B
             CP     'c'
             JP     Z,CHK_C
             CP     'd'
             JP     Z,CHK_D
             CP     'e'
             JP     Z,CHK_E
             CP     'f'
             JP     Z,CHK_F
             LD     A,$FF
             RET
CHK_0:       LD     C,0
             LD     B,'0'
             RET
CHK_1:       LD     C,1
             LD     B,'1'
             RET
CHK_2:       LD     C,2
             LD     B,'2'
             RET
CHK_3:       LD     C,3
             LD     B,'3'
             RET
CHK_4:       LD     C,4
             LD     B,'4'
             RET
CHK_5:       LD     C,5
             LD     B,'5'
             RET
CHK_6:       LD     C,6
             LD     B,'6'
             RET
CHK_7:       LD     C,7
             LD     B,'7'
             RET
CHK_8:       LD     C,8
             LD     B,'8'
             RET
CHK_9:       LD     C,9
             LD     B,'9'
             RET
CHK_A:       LD     C,$A
             LD     B,'A'
             RET
CHK_B:       LD     C,$B
             LD     B,'B'
             RET
CHK_C:       LD     C,$C
             LD     B,'C'
             RET
CHK_D:       LD     C,$D
             LD     B,'D'
             RET
CHK_E:       LD     C,$E
             LD     B,'E'
             RET
CHK_F:       LD     C,$F
             LD     B,'F'
             RET



.include nicd2txt.asm
.include nicd2smp.asm



;************************************************************************
;*        SUB.RUTINE..: CHECKSUM                                        *
;*        Funktion....: Tester om der er fejl i eprommen                *
;*        Input.......: check sum der er beregnet i forvejen            *
;*        Output......:                                                 *
;*        delgger...: AF, BC, DE, HL                                  *
;*        Kalder......: INGEN                                           *
;*        Initialer...: TST.  dato: 27/12-95                            *
;* kr frst LAVFINAL.. I bank0's navn bliver check summen udskrevet,   *
;* den frste byte er HI 8, du finder tilsvarende data i eprommen,      *
;* der hvor data ER, tastes ind i CHK_POINT_B, der er pointer til data  *
;* det samme gres for den nste byte...                                *
;* derefter sttes, bde LAVFINAL OG FINAL, og slut prut                *
;************************************************************************
CHECKSUM:    LD     HL,0           ; EPROM START
             LD     A,L
             LD     BC,0           ; nulstil
             LD     DE,0

CHECK_LP:    LD     A,(HL)         ; HENT DATA FRA EPROM
             CP     $EF
             JP     Z,CHECK_1      ; sg efter anden end string
             LD     C,A
             LD     A,E            ; HENT LAVESTE 8 BIT
             ADD    A,C            ; LG LSTE TIL FOREGENDE
             JP     C,CHECK_AD

CHECK_OK:    LD     E,A            ; GEM LAVESTE 8 BIT
             INC    HL
             JP     CHECK_LP

CHECK_1:     INC    HL             ; her matcher frste byte i slut ordet
             LD     A,(HL)
             CP     $FE
             JP     Z,CHECK_SSLUT  ; her matcher anden byte i slut orde
             INC    HL
             JP     CHECK_LP

CHECK_AD:    INC    B              ; HER ER DE 8 HJESTE
             JP     CHECK_OK

             NOP                   ; Sikkerhed for at den skal kunne finde-
             NOP                   ; stop ordet.
.BYTE        $EF,$FE               ; Dummy til at stoppe checksum sgeren med.

CHECK_SSLUT:
.IF FINAL=1
             LD     HL,0           ; mling bliver bare mistet
.ELSE
             LD     HL,$9001       ; mling gemmes i bank0's navn
.ENDIF
             LD     C,E
             LD     A,'$'          ; B=HI 8 BIT
             LD     (HL),A         ; C=LO 8 BIT
             LD     HL,CHK_POINT_B ; pointer til hi 8-bit B
             LD     A,(HL)         ; hent rigtig checksum
             CP     B
             JP     NZ,CHECKFEJL
             LD     HL,CHK_POINT_C ; pointer til lo 8-bit C
             LD     A,(HL)         ; hent rigtig checksum
             CP     C
             JP     NZ,CHECKFEJL
             JP     CHECK_SLUT2

CHECKFEJL:   PUSH   BC             ; mlt checksum gemmes til udskrivning
             CALL   CLS
             LD     HL,TXT_CHECKA  ; eprom checksum fejl besked
             CALL   SKRIV
             CALL   LYDFADER       ; GIVER LYD VED FEJL
             LD     BC,5000
             CALL   PAUSE
             POP    BC
.IF FINAL=1
             DI
             HALT
.ELSE
             NOP                   ; svarer til DI & HALT
             NOP                   ; ellers fuckker den checksummen..
.ENDIF                             ; her skal der fortsttes ved "fejl"
                                   ; s der udskrives mlt checksum.
CHECK_SLUT2:
.IF FINAL=1
             LD     HL,0           ; gem bare her, det er ligemeget,
.ELSE                              ; der skal bare gemmes et eller andet-
                                   ; s lngten er den samme p programmet.
             LD     HL,$9002       ; Bank0
.ENDIF
; HER ER B REG KONVERTERING TIL ASCII UDSKRIVNING
             LD     A,B            ; TALLET DER SKAL KONVERTERES
             RRCA
             RRCA                  ; ROTATE RIGHT
             RRCA                  ; FOR MESTE NIBBLE
             RRCA
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A
             SUB    10             ; DEC ELLER HEX??
             JP     NC,CHECK_HX
             LD     A,D
             ADD    A,$30
             JP     CHECK_UD
CHECK_HX:    ADD    A,$41
CHECK_UD:    LD     (HL),A
             INC    HL
             LD     A,B            ; TALLET DER SKAL KONVERTERES
             AND    $0F            ; ISOLER 4 LAVESTE BITS
             LD     D,A            ; FOR LAVESTE NIBBLE
             SUB    10
             JP     NC,CHECK_HX1
             LD     A,D
             ADD    A,$30
             JP     CHECK_UD1
CHECK_HX1:   ADD    A,$41
CHECK_UD1:   LD     (HL),A
             INC    HL
; HER ER C REG KONVERTERING
             LD     A,C            ; TALLET DER SKAL KONVERTERES
             RRCA
             RRCA
             RRCA
             RRCA
             AND    $0F
             LD     D,A
             SUB    10
             JP     NC,CHECK_HX2
             LD     A,D
             ADD    A,$30
             JP     CHECK_UD2
CHECK_HX2    ADD    A,$41
CHECK_UD2    LD     (HL),A
             INC    HL
             LD     A,C
             AND    $0F
             LD     D,A
             SUB    10
             JP     NC,CHECK_HX3
             LD     A,D
             ADD    A,$30
             JP     CHECK_UD3
CHECK_HX3:   ADD    A,$41
CHECK_UD3:   LD     (HL),A
             RET

 .text "\n\r  -END-OF-FILE-  \n\r"
 .end

